/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.serialize;

import com.google.common.base.Preconditions;
import com.xebialabs.xltest.serialize.BasicMessageBodyWriter;
import com.xebialabs.xltest.service.ExecutionProgressEvent;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.core.MediaType;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionProgressEventWriter
extends BasicMessageBodyWriter<ExecutionProgressEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionProgressEventWriter.class);

    @Override
    protected void writeJson(ExecutionProgressEvent instance, JSONWriter writer) throws JSONException {
        LOG.debug("ExecutionProgressEvent: {}", (Object)instance);
        writer.object();
        writer.key("name").value((Object)instance.getName());
        writer.key("status").value((Object)instance.getStatus());
        writer.key("message").value((Object)instance.getMessage());
        writer.key("percentage").value((long)instance.getPercentage());
        writer.key("timeLeft").value(instance.getTimeLeft());
        writer.endObject();
    }

    public String serialize(ExecutionProgressEvent event) throws JSONException {
        Preconditions.checkNotNull((Object)event, (Object)"Cannot serialize null event");
        StringWriter stringWriter = new StringWriter();
        JSONWriter writer = new JSONWriter((Writer)stringWriter);
        this.writeJson(event, writer);
        return stringWriter.toString();
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ExecutionProgressEvent.class.isAssignableFrom(type);
    }
}

