/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.service;

import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xltest.domain.TestTool;
import com.xebialabs.xltest.repository.HostRepository;
import com.xebialabs.xltest.repository.TestToolRepository;
import com.xebialabs.xltest.utils.glob.FileMatcher;
import java.util.Collection;
import java.util.SortedSet;

public class TestResultLocator {
    private final TestToolRepository testToolRepository;
    private Host host;
    private TestTool testTool;

    public TestResultLocator(TestToolRepository testToolRepository) {
        this.testToolRepository = testToolRepository;
    }

    public TestResultLocator forHost(String type, String address, String username, String password) {
        this.host = HostRepository.create(type, address, username, password);
        return this;
    }

    public TestResultLocator forTestTool(String testToolName) {
        this.testTool = this.testToolRepository.findByName(testToolName);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<OverthereFile> locate(String baseDir, String pattern) {
        try (OverthereConnection connection = this.host.getConnection();){
            SortedSet<OverthereFile> sortedSet = this.testTool.findTestResultPaths(connection.getFile(baseDir), new FileMatcher(pattern));
            return sortedSet;
        }
    }

    public Host getHost() {
        return this.host;
    }
}

