/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.jmeter;

import com.google.common.primitives.Longs;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xltest.domain.ImportException;
import com.xebialabs.xltest.domain.PerformanceResultsSummary;
import com.xebialabs.xltest.domain.SamplingPerformanceResultsSummary;
import com.xebialabs.xltest.importers.AbstractPerformanceSummaryResultsImporter;
import com.xebialabs.xltest.jmeter.JMeterImportFailedException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class JMeterCsvImporter
extends AbstractPerformanceSummaryResultsImporter {
    public static final int COLUMN_TIMESTAMP = 0;
    public static final int COLUMN_ELAPSED = 1;
    public static final int COLUMN_SAMPLE_RESULT = 7;
    private final OverthereFile jmeterCsvFile;

    public JMeterCsvImporter(OverthereFile jmeterCsvFile) {
        this.jmeterCsvFile = jmeterCsvFile;
    }

    public long getTimestamp() {
        return this.jmeterCsvFile.lastModified();
    }

    public String getImportablePath() {
        return this.jmeterCsvFile.getPath();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PerformanceResultsSummary constructPerformanceResultsSummary() throws ImportException {
        boolean parsedHeader = false;
        SamplingPerformanceResultsSummary performanceResultsSummary = new SamplingPerformanceResultsSummary();
        try (InputStreamReader in = new InputStreamReader(this.jmeterCsvFile.getInputStream(), StandardCharsets.UTF_8);){
            CSVParser records = CSVFormat.DEFAULT.parse((Reader)in);
            for (CSVRecord record : records) {
                String sampleResult = record.get(7);
                Long timestamp = Longs.tryParse((String)record.get(0));
                if (timestamp == null) {
                    if (parsedHeader) throw new JMeterImportFailedException("Line " + record.getRecordNumber() + " does not contain a valid timestamp.", record.toString());
                    parsedHeader = true;
                    continue;
                }
                long elapsed = Long.parseLong(record.get(1));
                performanceResultsSummary.updateWithSample(timestamp.longValue(), elapsed, sampleResult);
            }
            SamplingPerformanceResultsSummary samplingPerformanceResultsSummary = performanceResultsSummary;
            return samplingPerformanceResultsSummary;
        }
        catch (JMeterImportFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JMeterImportFailedException("Failed to import CSV sample data", e);
        }
    }

    public String toString() {
        return String.format("JMeterCsvImporter(%s)", this.jmeterCsvFile);
    }
}

