/*
 * Decompiled with CFR 0.152.
 */
package spray.http;

import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple9;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import spray.http.DateTime;

public final class DateTime$
implements Serializable {
    public static final DateTime$ MODULE$;
    private final String[] WEEKDAYS;
    private final String[] MONTHS;
    private final DateTime MinValue;
    private final DateTime MaxValue;

    static {
        new DateTime$();
    }

    public String[] WEEKDAYS() {
        return this.WEEKDAYS;
    }

    public String[] MONTHS() {
        return this.MONTHS;
    }

    public DateTime MinValue() {
        return this.MinValue;
    }

    public DateTime MaxValue() {
        return this.MaxValue;
    }

    public DateTime apply(int year, int month, int day, int hour, int minute, int second) {
        boolean isLeap;
        Predef$.MODULE$.require(1800 <= year && year <= 9999, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "year must be >= 1800 and <= 9999";
            }
        });
        Predef$.MODULE$.require(1 <= month && month <= 12, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "month must be >= 1 and <= 12";
            }
        });
        Predef$.MODULE$.require(1 <= day && day <= 31, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "day must be >= 1 and <= 31";
            }
        });
        Predef$.MODULE$.require(0 <= hour && hour <= 23, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "hour must be >= 0 and <= 23";
            }
        });
        Predef$.MODULE$.require(0 <= minute && minute <= 59, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "minute_ must be >= 0 and <= 59";
            }
        });
        Predef$.MODULE$.require(0 <= second && second <= 59, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "second must be >= 0 and <= 59";
            }
        });
        int m = month - 1;
        int d = m % 7 * 30 + (m % 7 + 1) / 2 + day;
        boolean bl = isLeap = year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
        if (m >= 7) {
            d += 214;
        }
        if (d >= 61) {
            --d;
        }
        if (!isLeap && d >= 60) {
            --d;
        }
        int y = year - 1;
        int dn = (d += y * 365 + y / 4 - y / 100 + y / 400) - 719162;
        long c = (long)(dn - 1) * 86400L + (long)hour * 3600L + (long)minute * 60L + (long)second;
        return new DateTime(year, month, day, hour, minute, second, d % 7, c * 1000L, isLeap);
    }

    public DateTime apply(long clicks) {
        boolean isLeap;
        long c;
        Predef$.MODULE$.require(this.MinValue().clicks() <= clicks && clicks <= this.MaxValue().clicks(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringBuilder().append((Object)"DateTime value must be >= ").append((Object)DateTime$.MODULE$.MinValue()).append((Object)" and <= ").append((Object)DateTime$.MODULE$.MaxValue()).toString();
            }
        });
        long s2 = c = clicks - clicks % 1000L;
        s2 = s2 >= 0L ? (s2 /= 1000L) : (s2 - 999L) / 1000L;
        int dn = (int)(s2 / 86400L);
        if ((s2 %= 86400L) < 0L) {
            s2 += 86400L;
            --dn;
        }
        int y = 400 * ((dn += 719162) / 146097) + 1;
        int d = dn % 146097;
        if (d == 146096) {
            y += 399;
            d = 365;
        } else {
            y += 100 * (d / 36524);
            y += 4 * ((d %= 36524) / 1461);
            if ((d %= 1461) == 1460) {
                y += 3;
                d = 365;
            } else {
                y += d / 365;
                d %= 365;
            }
        }
        boolean bl = isLeap = y % 4 == 0 && y % 100 != 0 || y % 400 == 0;
        if (!isLeap && d >= 59) {
            ++d;
        }
        if (d >= 60) {
            ++d;
        }
        int mon = d % 214 / 61 * 2 + d % 214 % 61 / 31;
        if (d > 213) {
            mon += 7;
        }
        d = d % 214 % 61 % 31 + 1;
        int m = (int)(s2 / 60L);
        int h = m / 60;
        int w = (dn + 1) % 7;
        return new DateTime(y, mon + 1, d, h, m %= 60, (int)(s2 %= 60L), w, c, isLeap);
    }

    public int apply$default$4() {
        return 0;
    }

    public int apply$default$5() {
        return 0;
    }

    public int apply$default$6() {
        return 0;
    }

    public DateTime now() {
        return this.apply(System.currentTimeMillis());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Option<DateTime> fromIsoDateTimeString(String string) {
        None$ none$;
        if (!this.check$1(string.length(), string)) {
            none$ = None$.MODULE$;
            return none$;
        }
        try {
            int year = this.i$1(0, string) * 1000 + this.i$1(1, string) * 100 + this.i$1(2, string) * 10 + this.i$1(3, string);
            int month = this.i$1(5, string) * 10 + this.i$1(6, string);
            int day = this.i$1(8, string) * 10 + this.i$1(9, string);
            int hour = this.i$1(11, string) * 10 + this.i$1(12, string);
            int min2 = this.i$1(14, string) * 10 + this.i$1(15, string);
            int sec = this.i$1(17, string) * 10 + this.i$1(18, string);
            none$ = new Some((Object)this.apply(year, month, day, hour, min2, sec));
            return none$;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public DateTime apply(int year, int month, int day, int hour, int minute, int second, int weekday, long clicks, boolean isLeapYear) {
        return new DateTime(year, month, day, hour, minute, second, weekday, clicks, isLeapYear);
    }

    public Option<Tuple9<Object, Object, Object, Object, Object, Object, Object, Object, Object>> unapply(DateTime x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple9((Object)BoxesRunTime.boxToInteger((int)x$0.year()), (Object)BoxesRunTime.boxToInteger((int)x$0.month()), (Object)BoxesRunTime.boxToInteger((int)x$0.day()), (Object)BoxesRunTime.boxToInteger((int)x$0.hour()), (Object)BoxesRunTime.boxToInteger((int)x$0.minute()), (Object)BoxesRunTime.boxToInteger((int)x$0.second()), (Object)BoxesRunTime.boxToInteger((int)x$0.weekday()), (Object)BoxesRunTime.boxToLong((long)x$0.clicks()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.isLeapYear())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final char c$1(int ix, String string$1) {
        return string$1.charAt(ix);
    }

    private final boolean isDigit$1(char c) {
        return '0' <= c && c <= '9';
    }

    private final int i$1(int ix, String string$1) {
        char x = this.c$1(ix, string$1);
        Predef$.MODULE$.require(this.isDigit$1(x));
        return x - 48;
    }

    private final boolean check$1(int len, String string$1) {
        boolean bl;
        int n = len;
        switch (n) {
            default: {
                bl = false;
                break;
            }
            case 24: {
                if (this.check$1(19, string$1) && this.c$1(19, string$1) == '.' && this.isDigit$1(this.c$1(20, string$1)) && this.isDigit$1(this.c$1(21, string$1)) && this.isDigit$1(this.c$1(22, string$1)) && this.c$1(23, string$1) == 'Z') {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 19: {
                bl = this.c$1(4, string$1) == '-' && this.c$1(7, string$1) == '-' && this.c$1(10, string$1) == 'T' && this.c$1(13, string$1) == ':' && this.c$1(16, string$1) == ':';
            }
        }
        return bl;
    }

    private DateTime$() {
        MODULE$ = this;
        this.WEEKDAYS = (String[])((Object[])new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"});
        this.MONTHS = (String[])((Object[])new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"});
        this.MinValue = this.apply(1800, 1, 1, this.apply$default$4(), this.apply$default$5(), this.apply$default$6());
        this.MaxValue = this.apply(2199, 12, 31, 23, 59, 59);
    }
}

