/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderPrepareCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.transaction.WriteSkewHelper;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.util.concurrent.locks.containers.ReentrantPerEntryLockContainer;

@Scope(value=Scopes.NAMED_CACHE)
public interface ClusteringDependentLogic {
    public static final Address LOCAL_MODE_ADDRESS = new Address(){

        public String toString() {
            return "Local Address";
        }

        @Override
        public int compareTo(Address o) {
            return 0;
        }
    };

    public boolean localNodeIsOwner(Object var1);

    public boolean localNodeIsPrimaryOwner(Object var1);

    public Address getPrimaryOwner(Object var1);

    public void commitEntry(CacheEntry var1, Metadata var2, FlagAffectedCommand var3, InvocationContext var4);

    public List<Address> getOwners(Collection<Object> var1);

    public List<Address> getOwners(Object var1);

    public EntryVersionsMap createNewVersionsAndCheckForWriteSkews(VersionGenerator var1, TxInvocationContext var2, VersionedPrepareCommand var3);

    public Address getAddress();

    public boolean lock(Object var1, boolean var2) throws InterruptedException;

    public void unlock(Object var1);

    public static class DistributionLogic
    extends AbstractClusteringDependentLogic {
        private DistributionManager dm;
        private Configuration configuration;
        private RpcManager rpcManager;
        private StateTransferLock stateTransferLock;

        @Inject
        public void init(DistributionManager dm, Configuration configuration, RpcManager rpcManager, StateTransferLock stateTransferLock) {
            this.dm = dm;
            this.configuration = configuration;
            this.rpcManager = rpcManager;
            this.stateTransferLock = stateTransferLock;
        }

        @Override
        public boolean localNodeIsOwner(Object key) {
            return this.dm.getLocality(key).isLocal();
        }

        @Override
        public Address getAddress() {
            return this.rpcManager.getAddress();
        }

        @Override
        public boolean localNodeIsPrimaryOwner(Object key) {
            Address address = this.rpcManager.getAddress();
            return this.dm.getPrimaryLocation(key).equals(address);
        }

        @Override
        public Address getPrimaryOwner(Object key) {
            return this.dm.getPrimaryLocation(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commitEntry(CacheEntry entry, Metadata metadata, FlagAffectedCommand command, InvocationContext ctx) {
            this.stateTransferLock.acquireSharedTopologyLock();
            try {
                boolean isForeignOwned;
                boolean doCommit = true;
                boolean skipOwnershipCheck = command != null && command.hasFlag(Flag.SKIP_OWNERSHIP_CHECK);
                boolean bl = isForeignOwned = !skipOwnershipCheck && !this.localNodeIsOwner(entry.getKey());
                if (isForeignOwned && !entry.isRemoved()) {
                    if (this.configuration.clustering().l1().enabled()) {
                        long lifespan = metadata != null ? metadata.lifespan() : entry.getLifespan();
                        if (lifespan < 0L || lifespan > this.configuration.clustering().l1().lifespan()) {
                            Metadata newMetadata;
                            Metadata.Builder builder = metadata != null ? metadata.builder() : entry.getMetadata().builder();
                            metadata = newMetadata = builder.lifespan(this.configuration.clustering().l1().lifespan()).build();
                        }
                    } else {
                        doCommit = false;
                    }
                }
                boolean created = false;
                boolean removed = false;
                boolean evicted = false;
                if (!isForeignOwned) {
                    created = entry.isCreated();
                    removed = entry.isRemoved();
                    evicted = entry.isEvicted();
                }
                if (doCommit) {
                    this.commitCacheEntry(entry, metadata);
                } else {
                    entry.rollback();
                }
                if (!isForeignOwned) {
                    this.notifyCommitEntry(created, removed, evicted, entry, ctx, command);
                }
            }
            finally {
                this.stateTransferLock.releaseSharedTopologyLock();
            }
        }

        @Override
        public List<Address> getOwners(Collection<Object> affectedKeys) {
            if (affectedKeys.isEmpty()) {
                return InfinispanCollections.emptyList();
            }
            return Immutables.immutableListConvert(this.dm.locateAll(affectedKeys));
        }

        @Override
        public List<Address> getOwners(Object key) {
            return Immutables.immutableListConvert(this.dm.locate(key));
        }

        @Override
        protected WriteSkewHelper.KeySpecificLogic initKeySpecificLogic(boolean totalOrder) {
            return totalOrder ? new WriteSkewHelper.KeySpecificLogic(){

                @Override
                public boolean performCheckOnKey(Object key) {
                    return DistributionLogic.this.localNodeIsOwner(key);
                }
            } : new WriteSkewHelper.KeySpecificLogic(){

                @Override
                public boolean performCheckOnKey(Object key) {
                    return DistributionLogic.this.localNodeIsPrimaryOwner(key);
                }
            };
        }
    }

    public static class ReplicationLogic
    extends InvalidationLogic {
        private StateTransferLock stateTransferLock;

        @Inject
        public void init(StateTransferLock stateTransferLock) {
            this.stateTransferLock = stateTransferLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commitEntry(CacheEntry entry, Metadata metadata, FlagAffectedCommand command, InvocationContext ctx) {
            this.stateTransferLock.acquireSharedTopologyLock();
            try {
                super.commitEntry(entry, metadata, command, ctx);
            }
            finally {
                this.stateTransferLock.releaseSharedTopologyLock();
            }
        }

        @Override
        protected WriteSkewHelper.KeySpecificLogic initKeySpecificLogic(boolean totalOrder) {
            return totalOrder ? new WriteSkewHelper.KeySpecificLogic(){

                @Override
                public boolean performCheckOnKey(Object key) {
                    return true;
                }
            } : new WriteSkewHelper.KeySpecificLogic(){

                @Override
                public boolean performCheckOnKey(Object key) {
                    return ReplicationLogic.this.localNodeIsPrimaryOwner(key);
                }
            };
        }
    }

    public static class InvalidationLogic
    extends AbstractClusteringDependentLogic {
        private StateTransferManager stateTransferManager;
        private RpcManager rpcManager;

        @Inject
        public void init(RpcManager rpcManager, StateTransferManager stateTransferManager) {
            this.rpcManager = rpcManager;
            this.stateTransferManager = stateTransferManager;
        }

        @Override
        public boolean localNodeIsOwner(Object key) {
            return this.stateTransferManager.getCacheTopology().getWriteConsistentHash().isKeyLocalToNode(this.rpcManager.getAddress(), key);
        }

        @Override
        public boolean localNodeIsPrimaryOwner(Object key) {
            return this.stateTransferManager.getCacheTopology().getWriteConsistentHash().locatePrimaryOwner(key).equals(this.rpcManager.getAddress());
        }

        @Override
        public Address getPrimaryOwner(Object key) {
            return this.stateTransferManager.getCacheTopology().getWriteConsistentHash().locatePrimaryOwner(key);
        }

        @Override
        public void commitEntry(CacheEntry entry, Metadata metadata, FlagAffectedCommand command, InvocationContext ctx) {
            boolean created = entry.isCreated();
            boolean removed = entry.isRemoved();
            boolean evicted = entry.isEvicted();
            this.commitCacheEntry(entry, metadata);
            this.notifyCommitEntry(created, removed, evicted, entry, ctx, command);
        }

        @Override
        public List<Address> getOwners(Collection<Object> keys) {
            return null;
        }

        @Override
        public List<Address> getOwners(Object key) {
            return null;
        }

        @Override
        public Address getAddress() {
            return this.rpcManager.getAddress();
        }

        @Override
        protected WriteSkewHelper.KeySpecificLogic initKeySpecificLogic(boolean totalOrder) {
            return null;
        }
    }

    public static class LocalLogic
    extends AbstractClusteringDependentLogic {
        private EmbeddedCacheManager cacheManager;

        @Inject
        public void init(EmbeddedCacheManager cacheManager) {
            this.cacheManager = cacheManager;
        }

        @Override
        public boolean localNodeIsOwner(Object key) {
            return true;
        }

        @Override
        public boolean localNodeIsPrimaryOwner(Object key) {
            return true;
        }

        @Override
        public Address getPrimaryOwner(Object key) {
            throw new IllegalStateException("Cannot invoke this method for local caches");
        }

        @Override
        public List<Address> getOwners(Collection<Object> keys) {
            return null;
        }

        @Override
        public List<Address> getOwners(Object key) {
            return null;
        }

        @Override
        public Address getAddress() {
            Address address = this.cacheManager.getAddress();
            if (address == null) {
                address = LOCAL_MODE_ADDRESS;
            }
            return address;
        }

        @Override
        public void commitEntry(CacheEntry entry, Metadata metadata, FlagAffectedCommand command, InvocationContext ctx) {
            boolean created = entry.isCreated();
            boolean removed = entry.isRemoved();
            boolean evicted = entry.isEvicted();
            this.commitCacheEntry(entry, metadata);
            this.notifyCommitEntry(created, removed, evicted, entry, ctx, command);
        }

        @Override
        public EntryVersionsMap createNewVersionsAndCheckForWriteSkews(VersionGenerator versionGenerator, TxInvocationContext context, VersionedPrepareCommand prepareCommand) {
            throw new IllegalStateException("Cannot invoke this method for local caches");
        }

        @Override
        protected WriteSkewHelper.KeySpecificLogic initKeySpecificLogic(boolean totalOrder) {
            return null;
        }
    }

    public static abstract class AbstractClusteringDependentLogic
    implements ClusteringDependentLogic {
        protected DataContainer dataContainer;
        protected CacheNotifier notifier;
        protected boolean totalOrder;
        private WriteSkewHelper.KeySpecificLogic keySpecificLogic;
        private ReentrantPerEntryLockContainer lockContainer;

        @Inject
        public void init(DataContainer dataContainer, CacheNotifier notifier, Configuration configuration) {
            this.dataContainer = dataContainer;
            this.notifier = notifier;
            this.totalOrder = configuration.transaction().transactionProtocol().isTotalOrder();
            this.keySpecificLogic = this.initKeySpecificLogic(this.totalOrder);
            this.lockContainer = this.createLockContainer(configuration);
        }

        @Override
        public EntryVersionsMap createNewVersionsAndCheckForWriteSkews(VersionGenerator versionGenerator, TxInvocationContext context, VersionedPrepareCommand prepareCommand) {
            return this.totalOrder ? this.totalOrderCreateNewVersionsAndCheckForWriteSkews(versionGenerator, context, prepareCommand) : this.clusteredCreateNewVersionsAndCheckForWriteSkews(versionGenerator, context, prepareCommand);
        }

        protected abstract WriteSkewHelper.KeySpecificLogic initKeySpecificLogic(boolean var1);

        protected void notifyCommitEntry(boolean created, boolean removed, boolean evicted, CacheEntry entry, InvocationContext ctx, FlagAffectedCommand command) {
            if (removed && evicted) {
                this.notifier.notifyCacheEntryEvicted(entry.getKey(), entry.getValue(), ctx, command);
            } else if (removed) {
                this.notifier.notifyCacheEntryRemoved(entry.getKey(), null, entry.getValue(), false, ctx, command);
            } else {
                this.notifier.notifyCacheEntryModified(entry.getKey(), entry.getValue(), created, false, ctx, command);
                if (created) {
                    this.notifier.notifyCacheEntryCreated(entry.getKey(), entry.getValue(), false, ctx, command);
                }
            }
        }

        private ReentrantPerEntryLockContainer createLockContainer(Configuration configuration) {
            if (configuration.persistence().usingStores() && configuration.persistence().passivation()) {
                return new ReentrantPerEntryLockContainer(configuration.locking().concurrencyLevel());
            }
            return null;
        }

        private EntryVersionsMap totalOrderCreateNewVersionsAndCheckForWriteSkews(VersionGenerator versionGenerator, TxInvocationContext context, VersionedPrepareCommand prepareCommand) {
            if (context.isOriginLocal()) {
                throw new IllegalStateException("This must not be reached");
            }
            EntryVersionsMap updatedVersionMap = new EntryVersionsMap();
            if (!((TotalOrderPrepareCommand)((Object)prepareCommand)).skipWriteSkewCheck()) {
                updatedVersionMap = WriteSkewHelper.performTotalOrderWriteSkewCheckAndReturnNewVersions(prepareCommand, this.dataContainer, versionGenerator, context, this.keySpecificLogic);
            }
            for (WriteCommand c : prepareCommand.getModifications()) {
                for (Object k : c.getAffectedKeys()) {
                    if (!this.keySpecificLogic.performCheckOnKey(k) || updatedVersionMap.containsKey(k)) continue;
                    updatedVersionMap.put(k, null);
                }
            }
            context.getCacheTransaction().setUpdatedEntryVersions(updatedVersionMap);
            return updatedVersionMap;
        }

        private EntryVersionsMap clusteredCreateNewVersionsAndCheckForWriteSkews(VersionGenerator versionGenerator, TxInvocationContext context, VersionedPrepareCommand prepareCommand) {
            EntryVersionsMap uv = WriteSkewHelper.performWriteSkewCheckAndReturnNewVersions(prepareCommand, this.dataContainer, versionGenerator, context, this.keySpecificLogic);
            CacheTransaction cacheTransaction = context.getCacheTransaction();
            EntryVersionsMap uvOld = cacheTransaction.getUpdatedEntryVersions();
            if (uvOld != null && !uvOld.isEmpty()) {
                uvOld.putAll(uv);
                uv = uvOld;
            }
            cacheTransaction.setUpdatedEntryVersions(uv);
            return uv.isEmpty() ? null : uv;
        }

        @Override
        public final boolean lock(Object key, boolean noWaitTime) throws InterruptedException {
            if (this.lockContainer == null) {
                return true;
            }
            long timeout = noWaitTime ? 0L : 1L;
            return this.lockContainer.acquireLock(null, key, timeout, TimeUnit.DAYS) != null;
        }

        @Override
        public final void unlock(Object key) {
            if (this.lockContainer != null) {
                this.lockContainer.releaseLock(null, key);
            }
        }

        protected final void commitCacheEntry(CacheEntry entry, Metadata metadata) {
            this.forceLock(entry.getKey());
            entry.commit(this.dataContainer, metadata);
            this.unlock(entry.getKey());
        }

        private void forceLock(Object key) {
            boolean interrupted = false;
            boolean locked = false;
            do {
                try {
                    locked = this.lock(key, false);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            } while (!locked);
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

