/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.xsite;

import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.xsite.BaseBackupInterceptor;
import org.infinispan.remoting.transport.BackupResponse;

public class NonTransactionalBackupInterceptor
extends BaseBackupInterceptor {
    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleWrite(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleWrite(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleWrite(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.handleWrite(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleWrite(ctx, command);
    }

    private Object handleWrite(InvocationContext ctx, WriteCommand command) throws Throwable {
        if (!ctx.isOriginLocal() || command.hasFlag(Flag.SKIP_XSITE_BACKUP)) {
            return this.invokeNextInterceptor(ctx, command);
        }
        BackupResponse backupResponse = this.backupSender.backupWrite(command);
        Object result = this.invokeNextInterceptor(ctx, command);
        this.backupSender.processResponses(backupResponse, command);
        return result;
    }
}

