/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction;

import java.util.List;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionCoordinator {
    private static final Log log = LogFactory.getLog(TransactionCoordinator.class);
    private CommandsFactory commandsFactory;
    private InvocationContextFactory icf;
    private InterceptorChain invoker;
    private TransactionTable txTable;
    private Configuration configuration;
    private CommandCreator commandCreator;
    private volatile boolean shuttingDown = false;
    boolean trace;

    @Inject
    public void init(CommandsFactory commandsFactory, InvocationContextFactory icf, InterceptorChain invoker, TransactionTable txTable, Configuration configuration) {
        this.commandsFactory = commandsFactory;
        this.icf = icf;
        this.invoker = invoker;
        this.txTable = txTable;
        this.configuration = configuration;
        this.trace = log.isTraceEnabled();
    }

    @Start(priority=1)
    private void setStartStatus() {
        this.shuttingDown = false;
    }

    @Stop(priority=1)
    private void setStopStatus() {
        this.shuttingDown = true;
    }

    @Start
    public void start() {
        this.commandCreator = Configurations.isVersioningEnabled(this.configuration) ? new CommandCreator(){

            @Override
            public CommitCommand createCommitCommand(GlobalTransaction gtx) {
                return TransactionCoordinator.this.commandsFactory.buildVersionedCommitCommand(gtx);
            }

            @Override
            public PrepareCommand createPrepareCommand(GlobalTransaction gtx, List<WriteCommand> modifications, boolean onePhaseCommit) {
                return TransactionCoordinator.this.commandsFactory.buildVersionedPrepareCommand(gtx, modifications, onePhaseCommit);
            }
        } : new CommandCreator(){

            @Override
            public CommitCommand createCommitCommand(GlobalTransaction gtx) {
                return TransactionCoordinator.this.commandsFactory.buildCommitCommand(gtx);
            }

            @Override
            public PrepareCommand createPrepareCommand(GlobalTransaction gtx, List<WriteCommand> modifications, boolean onePhaseCommit) {
                return TransactionCoordinator.this.commandsFactory.buildPrepareCommand(gtx, modifications, onePhaseCommit);
            }
        };
    }

    public final int prepare(LocalTransaction localTransaction) throws XAException {
        return this.prepare(localTransaction, false);
    }

    public final int prepare(LocalTransaction localTransaction, boolean replayEntryWrapping) throws XAException {
        this.validateNotMarkedForRollback(localTransaction);
        if (this.isOnePhaseCommit(localTransaction)) {
            if (this.trace) {
                log.tracef("Received prepare for tx: %s. Skipping call as 1PC will be used.", localTransaction);
            }
            return 0;
        }
        PrepareCommand prepareCommand = this.commandCreator.createPrepareCommand(localTransaction.getGlobalTransaction(), localTransaction.getModifications(), false);
        if (this.trace) {
            log.tracef("Sending prepare command through the chain: %s", prepareCommand);
        }
        LocalTxInvocationContext ctx = this.icf.createTxInvocationContext();
        prepareCommand.setReplayEntryWrapping(replayEntryWrapping);
        ctx.setLocalTransaction(localTransaction);
        try {
            this.invoker.invoke(ctx, prepareCommand);
            if (localTransaction.isReadOnly()) {
                if (this.trace) {
                    log.tracef("Readonly transaction: %s", localTransaction.getGlobalTransaction());
                }
                this.commitInternal(localTransaction);
                return 3;
            }
            this.txTable.localTransactionPrepared(localTransaction);
            return 0;
        }
        catch (Throwable e) {
            if (this.shuttingDown) {
                log.trace("Exception while preparing back, probably because we're shutting down.");
            } else {
                log.errorProcessingPrepare(e);
            }
            this.rollback(localTransaction);
            throw new XAException(100);
        }
    }

    public boolean commit(LocalTransaction localTransaction, boolean isOnePhase) throws XAException {
        if (this.trace) {
            log.tracef("Committing transaction %s", localTransaction.getGlobalTransaction());
        }
        LocalTxInvocationContext ctx = this.icf.createTxInvocationContext();
        ctx.setLocalTransaction(localTransaction);
        if (this.isOnePhaseCommit(localTransaction) || isOnePhase) {
            this.validateNotMarkedForRollback(localTransaction);
            if (this.trace) {
                log.trace("Doing an 1PC prepare call on the interceptor chain");
            }
            List<WriteCommand> modifications = localTransaction.getModifications();
            PrepareCommand command = this.commandCreator.createPrepareCommand(localTransaction.getGlobalTransaction(), modifications, true);
            try {
                this.invoker.invoke(ctx, command);
            }
            catch (Throwable e) {
                this.handleCommitFailure(e, localTransaction, true);
            }
            return true;
        }
        if (!localTransaction.isReadOnly()) {
            this.commitInternal(localTransaction);
        }
        return false;
    }

    public void rollback(LocalTransaction localTransaction) throws XAException {
        try {
            this.rollbackInternal(localTransaction);
        }
        catch (Throwable e) {
            if (this.shuttingDown) {
                log.trace("Exception while rolling back, probably because we're shutting down.");
            } else {
                log.errorRollingBack(e);
            }
            Transaction transaction = localTransaction.getTransaction();
            if (transaction != null) {
                this.txTable.failureCompletingTransaction(transaction);
            }
            throw new XAException(-3);
        }
    }

    private void handleCommitFailure(Throwable e, LocalTransaction localTransaction, boolean onePhaseCommit) throws XAException {
        if (this.trace) {
            log.tracef("Couldn't commit transaction %s, trying to rollback.", localTransaction);
        }
        if (onePhaseCommit) {
            log.errorProcessing1pcPrepareCommand(e);
        } else {
            log.errorProcessing2pcCommitCommand(e);
        }
        try {
            if (!onePhaseCommit || !this.configuration.transaction().transactionProtocol().isTotalOrder()) {
                this.rollbackInternal(localTransaction);
            }
        }
        catch (Throwable e1) {
            log.couldNotRollbackPrepared1PcTransaction(localTransaction, e1);
            throw new XAException(-3);
        }
        finally {
            this.txTable.failureCompletingTransaction(localTransaction.getTransaction());
        }
        throw new XAException(6);
    }

    private void commitInternal(LocalTransaction localTransaction) throws XAException {
        LocalTxInvocationContext ctx = this.icf.createTxInvocationContext();
        ctx.setLocalTransaction(localTransaction);
        CommitCommand commitCommand = this.commandCreator.createCommitCommand(localTransaction.getGlobalTransaction());
        try {
            this.invoker.invoke(ctx, commitCommand);
            this.txTable.removeLocalTransaction(localTransaction);
        }
        catch (Throwable e) {
            this.handleCommitFailure(e, localTransaction, false);
        }
    }

    private void rollbackInternal(LocalTransaction localTransaction) throws Throwable {
        if (this.trace) {
            log.tracef("rollback transaction %s ", localTransaction.getGlobalTransaction());
        }
        RollbackCommand rollbackCommand = this.commandsFactory.buildRollbackCommand(localTransaction.getGlobalTransaction());
        LocalTxInvocationContext ctx = this.icf.createTxInvocationContext();
        ctx.setLocalTransaction(localTransaction);
        this.invoker.invoke(ctx, rollbackCommand);
        this.txTable.removeLocalTransaction(localTransaction);
    }

    private void validateNotMarkedForRollback(LocalTransaction localTransaction) throws XAException {
        if (localTransaction.isMarkedForRollback()) {
            if (this.trace) {
                log.tracef("Transaction already marked for rollback. Forcing rollback for %s", localTransaction);
            }
            this.rollback(localTransaction);
            throw new XAException(100);
        }
    }

    public boolean is1PcForAutoCommitTransaction(LocalTransaction localTransaction) {
        return this.configuration.transaction().use1PcForAutoCommitTransactions() && localTransaction.isImplicitTransaction();
    }

    private boolean isOnePhaseCommit(LocalTransaction localTransaction) {
        return Configurations.isOnePhaseCommit(this.configuration) || this.is1PcForAutoCommitTransaction(localTransaction) || Configurations.isOnePhaseTotalOrderCommit(this.configuration);
    }

    private static interface CommandCreator {
        public CommitCommand createCommitCommand(GlobalTransaction var1);

        public PrepareCommand createPrepareCommand(GlobalTransaction var1, List<WriteCommand> var2, boolean var3);
    }
}

