/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.signature;

import java.math.BigInteger;
import java.security.SignatureException;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.signature.AbstractSignature;
import net.schmizz.sshj.signature.Signature;

public class SignatureECDSA
extends AbstractSignature {
    public SignatureECDSA() {
        super("SHA256withECDSA");
    }

    @Override
    public byte[] encode(byte[] sig) {
        int rIndex = 3;
        int rLen = sig[rIndex++] & 0xFF;
        byte[] r = new byte[rLen];
        System.arraycopy(sig, rIndex, r, 0, r.length);
        int sIndex = rIndex + rLen + 1;
        int sLen = sig[sIndex++] & 0xFF;
        byte[] s = new byte[sLen];
        System.arraycopy(sig, sIndex, s, 0, s.length);
        System.arraycopy(sig, 4, r, 0, rLen);
        System.arraycopy(sig, 6 + rLen, s, 0, sLen);
        Buffer.PlainBuffer buf = new Buffer.PlainBuffer();
        buf.putMPInt(new BigInteger(r));
        buf.putMPInt(new BigInteger(s));
        return buf.getCompactData();
    }

    @Override
    public boolean verify(byte[] sig) {
        byte[] s;
        byte[] r;
        try {
            Buffer.PlainBuffer sigbuf = new Buffer.PlainBuffer(sig);
            String algo = new String(sigbuf.readBytes());
            if (!"ecdsa-sha2-nistp256".equals(algo)) {
                throw new SSHRuntimeException(String.format("Signature :: ecdsa-sha2-nistp256 expected, got %s", algo));
            }
            int rsLen = sigbuf.readUInt32AsInt();
            if (sigbuf.available() != rsLen) {
                throw new SSHRuntimeException("Invalid key length");
            }
            r = sigbuf.readBytes();
            s = sigbuf.readBytes();
        }
        catch (Exception e) {
            throw new SSHRuntimeException(e);
        }
        int rLen = r.length;
        int sLen = s.length;
        if ((r[0] & 0x80) != 0) {
            ++rLen;
        }
        if ((s[0] & 0x80) != 0) {
            ++sLen;
        }
        int length = 6 + rLen + sLen;
        byte[] asn1 = new byte[length];
        asn1[0] = 48;
        asn1[1] = (byte)(4 + rLen + sLen);
        asn1[2] = 2;
        asn1[3] = (byte)rLen;
        System.arraycopy(r, 0, asn1, 4, rLen);
        asn1[rLen + 4] = 2;
        asn1[rLen + 5] = (byte)sLen;
        System.arraycopy(s, 0, asn1, 6 + rLen, sLen);
        try {
            return this.signature.verify(asn1);
        }
        catch (SignatureException e) {
            throw new SSHRuntimeException(e);
        }
    }

    public static class Factory
    implements Factory.Named<Signature> {
        @Override
        public Signature create() {
            return new SignatureECDSA();
        }

        @Override
        public String getName() {
            return KeyType.ECDSA.toString();
        }
    }
}

