@echo off
REM
REM Batch script to start the XL TestView Server
REM

setlocal ENABLEDELAYEDEXPANSION

REM Get Java executable
if "%JAVA_HOME%"=="" (
  set JAVACMD=java
) else (
  set JAVACMD="%JAVA_HOME%\bin\java"
)

REM Get JVM options
if "%XLT_SERVER_MEM_OPTS%"=="" (
  set XLT_SERVER_MEM_OPTS=-Xmx1024m -XX:MaxPermSize=256m
)

REM Get XL TestView server home dir
if "%XLT_SERVER_HOME%"=="" (
  cd /d "%~dp0"
  cd ..
  set XLT_SERVER_HOME=!CD!
)

cd /d "%XLT_SERVER_HOME%"

REM Build XL TestView server classpath
set XLT_SERVER_CLASSPATH=conf;ext
for %%i in (hotfix\*.jar) do set XLT_SERVER_CLASSPATH=!XLT_SERVER_CLASSPATH!;%%i
for %%i in (lib\*.jar) do set XLT_SERVER_CLASSPATH=!XLT_SERVER_CLASSPATH!;%%i
for %%i in (plugins\*.jar) do set XLT_SERVER_CLASSPATH=!XLT_SERVER_CLASSPATH!;%%i
for /d %%i in (plugins\*) do set XLT_SERVER_CLASSPATH=!XLT_SERVER_CLASSPATH!;%%i

REM Run XL TestView server
%JAVACMD% %XLT_SERVER_MEM_OPTS% %XLT_SERVER_OPTS% -cp "%XLT_SERVER_CLASSPATH%" com.xebialabs.xltest.Main %*

:end
endlocal
