# NOTE: Please do not edit this file directly
# Create your custom reports in the 'ext' folder

import re

def nameStartsWithPrefix(prefix, ev):
    if prefix is None or prefix == '':
        return True
    name = ev.get('name')
    return re.match('^' + re.escape(prefix[:-1]) + '\W', name)

events = testRuns.getEventsForRunId(testRun.testRunId, {'tags': tags})

passed = 0
failed = 0
prefix = queryParameters.get('prefix') or ''
for ev in events:
    if ev.type == 'functionalResult' and nameStartsWithPrefix(prefix, ev):
        result = ev.get('result')
        if result is None:
            continue
        if result == 'PASSED':
            passed = passed + 1
        else:
            failed = failed + 1


resultHolder.setResult(
    {
        'chart': {
            'type': 'pie',
            'plotBackgroundColor': None,
            'plotBorderWidth': None,
            'plotShadow': False,
        },
        'title': 'Passed vs. failed tests from latest test run in time window',
        'tooltip': {
           'enabled': False
        },
        'legend': {
            'borderColor': None,
            'layout': 'vertical',
            'verticalAlign': 'middle',
            'symbolHeight': 12,
            'symbolWidth': 12,
            'symbolRadius': 6,
            'itemMarginBottom': 4
        },
        'plotOptions': {
            'series': {
                'slicedOffset': 0
            },
            'pie': {
                'allowPointSelect': True,
                'cursor': 'pointer',
                'dataLabels': {
                    'enabled': True,
                    'distance': -15,
                    'format': '{y}'
                },
                'innerSize': '70%',
                'showInLegend': 'True',
                'animation': False,
                'states': {
                    'hover': {
                        'enabled': False
                    }
                }
            }
        },
        'series': [{
            'data': [
                ['Passed', passed],
                ['Failed', failed]
            ]
        }]
    })