/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.Cache;
import org.infinispan.IllegalLifecycleStateException;
import org.infinispan.Version;
import org.infinispan.commands.RemoveCacheCommand;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.format.PropertyFormatter;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.InternalCacheFactory;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.CacheJmxRegistration;
import org.infinispan.jmx.CacheManagerJmxRegistration;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.DisplayType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.Parameter;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.security.AuditContext;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.impl.AuthorizationHelper;
import org.infinispan.security.impl.PrincipalRoleMapperContextImpl;
import org.infinispan.security.impl.SecureCacheImpl;
import org.infinispan.stats.CacheContainerStats;
import org.infinispan.stats.impl.CacheContainerStatsImpl;
import org.infinispan.util.CyclicDependencyException;
import org.infinispan.util.DependencyGraph;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
@SurvivesRestarts
@MBean(objectName="CacheManager", description="Component that acts as a manager, factory and container for caches in the system.")
public class DefaultCacheManager
implements EmbeddedCacheManager {
    public static final String OBJECT_NAME = "CacheManager";
    private static final Log log = LogFactory.getLog(DefaultCacheManager.class);
    protected final GlobalConfiguration globalConfiguration;
    protected final Configuration defaultConfiguration;
    private final ConcurrentMap<String, CacheWrapper> caches = CollectionFactory.makeConcurrentMap();
    private final ConcurrentMap<String, Configuration> configurationOverrides = CollectionFactory.makeConcurrentMap();
    private final GlobalComponentRegistry globalComponentRegistry;
    private volatile boolean stopping;
    private final AuthorizationHelper authzHelper;
    private final DependencyGraph<String> cacheDependencyGraph = new DependencyGraph();
    private final CacheContainerStats stats;

    public DefaultCacheManager() {
        this(null, null, true);
    }

    public DefaultCacheManager(boolean start) {
        this(null, null, start);
    }

    public DefaultCacheManager(Configuration defaultConfiguration) {
        this(null, defaultConfiguration, true);
    }

    public DefaultCacheManager(Configuration defaultConfiguration, boolean start) {
        this(null, defaultConfiguration, start);
    }

    public DefaultCacheManager(GlobalConfiguration globalConfiguration) {
        this(globalConfiguration, null, true);
    }

    public DefaultCacheManager(GlobalConfiguration globalConfiguration, boolean start) {
        this(globalConfiguration, null, start);
    }

    public DefaultCacheManager(GlobalConfiguration globalConfiguration, Configuration defaultConfiguration) {
        this(globalConfiguration, defaultConfiguration, true);
    }

    public DefaultCacheManager(GlobalConfiguration globalConfiguration, Configuration defaultConfiguration, boolean start) {
        this.globalConfiguration = globalConfiguration == null ? new GlobalConfigurationBuilder().build() : globalConfiguration;
        this.defaultConfiguration = defaultConfiguration == null ? new ConfigurationBuilder().build() : defaultConfiguration;
        this.globalComponentRegistry = new GlobalComponentRegistry(this.globalConfiguration, this, this.caches.keySet());
        this.authzHelper = new AuthorizationHelper(this.globalConfiguration.security(), AuditContext.CACHEMANAGER, this.globalConfiguration.globalJmxStatistics().cacheManagerName());
        this.stats = new CacheContainerStatsImpl(this);
        if (start) {
            this.start();
        }
    }

    public DefaultCacheManager(String configurationFile) throws IOException {
        this(configurationFile, true);
    }

    public DefaultCacheManager(String configurationFile, boolean start) throws IOException {
        this(FileLookupFactory.newInstance().lookupFileStrict(configurationFile, Thread.currentThread().getContextClassLoader()), start);
    }

    public DefaultCacheManager(InputStream configurationStream) throws IOException {
        this(configurationStream, true);
    }

    public DefaultCacheManager(InputStream configurationStream, boolean start) throws IOException {
        this(new ParserRegistry().parse(configurationStream), start);
    }

    public DefaultCacheManager(ConfigurationBuilderHolder holder, boolean start) {
        try {
            this.globalConfiguration = holder.getGlobalConfigurationBuilder().build();
            this.defaultConfiguration = holder.getDefaultConfigurationBuilder().build(this.globalConfiguration);
            for (Map.Entry<String, ConfigurationBuilder> entry : holder.getNamedConfigurationBuilders().entrySet()) {
                ConfigurationBuilder builder = entry.getValue();
                Configuration c = builder.build(this.globalConfiguration);
                this.configurationOverrides.put(entry.getKey(), c);
            }
            this.globalComponentRegistry = new GlobalComponentRegistry(this.globalConfiguration, this, this.caches.keySet());
            this.authzHelper = new AuthorizationHelper(this.globalConfiguration.security(), AuditContext.CACHEMANAGER, this.globalConfiguration.globalJmxStatistics().cacheManagerName());
            this.stats = new CacheContainerStatsImpl(this);
        }
        catch (CacheConfigurationException ce) {
            throw ce;
        }
        catch (RuntimeException re) {
            throw new CacheConfigurationException((Exception)re);
        }
        if (start) {
            this.start();
        }
    }

    @Deprecated
    public DefaultCacheManager(String globalConfigurationFile, String defaultConfigurationFile, String namedCacheFile, boolean start) throws IOException {
        ParserRegistry parserRegistry = new ParserRegistry();
        ConfigurationBuilderHolder globalConfigurationBuilderHolder = parserRegistry.parseFile(globalConfigurationFile);
        ConfigurationBuilderHolder defaultConfigurationBuilderHolder = parserRegistry.parseFile(defaultConfigurationFile);
        this.globalConfiguration = globalConfigurationBuilderHolder.getGlobalConfigurationBuilder().build();
        this.defaultConfiguration = defaultConfigurationBuilderHolder.getDefaultConfigurationBuilder().build(this.globalConfiguration);
        if (namedCacheFile != null) {
            ConfigurationBuilderHolder namedConfigurationBuilderHolder = parserRegistry.parseFile(namedCacheFile);
            Map.Entry<String, ConfigurationBuilder> entry = namedConfigurationBuilderHolder.getNamedConfigurationBuilders().entrySet().iterator().next();
            ConfigurationBuilder builder = entry.getValue();
            this.configurationOverrides.put(entry.getKey(), builder.build(this.globalConfiguration));
        }
        this.globalComponentRegistry = new GlobalComponentRegistry(this.globalConfiguration, this, this.caches.keySet());
        this.authzHelper = new AuthorizationHelper(this.globalConfiguration.security(), AuditContext.CACHEMANAGER, this.globalConfiguration.globalJmxStatistics().cacheManagerName());
        this.stats = new CacheContainerStatsImpl(this);
        if (start) {
            this.start();
        }
    }

    @Override
    public Configuration defineConfiguration(String cacheName, Configuration configuration) {
        return this.defineConfiguration(cacheName, configuration, null, true);
    }

    @Override
    public Configuration defineConfiguration(String cacheName, String templateName, Configuration configurationOverride) {
        if (templateName != null) {
            Configuration c;
            Configuration configuration = c = "___defaultcache".equals(templateName) ? this.defaultConfiguration : (Configuration)this.configurationOverrides.get(templateName);
            if (c != null) {
                return this.defineConfiguration(cacheName, configurationOverride, c, false);
            }
            return this.defineConfiguration(cacheName, configurationOverride);
        }
        return this.defineConfiguration(cacheName, configurationOverride);
    }

    private Configuration defineConfiguration(String cacheName, Configuration configOverride, Configuration defaultConfigIfNotPresent, boolean checkExisting) {
        Configuration existing;
        this.authzHelper.checkPermission(AuthorizationPermission.ADMIN);
        this.assertIsNotTerminated();
        if (cacheName == null || configOverride == null) {
            throw new NullPointerException("Null arguments not allowed");
        }
        if (cacheName.equals("___defaultcache")) {
            throw new IllegalArgumentException("Cache name cannot be used as it is a reserved, internal name");
        }
        if (checkExisting && (existing = (Configuration)this.configurationOverrides.get(cacheName)) != null) {
            ConfigurationBuilder builder = new ConfigurationBuilder();
            builder.read(existing);
            builder.read(configOverride);
            Configuration configuration = builder.build(this.globalConfiguration);
            this.configurationOverrides.put(cacheName, configuration);
            return configuration;
        }
        ConfigurationBuilder builder = new ConfigurationBuilder();
        if (defaultConfigIfNotPresent != null) {
            builder.read(defaultConfigIfNotPresent);
        }
        builder.read(configOverride);
        Configuration configuration = builder.build(this.globalConfiguration);
        this.configurationOverrides.put(cacheName, configuration);
        return configuration;
    }

    @Override
    public <K, V> Cache<K, V> getCache() {
        return this.getCache("___defaultcache");
    }

    @Override
    public <K, V> Cache<K, V> getCache(String cacheName) {
        this.assertIsNotTerminated();
        if (cacheName == null) {
            throw new NullPointerException("Null arguments not allowed");
        }
        CacheWrapper cw = (CacheWrapper)this.caches.get(cacheName);
        if (cw != null) {
            return cw.getCache();
        }
        return this.createCache(cacheName);
    }

    @Override
    public boolean cacheExists(String cacheName) {
        return this.caches.containsKey(cacheName);
    }

    @Override
    public <K, V> Cache<K, V> getCache(String cacheName, boolean createIfAbsent) {
        boolean cacheExists = this.cacheExists(cacheName);
        if (!cacheExists && !createIfAbsent) {
            return null;
        }
        return this.getCache(cacheName);
    }

    @Override
    public EmbeddedCacheManager startCaches(String ... cacheNames) {
        this.authzHelper.checkPermission(AuthorizationPermission.LIFECYCLE);
        ArrayList<1> threads = new ArrayList<1>(cacheNames.length);
        final AtomicReference<Object> exception = new AtomicReference<Object>(null);
        for (final String cacheName : cacheNames) {
            String threadName = "CacheStartThread," + this.globalConfiguration.transport().nodeName() + "," + cacheName;
            Thread thread = new Thread(threadName){

                @Override
                public void run() {
                    try {
                        DefaultCacheManager.this.createCache(cacheName);
                    }
                    catch (RuntimeException e) {
                        exception.set(e);
                    }
                    catch (Throwable t) {
                        exception.set(new RuntimeException(t));
                    }
                }
            };
            thread.start();
            threads.add(thread);
        }
        try {
            for (Thread thread : threads) {
                thread.join();
            }
        }
        catch (InterruptedException e) {
            throw new CacheException("Interrupted while waiting for the caches to start");
        }
        if (exception.get() != null) {
            throw (RuntimeException)exception.get();
        }
        return this;
    }

    @Override
    public void removeCache(String cacheName) {
        this.authzHelper.checkPermission(AuthorizationPermission.ADMIN);
        ComponentRegistry cacheComponentRegistry = this.globalComponentRegistry.getNamedComponentRegistry(cacheName);
        if (cacheComponentRegistry != null) {
            RemoveCacheCommand cmd = new RemoveCacheCommand(cacheName, this, this.globalComponentRegistry, cacheComponentRegistry.getComponent(PersistenceManager.class), cacheComponentRegistry.getComponent(CacheJmxRegistration.class));
            Transport transport = this.getTransport();
            try {
                if (transport != null) {
                    Configuration c = this.getConfiguration(cacheName);
                    transport.invokeRemotely(null, cmd, ResponseMode.SYNCHRONOUS, c.clustering().sync().replTimeout(), null, DeliverOrder.NONE, false);
                }
                cmd.perform(null);
                this.configurationOverrides.remove(cacheName);
                this.cacheDependencyGraph.remove(cacheName);
            }
            catch (Throwable t) {
                throw new CacheException("Error removing cache", t);
            }
        }
    }

    @Override
    public List<Address> getMembers() {
        Transport t = this.getTransport();
        return t == null ? null : t.getMembers();
    }

    @Override
    public Address getAddress() {
        Transport t = this.getTransport();
        return t == null ? null : t.getAddress();
    }

    @Override
    public Address getCoordinator() {
        Transport t = this.getTransport();
        return t == null ? null : t.getCoordinator();
    }

    @ManagedAttribute(description="The logical address of the cluster's coordinator", displayName="Coordinator address", displayType=DisplayType.SUMMARY)
    public String getCoordinatorAddress() {
        Transport t = this.getTransport();
        return t == null ? "N/A" : t.getCoordinator().toString();
    }

    @Override
    @ManagedAttribute(description="Indicates whether this node is coordinator", displayName="Is coordinator?", displayType=DisplayType.SUMMARY)
    public boolean isCoordinator() {
        Transport t = this.getTransport();
        return t != null && t.isCoordinator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> Cache<K, V> createCache(String cacheName) {
        boolean trace = log.isTraceEnabled();
        LogFactory.pushNDC(cacheName, trace);
        try {
            Cache<K, V> cache = this.wireAndStartCache(cacheName);
            if (cache == null) {
                Cache cache2 = ((CacheWrapper)this.caches.get(cacheName)).getCache();
                return cache2;
            }
            Cache<K, V> cache3 = cache;
            return cache3;
        }
        finally {
            LogFactory.popNDC(trace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private <K, V> Cache<K, V> wireAndStartCache(String cacheName) {
        Configuration c;
        CacheWrapper createdCacheWrapper;
        block9: {
            Cache<K, V> cache;
            createdCacheWrapper = null;
            c = null;
            try {
                ConcurrentMap<String, CacheWrapper> concurrentMap = this.caches;
                // MONITORENTER : concurrentMap
                CacheWrapper existingCacheWrapper = (CacheWrapper)this.caches.get(cacheName);
                if (existingCacheWrapper == null) break block9;
                cache = null;
                // MONITOREXIT : concurrentMap
                if (createdCacheWrapper == null) return cache;
            }
            catch (Throwable throwable) {
                if (createdCacheWrapper == null) throw throwable;
                log.tracef("Closing latch for cache %s", cacheName);
                createdCacheWrapper.latch.countDown();
                throw throwable;
            }
            log.tracef("Closing latch for cache %s", cacheName);
            createdCacheWrapper.latch.countDown();
            return cache;
        }
        c = this.getConfiguration(cacheName);
        if (c.security().authorization().enabled()) {
            this.authzHelper.checkPermission(c.security().authorization(), AuthorizationPermission.LIFECYCLE);
        }
        if (this.caches.put(cacheName, createdCacheWrapper = new CacheWrapper()) != null) {
            throw new IllegalStateException("attempt to initialize the cache twice");
        }
        // MONITOREXIT : concurrentMap
        this.globalComponentRegistry.start();
        log.tracef("About to wire and start cache %s", cacheName);
        Cache cache = new InternalCacheFactory().createCache(c, this.globalComponentRegistry, cacheName);
        if (cache.getAdvancedCache().getAuthorizationManager() != null) {
            cache = new SecureCacheImpl(cache.getAdvancedCache());
        }
        createdCacheWrapper.setCache(cache);
        cache.start();
        Cache cache2 = cache;
        if (createdCacheWrapper == null) return cache2;
        log.tracef("Closing latch for cache %s", cacheName);
        createdCacheWrapper.latch.countDown();
        return cache2;
    }

    private Configuration getConfiguration(String cacheName) {
        Configuration c = cacheName.equals("___defaultcache") || !this.configurationOverrides.containsKey(cacheName) ? new ConfigurationBuilder().read(this.defaultConfiguration).build(this.globalConfiguration) : (Configuration)this.configurationOverrides.get(cacheName);
        return c;
    }

    public void start() {
        this.authzHelper.checkPermission(AuthorizationPermission.LIFECYCLE);
        if (this.globalConfiguration.security().authorization().enabled() && System.getSecurityManager() == null) {
            log.authorizationEnabledWithoutSecurityManager();
        }
        this.globalComponentRegistry.getComponent(CacheManagerJmxRegistration.class).start();
        String clusterName = this.globalConfiguration.transport().clusterName();
        String nodeName = this.globalConfiguration.transport().nodeName();
        if (this.globalConfiguration.security().authorization().enabled()) {
            this.globalConfiguration.security().authorization().principalRoleMapper().setContext(new PrincipalRoleMapperContextImpl(this));
        }
        log.debugf("Started cache manager %s on %s", clusterName, nodeName);
    }

    private void terminate(String cacheName) {
        CacheWrapper cacheWrapper = (CacheWrapper)this.caches.get(cacheName);
        if (cacheWrapper != null && cacheWrapper.cache != null) {
            Cache cache = cacheWrapper.cache;
            this.unregisterCacheMBean(cache);
            cache.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.authzHelper.checkPermission(AuthorizationPermission.LIFECYCLE);
        if (!this.stopping) {
            DefaultCacheManager defaultCacheManager = this;
            synchronized (defaultCacheManager) {
                if (!this.stopping) {
                    log.debugf("Stopping cache manager %s on %s", this.globalConfiguration.transport().clusterName(), this.getAddress());
                    this.stopping = true;
                    LinkedHashSet<String> cachesToStop = new LinkedHashSet<String>(this.caches.size());
                    boolean defaultCacheHasDependency = false;
                    try {
                        List<String> ordered = this.cacheDependencyGraph.topologicalSort();
                        defaultCacheHasDependency = ordered.contains("___defaultcache");
                        cachesToStop.addAll(ordered);
                    }
                    catch (CyclicDependencyException e) {
                        log.stopOrderIgnored();
                    }
                    cachesToStop.addAll(this.caches.keySet());
                    cachesToStop.remove("__cluster_registry_cache__");
                    if (!defaultCacheHasDependency) {
                        cachesToStop.add("___defaultcache");
                    }
                    for (String cacheName : cachesToStop) {
                        this.terminate(cacheName);
                    }
                    this.globalComponentRegistry.getComponent(CacheManagerJmxRegistration.class).stop();
                    this.globalComponentRegistry.stop();
                } else {
                    log.trace("Ignore call to stop as the cache manager is stopping");
                }
            }
        }
        log.trace("Ignore call to stop as the cache manager is stopping");
    }

    private void unregisterCacheMBean(Cache<?, ?> cache) {
        cache.getAdvancedCache().getComponentRegistry().getComponent(CacheJmxRegistration.class).unregisterCacheMBean();
    }

    @Override
    public void addListener(Object listener) {
        this.authzHelper.checkPermission(AuthorizationPermission.LISTEN);
        CacheManagerNotifier notifier = this.globalComponentRegistry.getComponent(CacheManagerNotifier.class);
        notifier.addListener(listener);
    }

    @Override
    public void removeListener(Object listener) {
        this.authzHelper.checkPermission(AuthorizationPermission.LISTEN);
        CacheManagerNotifier notifier = this.globalComponentRegistry.getComponent(CacheManagerNotifier.class);
        notifier.removeListener(listener);
    }

    @Override
    public Set<Object> getListeners() {
        this.authzHelper.checkPermission(AuthorizationPermission.LISTEN);
        CacheManagerNotifier notifier = this.globalComponentRegistry.getComponent(CacheManagerNotifier.class);
        return notifier.getListeners();
    }

    @Override
    public ComponentStatus getStatus() {
        this.authzHelper.checkPermission(AuthorizationPermission.LIFECYCLE);
        return this.globalComponentRegistry.getStatus();
    }

    @Override
    public GlobalConfiguration getCacheManagerConfiguration() {
        return this.globalConfiguration;
    }

    @Override
    public Configuration getDefaultCacheConfiguration() {
        return this.defaultConfiguration;
    }

    @Override
    public Configuration getCacheConfiguration(String name) {
        Configuration configuration = (Configuration)this.configurationOverrides.get(name);
        if (configuration == null && this.cacheExists(name)) {
            return this.defaultConfiguration;
        }
        return configuration;
    }

    @Override
    public Set<String> getCacheNames() {
        HashSet<String> names = new HashSet<String>(this.configurationOverrides.keySet());
        names.addAll(Immutables.immutableSetConvert(this.caches.keySet()));
        names.remove("___defaultcache");
        InternalCacheRegistry internalCacheRegistry = this.globalComponentRegistry.getComponent(InternalCacheRegistry.class);
        internalCacheRegistry.filterInternalCaches(names);
        if (names.isEmpty()) {
            return InfinispanCollections.emptySet();
        }
        return Immutables.immutableSetWrap(names);
    }

    @Override
    public boolean isRunning(String cacheName) {
        CacheWrapper w = (CacheWrapper)this.caches.get(cacheName);
        try {
            return w != null && w.latch.await(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public boolean isDefaultRunning() {
        return this.isRunning("___defaultcache");
    }

    @ManagedAttribute(description="The status of the cache manager instance.", displayName="Cache manager status", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getCacheManagerStatus() {
        return this.getStatus().toString();
    }

    @ManagedAttribute(description="The defined cache names and their statuses.  The default cache is not included in this representation.", displayName="List of defined caches", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getDefinedCacheNames() {
        StringBuilder result = new StringBuilder("[");
        for (String cacheName : this.getCacheNames()) {
            boolean started = this.caches.containsKey(cacheName);
            result.append(cacheName).append(started ? "(created)" : "(not created)");
        }
        result.append("]");
        return result.toString();
    }

    @ManagedAttribute(description="The total number of defined caches, excluding the default cache.", displayName="Number of caches defined", displayType=DisplayType.SUMMARY)
    public String getDefinedCacheCount() {
        return String.valueOf(this.configurationOverrides.keySet().size());
    }

    @ManagedAttribute(description="The total number of created caches, including the default cache.", displayName="Number of caches created", displayType=DisplayType.SUMMARY)
    public String getCreatedCacheCount() {
        return String.valueOf(this.caches.keySet().size());
    }

    @ManagedAttribute(description="The total number of running caches, including the default cache.", displayName="Number of running caches", displayType=DisplayType.SUMMARY)
    public String getRunningCacheCount() {
        int running = 0;
        for (CacheWrapper cachew : this.caches.values()) {
            Cache cache = cachew.cache;
            if (cache == null || cache.getStatus() != ComponentStatus.RUNNING) continue;
            ++running;
        }
        return String.valueOf(running);
    }

    @ManagedAttribute(description="Returns the version of Infinispan", displayName="Infinispan version", displayType=DisplayType.SUMMARY, dataType=DataType.TRAIT)
    public String getVersion() {
        return Version.getVersion();
    }

    @ManagedAttribute(description="The name of this cache manager", displayName="Cache manager name", displayType=DisplayType.SUMMARY, dataType=DataType.TRAIT)
    public String getName() {
        return this.globalConfiguration.globalJmxStatistics().cacheManagerName();
    }

    @ManagedOperation(description="Starts the default cache associated with this cache manager", displayName="Starts the default cache")
    public void startCache() {
        this.getCache();
    }

    @ManagedOperation(description="Starts a named cache from this cache manager", name="startCache", displayName="Starts a cache with the given name")
    public void startCache(@Parameter(name="cacheName", description="Name of cache to start") String cacheName) {
        this.getCache(cacheName);
    }

    @ManagedAttribute(description="The network address associated with this instance", displayName="Network address", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getNodeAddress() {
        return this.getLogicalAddressString();
    }

    @ManagedAttribute(description="The physical network addresses associated with this instance", displayName="Physical network addresses", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getPhysicalAddresses() {
        Transport t = this.getTransport();
        if (t == null) {
            return "local";
        }
        List<Address> address = t.getPhysicalAddresses();
        return address == null ? "local" : address.toString();
    }

    @ManagedAttribute(description="List of members in the cluster", displayName="Cluster members", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getClusterMembers() {
        Transport t = this.getTransport();
        if (t == null) {
            return "local";
        }
        List<Address> addressList = t.getMembers();
        return addressList.toString();
    }

    @ManagedAttribute(description="Size of the cluster in number of nodes", displayName="Cluster size", displayType=DisplayType.SUMMARY)
    public int getClusterSize() {
        Transport t = this.getTransport();
        if (t == null) {
            return 1;
        }
        return t.getMembers().size();
    }

    @Override
    @ManagedAttribute(description="Cluster name", displayName="Cluster name", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getClusterName() {
        return this.globalConfiguration.transport().clusterName();
    }

    private String getLogicalAddressString() {
        return this.getAddress() == null ? "local" : this.getAddress().toString();
    }

    private void assertIsNotTerminated() {
        if (this.globalComponentRegistry.getStatus().isTerminated()) {
            throw new IllegalLifecycleStateException("Cache container has been stopped and cannot be reused. Recreate the cache container.");
        }
    }

    @Override
    public Transport getTransport() {
        if (this.globalComponentRegistry == null) {
            return null;
        }
        return this.globalComponentRegistry.getComponent(Transport.class);
    }

    @Override
    public GlobalComponentRegistry getGlobalComponentRegistry() {
        return this.globalComponentRegistry;
    }

    @Override
    public void addCacheDependency(String from, String to) {
        this.cacheDependencyGraph.addDependency(from, to);
    }

    public String toString() {
        return super.toString() + "@Address:" + this.getAddress();
    }

    @ManagedAttribute(description="Global configuration properties", displayName="Global configuration properties", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public Properties getGlobalConfigurationAsProperties() {
        return new PropertyFormatter().format(this.globalConfiguration);
    }

    @Override
    public CacheContainerStats getStats() {
        return this.stats;
    }

    private static final class CacheWrapper {
        private volatile Cache<?, ?> cache;
        private final CountDownLatch latch = new CountDownLatch(1);

        private CacheWrapper() {
        }

        public void setCache(Cache<?, ?> cache) {
            this.cache = cache;
        }

        private <K, V> Cache<K, V> getCache() {
            try {
                this.latch.await();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            return this.cache;
        }
    }
}

