/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.nio.charset.Charset;
import org.apache.commons.codec.binary.Base64;
import org.springframework.lang.UsesJava8;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class Base64Utils {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final Base64Delegate delegate;

    private static void assertSupported() {
        Assert.state(delegate != null, "Neither Java 8 nor Apache Commons Codec found - Base64 encoding not supported");
    }

    public static byte[] encode(byte[] src) {
        Base64Utils.assertSupported();
        return delegate.encode(src);
    }

    public static String encodeToString(byte[] src) {
        Base64Utils.assertSupported();
        if (src == null) {
            return null;
        }
        if (src.length == 0) {
            return "";
        }
        return new String(delegate.encode(src), DEFAULT_CHARSET);
    }

    public static byte[] decode(byte[] src) {
        Base64Utils.assertSupported();
        return delegate.decode(src);
    }

    public static byte[] decodeFromString(String src) {
        Base64Utils.assertSupported();
        if (src == null) {
            return null;
        }
        if (src.length() == 0) {
            return new byte[0];
        }
        return delegate.decode(src.getBytes(DEFAULT_CHARSET));
    }

    static {
        Base64Delegate delegateToUse = null;
        if (ClassUtils.isPresent("java.util.Base64", Base64Utils.class.getClassLoader())) {
            delegateToUse = new JdkBase64Delegate();
        } else if (ClassUtils.isPresent("org.apache.commons.codec.binary.Base64", Base64Utils.class.getClassLoader())) {
            delegateToUse = new CommonsCodecBase64Delegate();
        }
        delegate = delegateToUse;
    }

    private static class CommonsCodecBase64Delegate
    implements Base64Delegate {
        private final Base64 base64 = new Base64();

        private CommonsCodecBase64Delegate() {
        }

        @Override
        public byte[] encode(byte[] src) {
            return this.base64.encode(src);
        }

        @Override
        public byte[] decode(byte[] src) {
            return this.base64.decode(src);
        }
    }

    @UsesJava8
    private static class JdkBase64Delegate
    implements Base64Delegate {
        private JdkBase64Delegate() {
        }

        @Override
        public byte[] encode(byte[] src) {
            if (src == null || src.length == 0) {
                return src;
            }
            return java.util.Base64.getEncoder().encode(src);
        }

        @Override
        public byte[] decode(byte[] src) {
            if (src == null || src.length == 0) {
                return src;
            }
            return java.util.Base64.getDecoder().decode(src);
        }
    }

    private static interface Base64Delegate {
        public byte[] encode(byte[] var1);

        public byte[] decode(byte[] var1);
    }
}

