/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.refactoring;

import fitnesse.FitNesseContext;
import fitnesse.http.Request;
import fitnesse.responders.refactoring.PageMovementResponder;
import fitnesse.responders.refactoring.RefactorException;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.refactoring.MovedPageReferenceRenamer;
import fitnesse.wiki.refactoring.ReferenceRenamer;

public class MovePageResponder
extends PageMovementResponder {
    private String newParentName;

    @Override
    protected boolean getAndValidateNewParentPage(FitNesseContext context, Request request) {
        PageCrawler crawler = context.getRootPage().getPageCrawler();
        this.newParentName = MovePageResponder.getNameofNewParent(request);
        if (this.newParentName == null) {
            return false;
        }
        this.newParentPath = PathParser.parse(this.newParentName);
        this.newParentPage = crawler.getPage(this.newParentPath);
        return this.newParentPage != null;
    }

    private static String getNameofNewParent(Request request) {
        String newParentName = request.getInput("newLocation");
        if (".".equals(newParentName)) {
            return "";
        }
        return newParentName;
    }

    @Override
    protected boolean getAndValidateRefactoringParameters(Request request) {
        WikiPagePath newParentPath;
        WikiPagePath pageToBeMovedPath = this.oldRefactoredPage.getPageCrawler().getFullPath();
        return !pageToBeMovedPath.equals(newParentPath = this.newParentPage.getPageCrawler().getFullPath()) && !this.selfPage(pageToBeMovedPath, newParentPath) && !this.pageIsAncestorOfNewParent(pageToBeMovedPath, newParentPath);
    }

    private boolean selfPage(WikiPagePath pageToBeMovedPath, WikiPagePath newParentPath) {
        WikiPagePath originalParentPath = pageToBeMovedPath.parentPath();
        return originalParentPath.equals(newParentPath);
    }

    boolean pageIsAncestorOfNewParent(WikiPagePath pageToBeMovedPath, WikiPagePath newParentPath) {
        return newParentPath.startsWith(pageToBeMovedPath);
    }

    @Override
    protected ReferenceRenamer getReferenceRenamer(FitNesseContext context) {
        return new MovedPageReferenceRenamer(context.getRootPage(), this.oldRefactoredPage, this.newParentName);
    }

    @Override
    protected void execute() throws RefactorException {
        this.movePage(this.oldRefactoredPage, this.newParentPage, this.getNewPageName());
    }

    @Override
    protected String getNewPageName() {
        return this.oldRefactoredPage.getName();
    }

    @Override
    protected String getErrorMessageHeader() {
        return "Cannot move " + this.makeLink(this.oldNameOfPageToBeMoved) + " below " + this.newParentName + ".";
    }
}

