/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.Converter;
import fitnesse.slim.SlimError;
import fitnesse.slim.converters.ConverterRegistry;
import java.util.List;

public class MethodExecutionResult {
    public static final MethodExecutionResult NO_METHOD_IN_LIBRARIES = new MethodExecutionResult((Object)null, null){

        @Override
        public boolean hasResult() {
            return false;
        }
    };
    private final Object value;
    private final Class<?> type;

    MethodExecutionResult(Object value, Class<?> type) {
        this.value = value;
        this.type = type;
    }

    public static MethodExecutionResult noMethod(String methodName, Class<?> clazz, int numberOfArgs) {
        return new NoMethod(methodName, clazz, numberOfArgs);
    }

    public static MethodExecutionResult noInstance(String instanceName) {
        return new NoInstance(instanceName);
    }

    public boolean hasResult() {
        return true;
    }

    public Object returnValue() {
        if (this.type == List.class && this.value instanceof List) {
            return this.value;
        }
        return this.toString();
    }

    public String toString() {
        Converter<?> converter = ConverterRegistry.getConverterForClass(this.type);
        if (converter != null) {
            return converter.toString(this.value);
        }
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    public boolean hasMethod() {
        return !(this instanceof NoMethod);
    }

    public Object getObject() {
        return this.value;
    }

    private static class NoInstance
    extends MethodExecutionResult {
        private final String instanceName;

        NoInstance(String instanceName) {
            super(null, null);
            this.instanceName = instanceName;
        }

        @Override
        public Object returnValue() {
            throw new SlimError(String.format("message:<<%s %s.>>", "NO_INSTANCE", this.instanceName));
        }

        @Override
        public boolean hasResult() {
            return false;
        }
    }

    private static class NoMethod
    extends MethodExecutionResult {
        private final int numberOfArgs;
        private final String methodName;
        private final Class<?> clazz;

        @Override
        public boolean hasResult() {
            return false;
        }

        public NoMethod(String methodName, Class<?> clazz, int numberOfArgs) {
            super(null, null);
            this.methodName = methodName;
            this.clazz = clazz;
            this.numberOfArgs = numberOfArgs;
        }

        @Override
        public Object returnValue() {
            throw new SlimError(String.format("message:<<%s %s[%d] %s.>>", "NO_METHOD_IN_CLASS", this.methodName, this.numberOfArgs, this.clazz.getName()));
        }
    }
}

