/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.socketservice;

import fitnesse.socketservice.SocketFactory;
import fitnesse.socketservice.SocketServer;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SocketService {
    private static final Logger LOG = Logger.getLogger(SocketService.class.getName());
    private final ServerSocket serverSocket;
    private final Thread serviceThread;
    private volatile boolean running = false;
    private final SocketServer server;
    private final LinkedList<Thread> threads = new LinkedList();
    private volatile boolean everRan = false;

    public SocketService(int port, boolean useHTTPS, SocketServer server, String sslParameterClassName) throws IOException {
        this(port, useHTTPS, server, false, sslParameterClassName);
    }

    public SocketService(int port, SocketServer server) throws IOException {
        this(port, false, server, false, null);
    }

    public SocketService(int port, SocketServer server, boolean daemon) throws IOException {
        this(port, false, server, daemon, null);
    }

    public SocketService(int port, boolean useHTTPS, SocketServer server, boolean daemon, String sslParameterClassName) throws IOException {
        this(server, daemon, SocketFactory.tryCreateServerSocket(port, useHTTPS, false, sslParameterClassName));
    }

    public SocketService(SocketServer server, boolean daemon, ServerSocket serverSocket) throws IOException {
        this.server = server;
        this.serverSocket = serverSocket;
        this.serviceThread = new Thread(new Runnable(){

            @Override
            public void run() {
                SocketService.this.serviceThread();
            }
        });
        this.serviceThread.setDaemon(daemon);
        this.serviceThread.start();
    }

    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    public void close() throws IOException {
        this.waitForServiceThreadToStart();
        this.running = false;
        this.serverSocket.close();
        try {
            this.serviceThread.join();
            this.waitForServerThreads();
        }
        catch (InterruptedException e) {
            LOG.log(Level.WARNING, "Thread joining interrupted", e);
        }
    }

    private void waitForServiceThreadToStart() {
        if (this.everRan) {
            return;
        }
        while (!this.running) {
            Thread.yield();
        }
    }

    private void serviceThread() {
        this.running = true;
        while (this.running) {
            try {
                Socket s = this.serverSocket.accept();
                if (!this.everRan) {
                    SocketFactory.printSocketInfo(s);
                }
                this.everRan = true;
                this.startServerThread(s);
            }
            catch (OutOfMemoryError e) {
                LOG.log(Level.SEVERE, "Can't create new thread.  Out of Memory.  Aborting.", e);
                System.exit(99);
            }
            catch (SocketException sox) {
                this.running = false;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServerThread(Socket s) {
        Thread serverThread = new Thread(new ServerRunner(s));
        LinkedList<Thread> linkedList = this.threads;
        synchronized (linkedList) {
            this.threads.add(serverThread);
        }
        serverThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForServerThreads() throws InterruptedException {
        while (!this.threads.isEmpty()) {
            Thread t;
            LinkedList<Thread> linkedList = this.threads;
            synchronized (linkedList) {
                if (this.threads.size() < 1) {
                    return;
                }
                t = this.threads.getFirst();
            }
            t.join();
        }
    }

    private class ServerRunner
    implements Runnable {
        private Socket socket;

        ServerRunner(Socket s) {
            this.socket = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SocketService.this.server.serve(this.socket);
                LinkedList linkedList = SocketService.this.threads;
                synchronized (linkedList) {
                    SocketService.this.threads.remove(Thread.currentThread());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

