/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testrunner;

import fitnesse.components.TraversalListener;
import fitnesse.testrunner.ClassPathBuilder;
import fitnesse.testsystems.ClassPath;
import fitnesse.testsystems.TestPage;
import fitnesse.wiki.BaseWikiPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.ReadOnlyPageData;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wikitext.parser.HtmlTranslator;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.ParsingPage;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.WikiSourcePage;
import java.util.LinkedList;
import java.util.List;

public class WikiTestPage
implements TestPage {
    public static final String TEAR_DOWN = "TearDown";
    public static final String SET_UP = "SetUp";
    private final WikiPage sourcePage;
    private List<WikiPage> scenarioLibraries;
    private WikiPage setUp;
    private WikiPage tearDown;

    public WikiTestPage(WikiPage sourcePage) {
        this.sourcePage = sourcePage;
    }

    public static boolean isTestPage(WikiPage page) {
        return WikiTestPage.isTestPage(page.getData());
    }

    public static boolean isTestPage(ReadOnlyPageData pageData) {
        return pageData.hasAttribute("Test");
    }

    public PageData getData() {
        return this.sourcePage.getData();
    }

    @Override
    public String getHtml() {
        if (this.sourcePage instanceof BaseWikiPage) {
            String content = this.getDecoratedContent();
            ParsingPage parsingPage = BaseWikiPage.makeParsingPage((BaseWikiPage)this.sourcePage);
            Symbol syntaxTree = Parser.make(parsingPage, content).parse();
            return new HtmlTranslator(new WikiSourcePage(this.sourcePage), parsingPage).translateTree(syntaxTree);
        }
        return this.sourcePage.getHtml();
    }

    @Override
    public String getVariable(String variable) {
        return this.sourcePage.getVariable(variable);
    }

    @Override
    public String getFullPath() {
        return PathParser.render(this.sourcePage.getPageCrawler().getFullPath());
    }

    @Override
    public ClassPath getClassPath() {
        return new ClassPath(new ClassPathBuilder().getClassPath(this.sourcePage), this.getPathSeparator());
    }

    protected String getPathSeparator() {
        String separator = this.sourcePage.getVariable("PATH_SEPARATOR");
        if (separator == null) {
            separator = System.getProperty("path.separator");
        }
        return separator;
    }

    public WikiPage getSourcePage() {
        return this.sourcePage;
    }

    protected String getDecoratedContent() {
        StringBuilder decoratedContent = new StringBuilder(1024);
        this.includeScenarioLibraries(decoratedContent);
        this.includePage(this.getSetUp(), "-setup", decoratedContent);
        this.addPageContent(decoratedContent);
        this.includePage(this.getTearDown(), "-teardown", decoratedContent);
        return decoratedContent.toString();
    }

    protected void addPageContent(StringBuilder decoratedContent) {
        String content = this.getData().getContent();
        decoratedContent.append("\n").append(content).append(content.endsWith("\n") ? "" : "\n");
    }

    protected void includeScenarioLibraries(StringBuilder decoratedContent) {
        List<WikiPage> libraries = this.getScenarioLibraries();
        if (!libraries.isEmpty()) {
            if (libraries.size() > 1) {
                decoratedContent.append("!*> Scenario Libraries\n");
            }
            for (WikiPage scenarioLibrary : libraries) {
                this.includeScenarioLibrary(scenarioLibrary, decoratedContent);
            }
            if (libraries.size() > 1) {
                decoratedContent.append("*!\n");
            }
        }
    }

    protected void includeScenarioLibrary(WikiPage scenarioLibrary, StringBuilder newPageContent) {
        newPageContent.append("!include -c .");
        newPageContent.append(this.getPathNameForPage(scenarioLibrary));
        newPageContent.append("\n");
    }

    protected void includePage(WikiPage wikiPage, String arg, StringBuilder newPageContent) {
        if (wikiPage == null) {
            return;
        }
        String pagePathName = this.getPathNameForPage(wikiPage);
        newPageContent.append("!include ").append(arg).append(" .").append(pagePathName).append("\n");
    }

    private String getPathNameForPage(WikiPage page) {
        WikiPagePath pagePath = page.getPageCrawler().getFullPath();
        return PathParser.render(pagePath);
    }

    public String getPath() {
        return this.getPathNameForPage(this.sourcePage);
    }

    public String getName() {
        return this.sourcePage.getName();
    }

    public boolean shouldIncludeScenarioLibraries() {
        boolean isSlim = "slim".equalsIgnoreCase(this.sourcePage.getVariable("TEST_SYSTEM"));
        String includeScenarioLibraries = this.sourcePage.getVariable("INCLUDE_SCENARIO_LIBRARIES");
        boolean includeScenarios = "true".equalsIgnoreCase(includeScenarioLibraries);
        boolean notIncludeScenarios = "false".equalsIgnoreCase(includeScenarioLibraries);
        return includeScenarios || !notIncludeScenarios && isSlim;
    }

    public boolean isTestPage() {
        return WikiTestPage.isTestPage(this.getData());
    }

    public List<WikiPage> getScenarioLibraries() {
        if (this.scenarioLibraries == null) {
            this.scenarioLibraries = this.findScenarioLibraries();
        }
        return this.scenarioLibraries;
    }

    public WikiPage getSetUp() {
        if (this.setUp == null && !this.isSuiteSetUpOrTearDownPage()) {
            this.setUp = this.findInheritedPage(SET_UP);
        }
        return this.setUp;
    }

    public WikiPage getTearDown() {
        if (this.tearDown == null && !this.isSuiteSetUpOrTearDownPage()) {
            this.tearDown = this.findInheritedPage(TEAR_DOWN);
        }
        return this.tearDown;
    }

    protected boolean isSuiteSetUpOrTearDownPage() {
        return "SuiteSetUp".equals(this.getName()) || "SuiteTearDown".equals(this.getName());
    }

    protected WikiPage findInheritedPage(String pageName) {
        return this.sourcePage.getPageCrawler().getClosestInheritedPage(pageName);
    }

    private List<WikiPage> findScenarioLibraries() {
        final LinkedList<WikiPage> uncles = new LinkedList<WikiPage>();
        if (this.shouldIncludeScenarioLibraries()) {
            this.sourcePage.getPageCrawler().traverseUncles("ScenarioLibrary", (TraversalListener<? super WikiPage>)new TraversalListener<WikiPage>(){

                @Override
                public void process(WikiPage page) {
                    uncles.addFirst(page);
                }
            });
        }
        return uncles;
    }
}

