/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.slim.instructions.CallInstruction;
import fitnesse.slim.instructions.Instruction;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.tables.DecisionTableCaller;
import fitnesse.testsystems.slim.tables.ScenarioTable;
import fitnesse.testsystems.slim.tables.SlimAssertion;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.testsystems.slim.tables.SyntaxError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DecisionTable
extends SlimTable {
    private static final String instancePrefix = "decisionTable";

    public DecisionTable(Table table, String id, SlimTestContext context) {
        super(table, id, context);
    }

    @Override
    protected String getTableType() {
        return instancePrefix;
    }

    @Override
    public List<SlimAssertion> getAssertions() throws SyntaxError {
        if (this.table.getRowCount() == 2) {
            throw new SyntaxError("DecisionTables should have at least three rows.");
        }
        String scenarioName = this.getScenarioName();
        ScenarioTable scenario = this.getTestContext().getScenario(scenarioName);
        if (scenario != null) {
            return new ScenarioCaller().call(scenario);
        }
        scenarioName = this.getFixtureName();
        scenario = this.getTestContext().getScenario(scenarioName);
        if (scenario != null) {
            return new ScenarioCallerWithConstuctorParameters().call(scenario);
        }
        return new FixtureCaller().call(this.getFixtureName());
    }

    private String getScenarioName() {
        StringBuffer nameBuffer = new StringBuffer();
        for (int nameCol = 0; nameCol < this.table.getColumnCountInRow(0); nameCol += 2) {
            if (nameCol == 0) {
                nameBuffer.append(this.getFixtureName(this.table.getCellContents(nameCol, 0)));
            } else {
                nameBuffer.append(this.table.getCellContents(nameCol, 0));
            }
            nameBuffer.append(" ");
        }
        return SlimTable.Disgracer.disgraceClassName(nameBuffer.toString().trim());
    }

    protected Instruction callAndAssign(String symbolName, String functionName) {
        return this.callAndAssign(symbolName, this.getTableName(), functionName, new Object[0]);
    }

    private class FixtureCaller
    extends DecisionTableCaller {
        public FixtureCaller() {
            super(DecisionTable.this.table);
        }

        public List<SlimAssertion> call(String fixtureName) throws SyntaxError {
            ArrayList<SlimAssertion> assertions = new ArrayList<SlimAssertion>();
            assertions.add(DecisionTable.this.constructFixture(fixtureName));
            assertions.add(DecisionTable.this.makeAssertion(DecisionTable.this.callFunction(DecisionTable.this.getTableName(), "table", DecisionTable.this.tableAsList()), new SlimTable.SilentReturnExpectation(DecisionTable.this, 0, 0)));
            if (DecisionTable.this.table.getRowCount() > 2) {
                assertions.addAll(this.invokeRows());
            }
            return assertions;
        }

        private List<SlimAssertion> invokeRows() throws SyntaxError {
            ArrayList<SlimAssertion> assertions = new ArrayList<SlimAssertion>();
            assertions.add(this.callUnreportedFunction("beginTable", 0));
            this.gatherFunctionsAndVariablesFromColumnHeader();
            for (int row = 2; row < DecisionTable.this.table.getRowCount(); ++row) {
                assertions.addAll(this.invokeRow(row));
            }
            assertions.add(this.callUnreportedFunction("endTable", 0));
            return assertions;
        }

        private List<SlimAssertion> invokeRow(int row) throws SyntaxError {
            ArrayList<SlimAssertion> assertions = new ArrayList<SlimAssertion>();
            this.checkRow(row);
            assertions.add(this.callUnreportedFunction("reset", row));
            assertions.addAll(this.setVariables(row));
            assertions.add(this.callUnreportedFunction("execute", row));
            assertions.addAll(this.callFunctions(row));
            return assertions;
        }

        private SlimAssertion callUnreportedFunction(String functionName, int row) {
            return DecisionTable.this.makeAssertion(DecisionTable.this.callFunction(DecisionTable.this.getTableName(), functionName, new Object[0]), new SlimTable.SilentReturnExpectation(DecisionTable.this, 0, row));
        }

        private List<SlimAssertion> callFunctions(int row) {
            ArrayList<SlimAssertion> instructions = new ArrayList<SlimAssertion>();
            for (String functionName : this.funcStore.getLeftToRightAndResetColumnNumberIterator()) {
                instructions.add(this.callFunctionInRow(functionName, row));
            }
            return instructions;
        }

        private SlimAssertion callFunctionInRow(String functionName, int row) {
            int col = this.funcStore.getColumnNumber(functionName);
            String assignedSymbol = DecisionTable.this.ifSymbolAssignment(col, row);
            SlimAssertion assertion = assignedSymbol != null ? DecisionTable.this.makeAssertion(DecisionTable.this.callAndAssign(assignedSymbol, functionName), new SlimTable.SymbolAssignmentExpectation((SlimTable)DecisionTable.this, assignedSymbol, col, row)) : DecisionTable.this.makeAssertion(DecisionTable.this.callFunction(DecisionTable.this.getTableName(), functionName, new Object[0]), new SlimTable.ReturnedValueExpectation(DecisionTable.this, col, row));
            return assertion;
        }

        private List<SlimAssertion> setVariables(int row) {
            ArrayList<SlimAssertion> assertions = new ArrayList<SlimAssertion>();
            for (String var : this.varStore.getLeftToRightAndResetColumnNumberIterator()) {
                int col = this.varStore.getColumnNumber(var);
                String valueToSet = DecisionTable.this.table.getCellContents(col, row);
                CallInstruction setInstruction = new CallInstruction(DecisionTable.this.makeInstructionTag(), DecisionTable.this.getTableName(), SlimTable.Disgracer.disgraceMethodName("set " + var), new Object[]{valueToSet});
                assertions.add(DecisionTable.this.makeAssertion(setInstruction, new SlimTable.VoidReturnExpectation(DecisionTable.this, col, row)));
            }
            return assertions;
        }
    }

    private class ScenarioCallerWithConstuctorParameters
    extends ScenarioCaller {
        public ScenarioCallerWithConstuctorParameters() {
            this.gatherConstructorParameters();
        }
    }

    private class ScenarioCaller
    extends DecisionTableCaller {
        public ScenarioCaller() {
            super(DecisionTable.this.table);
        }

        public ArrayList<SlimAssertion> call(ScenarioTable scenario) throws SyntaxError {
            this.gatherFunctionsAndVariablesFromColumnHeader();
            ArrayList<SlimAssertion> assertions = new ArrayList<SlimAssertion>();
            for (int row = 2; row < DecisionTable.this.table.getRowCount(); ++row) {
                assertions.addAll(this.callScenarioForRow(scenario, row));
                assertions.addAll(this.callFunctions(row));
            }
            return assertions;
        }

        private List<SlimAssertion> callScenarioForRow(ScenarioTable scenario, int row) throws SyntaxError {
            this.checkRow(row);
            return scenario.call(this.getArgumentsForRow(row), DecisionTable.this, row);
        }

        private List<SlimAssertion> callFunctions(int row) {
            ArrayList<SlimAssertion> instructions = new ArrayList<SlimAssertion>();
            for (String functionName : this.funcStore.getLeftToRightAndResetColumnNumberIterator()) {
                instructions.add(this.callFunctionInRow(functionName, row));
            }
            return instructions;
        }

        private SlimAssertion callFunctionInRow(String functionName, int row) {
            int col = this.funcStore.getColumnNumber(functionName);
            String name = SlimTable.Disgracer.disgraceMethodName(functionName);
            String assignedSymbol = DecisionTable.this.ifSymbolAssignment(col, row);
            SlimAssertion assertion = assignedSymbol != null ? DecisionTable.this.makeAssertion(DecisionTable.this.callAndAssign(assignedSymbol, "scriptTableActor", "cloneSymbol", "$" + functionName), new SlimTable.ReturnedSymbolExpectation(DecisionTable.this, col, row, name, assignedSymbol)) : DecisionTable.this.makeAssertion(Instruction.NOOP_INSTRUCTION, new SlimTable.ReturnedSymbolExpectation(DecisionTable.this, col, row, name));
            return assertion;
        }

        private Map<String, String> getArgumentsForRow(int row) {
            String valueToSet;
            int col;
            String disgracedVar;
            HashMap<String, String> scenarioArguments = new HashMap<String, String>();
            for (String var : this.constructorParameterStore.getLeftToRightAndResetColumnNumberIterator()) {
                disgracedVar = SlimTable.Disgracer.disgraceMethodName(var);
                col = this.constructorParameterStore.getColumnNumber(var);
                valueToSet = DecisionTable.this.table.getCellContents(col, 0);
                scenarioArguments.put(disgracedVar, valueToSet);
            }
            for (String var : this.varStore.getLeftToRightAndResetColumnNumberIterator()) {
                disgracedVar = SlimTable.Disgracer.disgraceMethodName(var);
                col = this.varStore.getColumnNumber(var);
                valueToSet = DecisionTable.this.table.getCellContents(col, row);
                scenarioArguments.put(disgracedVar, valueToSet);
            }
            return scenarioArguments;
        }
    }
}

