/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.updates;

import fitnesse.FitNesseContext;
import fitnesse.updates.FileUpdate;
import fitnesse.updates.ReplacingFileUpdate;
import fitnesse.updates.Update;
import fitnesse.updates.UpdaterBase;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import util.FileUtil;

public class UpdaterImplementation
extends UpdaterBase {
    private List<String> updateDoNotCopyOver = new ArrayList<String>();
    private List<String> updateList = new ArrayList<String>();
    private String fitNesseVersion;

    public UpdaterImplementation(FitNesseContext context) throws IOException {
        super(context);
        this.createUpdateAndDoNotCopyOverLists();
        this.updates = this.makeAllUpdates();
        this.fitNesseVersion = context.version.toString();
    }

    private Update[] makeAllUpdates() {
        ArrayList<Update> updates = new ArrayList<Update>();
        this.addAllFilesToBeReplaced(updates);
        this.addAllFilesThatShouldNotBeCopiedOver(updates);
        return updates.toArray(new Update[updates.size()]);
    }

    private void addAllFilesThatShouldNotBeCopiedOver(List<Update> updates) {
        for (String nonCopyableFile : this.updateDoNotCopyOver) {
            String path = this.getCorrectPathForTheDestination(nonCopyableFile);
            String source = this.getCorrectPathFromJar(nonCopyableFile);
            updates.add(new FileUpdate(source, path));
        }
    }

    private void addAllFilesToBeReplaced(List<Update> updates) {
        for (String updateableFile : this.updateList) {
            String path = this.getCorrectPathForTheDestination(updateableFile);
            String source = this.getCorrectPathFromJar(updateableFile);
            updates.add(new ReplacingFileUpdate(source, path));
        }
    }

    public String getCorrectPathFromJar(String updateableFile) {
        return "Resources/" + updateableFile;
    }

    public String getCorrectPathForTheDestination(String updateableFile) {
        if (updateableFile.startsWith("FitNesseRoot")) {
            updateableFile = updateableFile.replace("FitNesseRoot", this.context.getRootPagePath());
        }
        return FileUtil.getPathOfFile(updateableFile);
    }

    private void createUpdateAndDoNotCopyOverLists() throws IOException {
        this.getUpdateFilesFromJarFile();
        File updateFileList = new File(this.context.getRootPagePath(), "updateList");
        File updateDoNotCopyOverFileList = new File(this.context.getRootPagePath(), "updateDoNotCopyOverList");
        this.tryToParseTheFileIntoTheList(updateFileList, this.updateList);
        this.tryToParseTheFileIntoTheList(updateDoNotCopyOverFileList, this.updateDoNotCopyOver);
    }

    public void getUpdateFilesFromJarFile() throws IOException {
        FileUpdate update = new FileUpdate("Resources/updateList", this.context.getRootPagePath());
        update.doUpdate();
        update = new FileUpdate("Resources/updateDoNotCopyOverList", this.context.getRootPagePath());
        update.doUpdate();
    }

    public void tryToParseTheFileIntoTheList(File updateFileList, List<String> list) {
        if (!updateFileList.exists()) {
            throw new RuntimeException("Could Not Find UpdateList");
        }
        try {
            this.parseTheFileContentToAList(updateFileList, list);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void parseTheFileContentToAList(File updateFileList, List<String> list) throws IOException {
        String[] filePaths;
        String content = FileUtil.getFileContent(updateFileList);
        for (String path : filePaths = content.split("\n")) {
            list.add(path);
        }
    }

    @Override
    public boolean update() throws IOException {
        if (this.shouldUpdate()) {
            LOG.info("Unpacking new version of FitNesse resources. Please be patient...");
            super.update();
            LOG.info("**********************************************************");
            LOG.info("Files have been updated to a new version.");
            LOG.info("Please read the release notes on ");
            LOG.info("http://localhost:" + (this.context != null ? Integer.valueOf(this.context.port) : "xxx") + "/FitNesse.ReleaseNotes");
            LOG.info("to find out about the new features and fixes.");
            LOG.info("**********************************************************");
            this.getProperties().put("Version", this.fitNesseVersion);
            this.saveProperties();
            return true;
        }
        return false;
    }

    private boolean shouldUpdate() {
        String versionProperty = this.getProperties().getProperty("Version");
        return versionProperty == null || !versionProperty.equals(this.fitNesseVersion);
    }

    public void setFitNesseVersion(String version) {
        this.fitNesseVersion = version;
    }
}

