/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiImportProperty;
import java.util.Date;
import java.util.GregorianCalendar;

public class VersionInfo
implements Comparable<VersionInfo> {
    private String name;
    private String author;
    private Date creationTime;

    public VersionInfo(String name, String author, Date creationTime) {
        this.name = name;
        this.author = author;
        this.creationTime = new Date(creationTime.getTime());
    }

    public static VersionInfo makeVersionInfo(String author, Date creationTime) {
        String versionName = WikiImportProperty.getTimeFormat().format(creationTime);
        if (author != null && !"".equals(author)) {
            versionName = author + "-" + versionName;
        }
        return new VersionInfo(versionName, author, creationTime);
    }

    public static VersionInfo makeVersionInfo(PageData data) {
        return VersionInfo.makeVersionInfo(data.getAttribute("LastModifyingUser"), data.getProperties().getLastModificationTime());
    }

    public String getAuthor() {
        return this.author;
    }

    public Date getCreationTime() {
        return new Date(this.creationTime.getTime());
    }

    public String getName() {
        return this.name;
    }

    public String getAge() {
        Date now = new GregorianCalendar().getTime();
        return VersionInfo.howLongAgoString(now, this.getCreationTime());
    }

    public static String howLongAgoString(Date now, Date then) {
        long time = Math.abs(now.getTime() - then.getTime()) / 1000L;
        if (time < 60L) {
            return VersionInfo.pluralize(time, "second");
        }
        if (time < 3600L) {
            return VersionInfo.pluralize(time / 60L, "minute");
        }
        if (time < 86400L) {
            return VersionInfo.pluralize(time / 3600L, "hour");
        }
        if (time < 31536000L) {
            return VersionInfo.pluralize(time / 86400L, "day");
        }
        return VersionInfo.pluralize(time / 31536000L, "year");
    }

    private static String pluralize(long time, String unit) {
        String age = time + " " + unit;
        if (time > 1L) {
            age = age + "s";
        }
        return age;
    }

    @Override
    public int compareTo(VersionInfo otherVersion) {
        return this.getCreationTime().compareTo(otherVersion.getCreationTime());
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof VersionInfo) {
            VersionInfo otherVersion = (VersionInfo)o;
            return this.getName().equals(otherVersion.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

