/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.html.HtmlTag;
import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Maybe;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;

public class HashTable
extends SymbolType
implements Rule,
Translation {
    private static final SymbolType[] terminators = new SymbolType[]{SymbolType.Colon, SymbolType.Comma, SymbolType.CloseBrace};
    private static final String[] cellClasses = new String[]{"hash_key", "hash_value"};

    public HashTable() {
        super("HashTable");
        this.wikiMatcher(new Matcher().string("!{"));
        this.wikiRule(this);
        this.htmlTranslation(this);
    }

    @Override
    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        do {
            Symbol row = new Symbol(SymbolType.SymbolList);
            current.add(row);
            for (int i = 0; i < 2; ++i) {
                Symbol cell = parser.parseToIgnoreFirst(terminators);
                if (parser.atEnd() || cell.getChildren().isEmpty()) {
                    return Symbol.nothing;
                }
                row.add(cell);
            }
        } while (!parser.getCurrent().isType(SymbolType.CloseBrace));
        return new Maybe<Symbol>(current);
    }

    @Override
    public String toTarget(Translator translator, Symbol symbol) {
        HtmlTag table = new HtmlTag("table");
        table.addAttribute("class", "hash_table");
        for (Symbol child : symbol.getChildren()) {
            HtmlTag row = new HtmlTag("tr");
            row.addAttribute("class", "hash_row");
            table.add(row);
            for (int i = 0; i < 2; ++i) {
                String body = translator.translate(child.childAt(i));
                HtmlTag cell = new HtmlTag("td", body.trim());
                cell.addAttribute("class", cellClasses[i]);
                row.add(cell);
            }
        }
        return table.html();
    }
}

