/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.Maybe;
import fitnesse.wikitext.parser.ScanString;
import fitnesse.wikitext.parser.SymbolStream;
import fitnesse.wikitext.parser.SymbolType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Matcher {
    private static final List<Character> defaultList = Collections.unmodifiableList(Arrays.asList(Character.valueOf('\u0000')));
    private List<ScanMatch> matches = new ArrayList<ScanMatch>(4);
    private List<Character> firsts = null;

    public List<Character> getFirsts() {
        return this.firsts != null ? this.firsts : defaultList;
    }

    public Matcher whitespace() {
        if (this.firsts == null) {
            this.firsts = defaultList;
        }
        this.matches.add(new ScanMatch(){

            @Override
            public Maybe<Integer> match(ScanString input, SymbolStream symbols, int offset) {
                int length = input.whitespaceLength(offset);
                return length > 0 ? new Maybe<Integer>(length) : Maybe.noInteger;
            }
        });
        return this;
    }

    public Matcher startLine() {
        this.matches.add(new ScanMatch(){

            @Override
            public Maybe<Integer> match(ScanString input, SymbolStream symbols, int offset) {
                return Matcher.this.isStartLine(input, symbols, offset) ? new Maybe<Integer>(0) : Maybe.noInteger;
            }
        });
        return this;
    }

    public Matcher startLineOrCell() {
        this.matches.add(new ScanMatch(){

            @Override
            public Maybe<Integer> match(ScanString input, SymbolStream symbols, int offset) {
                return Matcher.this.isStartLine(input, symbols, offset) || Matcher.this.isStartCell(symbols) ? new Maybe<Integer>(0) : Maybe.noInteger;
            }
        });
        return this;
    }

    private boolean isStartLine(ScanString input, SymbolStream symbols, int offset) {
        return input.startsLine(offset) || symbols.get(0).isStartLine();
    }

    private boolean isStartCell(SymbolStream symbols) {
        return symbols.get(0).isStartCell() || symbols.get(0).isType(SymbolType.Whitespace) && (symbols.get(1).isStartCell() || symbols.get(1).isLineType());
    }

    public Matcher string(final String delimiter) {
        if (this.firsts == null) {
            this.firsts = Collections.singletonList(Character.valueOf(delimiter.charAt(0)));
        }
        this.matches.add(new ScanMatch(){

            @Override
            public Maybe<Integer> match(ScanString input, SymbolStream symbols, int offset) {
                return input.matches(delimiter, offset) ? new Maybe<Integer>(delimiter.length()) : Maybe.noInteger;
            }
        });
        return this;
    }

    public Matcher listDigit() {
        this.firstIsDigit('1');
        this.matches.add(new ScanMatch(){

            @Override
            public Maybe<Integer> match(ScanString input, SymbolStream symbols, int offset) {
                return Matcher.this.isDigitInput('1', input, offset) ? new Maybe<Integer>(1) : Maybe.noInteger;
            }
        });
        return this;
    }

    private boolean isDigitInput(char firstDigit, ScanString input, int offset) {
        for (char i = firstDigit; i <= '9'; i = (char)(i + '\u0001')) {
            if (!input.matches(new String(new char[]{i}), offset)) continue;
            return true;
        }
        return false;
    }

    private void firstIsDigit(char startDigit) {
        if (this.firsts == null) {
            this.firsts = new ArrayList<Character>();
            for (char i = startDigit; i <= '9'; i = (char)(i + '\u0001')) {
                this.firsts.add(Character.valueOf(i));
            }
        }
    }

    public Matcher digits() {
        this.firstIsDigit('0');
        this.matches.add(new ScanMatch(){

            @Override
            public Maybe<Integer> match(ScanString input, SymbolStream symbols, int offset) {
                int size = 0;
                while (Matcher.this.isDigitInput('0', input, offset + size)) {
                    ++size;
                }
                return size > 0 ? new Maybe<Integer>(size) : Maybe.noInteger;
            }
        });
        return this;
    }

    public Matcher ignoreWhitespace() {
        this.matches.add(new ScanMatch(){

            @Override
            public Maybe<Integer> match(ScanString input, SymbolStream symbols, int offset) {
                return new Maybe<Integer>(input.whitespaceLength(offset));
            }
        });
        return this;
    }

    public Matcher repeat(final char delimiter) {
        if (this.firsts == null) {
            this.firsts = Collections.singletonList(Character.valueOf(delimiter));
        }
        this.matches.add(new ScanMatch(){

            @Override
            public Maybe<Integer> match(ScanString input, SymbolStream symbols, int offset) {
                int size = 0;
                while (input.charAt(offset + size) == delimiter) {
                    ++size;
                }
                return size > 0 ? new Maybe<Integer>(size) : Maybe.noInteger;
            }
        });
        return this;
    }

    public Matcher endsWith(final char[] terminators) {
        this.matches.add(new ScanMatch(){

            @Override
            public Maybe<Integer> match(ScanString input, SymbolStream symbols, int offset) {
                int size = 0;
                while (true) {
                    char candidate;
                    if ((candidate = input.charAt(offset + size)) == '\u0000') {
                        return Maybe.noInteger;
                    }
                    if (this.contains(terminators, candidate)) break;
                    ++size;
                }
                return size > 0 ? new Maybe<Integer>(size + 1) : Maybe.noInteger;
            }

            private boolean contains(char[] terminators2, char candidate) {
                for (char terminator : terminators2) {
                    if (candidate != terminator) continue;
                    return true;
                }
                return false;
            }
        });
        return this;
    }

    public Maybe<Integer> makeMatch(ScanString input, SymbolStream symbols) {
        int totalLength = 0;
        for (ScanMatch match : this.matches) {
            Maybe<Integer> matchLength = match.match(input, symbols, totalLength);
            if (matchLength.isNothing()) {
                return Maybe.noInteger;
            }
            totalLength += matchLength.getValue().intValue();
        }
        return new Maybe<Integer>(totalLength);
    }

    private static interface ScanMatch {
        public Maybe<Integer> match(ScanString var1, SymbolStream var2, int var3);
    }
}

