/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.TreeSet;
import util.StreamReader;

public class FileUtil {
    public static File createFile(String path, String content) {
        return FileUtil.createFile(path, (InputStream)new ByteArrayInputStream(content.getBytes()));
    }

    public static File createFile(String path, InputStream content) {
        String[] names = path.split("/");
        if (names.length == 1) {
            return FileUtil.createFile(new File(path), content);
        }
        File parent = null;
        for (int i = 0; i < names.length - 1; ++i) {
            File file = parent = parent == null ? new File(names[i]) : new File(parent, names[i]);
            if (parent.exists()) continue;
            parent.mkdir();
        }
        File fileToCreate = new File(parent, names[names.length - 1]);
        return FileUtil.createFile(fileToCreate, content);
    }

    public static File createFile(File file, String content) {
        try {
            return FileUtil.createFile(file, content.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static File createFile(File file, byte[] bytes) {
        return FileUtil.createFile(file, (InputStream)new ByteArrayInputStream(bytes));
    }

    public static File createFile(File file, InputStream content) {
        FileOutputStream fileOutput = null;
        try {
            fileOutput = new FileOutputStream(file);
            FileUtil.copyBytes(content, fileOutput);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fileOutput != null) {
                try {
                    fileOutput.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return file;
    }

    public static boolean makeDir(String path) {
        return new File(path).mkdir();
    }

    public static void deleteFileSystemDirectory(String dirPath) {
        FileUtil.deleteFileSystemDirectory(new File(dirPath));
    }

    public static void deleteFileSystemDirectory(File current) {
        File[] files = current.listFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                FileUtil.deleteFileSystemDirectory(file);
                continue;
            }
            FileUtil.deleteFile(file);
        }
        FileUtil.deleteFile(current);
    }

    public static void deleteFile(String filename) {
        FileUtil.deleteFile(new File(filename));
    }

    public static void deleteFile(File file) {
        if (!file.exists()) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            if (file.delete()) {
                FileUtil.waitUntilFileDeleted(file);
                return;
            }
            FileUtil.waitFor(10);
        }
        throw new RuntimeException("Could not delete '" + file.getAbsoluteFile() + "'");
    }

    private static void waitUntilFileDeleted(File file) {
        int i = 10;
        while (file.exists() && --i > 0) {
            FileUtil.waitFor(500);
        }
    }

    private static void waitFor(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String getFileContent(String path) throws IOException {
        File input = new File(path);
        return FileUtil.getFileContent(input);
    }

    public static String getFileContent(File input) throws IOException {
        return new String(FileUtil.getFileBytes(input), "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileBytes(File input) throws IOException {
        long size = input.length();
        FileInputStream stream = null;
        try {
            byte[] bytes;
            stream = new FileInputStream(input);
            byte[] byArray = bytes = new StreamReader(stream).readBytes((int)size);
            return byArray;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedList<String> getFileLines(File file) throws IOException {
        LinkedList<String> lines = new LinkedList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        finally {
            reader.close();
        }
        return lines;
    }

    public static void writeLinesToFile(File file, List<?> lines) throws FileNotFoundException {
        PrintStream output = new PrintStream(new FileOutputStream(file));
        for (String line : lines) {
            output.println(line);
        }
        output.close();
    }

    public static void copyBytes(InputStream input, OutputStream output) throws IOException {
        StreamReader reader = new StreamReader(input);
        while (!reader.isEof()) {
            output.write(reader.readBytes(1000));
        }
    }

    public static String toString(InputStream input) throws IOException {
        String result = "";
        Scanner s = new Scanner(input, "UTF-8");
        s.useDelimiter("\\A");
        result = s.hasNext() ? s.next() : "";
        s.close();
        return result;
    }

    public static File createDir(String path) {
        FileUtil.makeDir(path);
        return new File(path);
    }

    public static File[] getDirectoryListing(File dir) {
        TreeSet<File> dirSet = new TreeSet<File>();
        TreeSet<File> fileSet = new TreeSet<File>();
        File[] files = dir.listFiles();
        if (files == null) {
            return new File[0];
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                dirSet.add(files[i]);
                continue;
            }
            fileSet.add(files[i]);
        }
        LinkedList<File> fileList = new LinkedList<File>();
        fileList.addAll(dirSet);
        fileList.addAll(fileSet);
        return fileList.toArray(new File[fileList.size()]);
    }

    public static String buildPath(String[] parts) {
        String separator = System.getProperty("file.separator");
        StringBuilder builder = new StringBuilder();
        for (String part : parts) {
            if (builder.length() > 0) {
                builder.append(separator);
            }
            builder.append(part);
        }
        return builder.toString();
    }

    public static List<String> breakFilenameIntoParts(String fileName) {
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList(fileName.split("/")));
        return parts;
    }

    public static String getPathOfFile(String fileName) {
        List<String> parts = FileUtil.breakFilenameIntoParts(fileName);
        parts.remove(parts.size() - 1);
        return FileUtil.buildPath(parts.toArray(new String[parts.size()]));
    }

    public static void close(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to close writer", e);
            }
        }
    }

    public static void close(OutputStream output) {
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to close outputstream", e);
            }
        }
    }

    public static void close(InputStream input) {
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to close inputstream", e);
            }
        }
    }
}

