/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.RuntimeRepositoryException;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.JcrRepositoryService;
import com.xebialabs.deployit.repository.NodeUtils;
import com.xebialabs.deployit.repository.NodeWriter;
import com.xebialabs.deployit.repository.RepositoryUtils;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.deployit.repository.internal.Root;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.deployit.util.Tuple;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.license.service.LicenseTransaction;
import com.xebialabs.xlplatform.artifact.resolution.ArtifactResolverRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConversions;
import scala.collection.Seq;

class JcrChangeSetExecutor
implements JcrCallback<Object> {
    private final JcrRepositoryService jcrRepositoryService;
    private final ChangeSet changeset;
    private final PasswordEncrypter passwordEncrypter;
    private final LicenseService licenseService;
    private static Logger logger = LoggerFactory.getLogger(JcrChangeSetExecutor.class);

    JcrChangeSetExecutor(JcrRepositoryService jcrRepositoryService, ChangeSet changeset, PasswordEncrypter passwordEncrypter, LicenseService licenseService) {
        this.jcrRepositoryService = (JcrRepositoryService)Preconditions.checkNotNull((Object)jcrRepositoryService);
        this.changeset = (ChangeSet)Preconditions.checkNotNull((Object)changeset);
        this.passwordEncrypter = (PasswordEncrypter)Preconditions.checkNotNull((Object)passwordEncrypter);
        this.licenseService = licenseService;
    }

    @Override
    public Object doInJcr(Session session) throws RepositoryException {
        this.execute(session, false);
        return null;
    }

    void execute(Session session, boolean dryRun) throws RepositoryException {
        LicenseTransaction licenseTransaction = this.licenseService.startTransaction();
        try {
            if (dryRun) {
                logger.debug("Not saving JCR checkpoints in dry run");
            } else if (this.changeset.isDisableVersionHistory()) {
                logger.debug("Not saving JCR checkpoints because version history has been disabled");
            } else {
                this.checkpointNodes(this.changeset, session);
            }
            this.createEntities(this.changeset, session, licenseTransaction);
            this.createOrUpdateEntities(this.changeset, session, licenseTransaction);
            this.updateEntities(this.changeset, session);
            this.moveEntities(this.changeset.getMoveCis(), session);
            this.renameEntities(this.changeset.getRenameCis(), session);
            this.copyEntities(this.changeset.getCopyCis(), session, licenseTransaction);
            SortedMap<String, VersionHistory> versionHistories = this.deleteEntities(this.changeset.getDeleteCiIds(), session, licenseTransaction);
            if (dryRun) {
                logger.debug("Not committing JCR session and not removing JCR version histories in dry run");
                this.licenseService.rollbackTransaction(licenseTransaction);
            } else {
                this.saveSession(session);
                this.removeVersionHistories(versionHistories);
            }
        }
        catch (ReferentialIntegrityException exc) {
            this.licenseService.rollbackTransaction(licenseTransaction);
            throw new ItemInUseException((Throwable)exc, "Cannot delete configuration items [%s] because one of the configuration items, or one of their children, is still being referenced", new Object[]{Joiner.on((char)',').join((Iterable)this.changeset.getDeleteCiIds())});
        }
        catch (Exception e) {
            this.licenseService.rollbackTransaction(licenseTransaction);
            throw e;
        }
    }

    private void checkpointNodes(ChangeSet changeset, final Session session) throws RepositoryException {
        logger.debug("Saving JCR checkpoints");
        Predicate<ConfigurationItem> ciExists = new Predicate<ConfigurationItem>(){

            public boolean apply(ConfigurationItem ci) {
                try {
                    return session.nodeExists(JcrPathHelper.getAbsolutePathFromId(ci.getId()));
                }
                catch (RepositoryException e) {
                    throw new RuntimeRepositoryException(e.getMessage(), e);
                }
            }
        };
        Predicate<ConfigurationItem> ciIsVersioned = new Predicate<ConfigurationItem>(){

            public boolean apply(ConfigurationItem ci) {
                return ci.getType().getDescriptor().isVersioned();
            }
        };
        Iterable updateCisFromCreateOrUpdate = Iterables.filter((Iterable)changeset.getCreateOrUpdateCis(), (Predicate)Predicates.and((Predicate)ciIsVersioned, (Predicate)ciExists));
        Iterable updateCis = Iterables.filter((Iterable)changeset.getUpdateCis(), (Predicate)ciIsVersioned);
        for (ConfigurationItem ci : Iterables.concat((Iterable)updateCisFromCreateOrUpdate, (Iterable)updateCis)) {
            this.checkpoint(session.getNode(JcrPathHelper.getAbsolutePathFromId(ci.getId())), session);
        }
        for (String id : changeset.getDeleteCiIds()) {
            if (!session.nodeExists(JcrPathHelper.getAbsolutePathFromId(id))) continue;
            Node node = session.getNode(JcrPathHelper.getAbsolutePathFromId(id));
            this.deepCheckpoint(node, session);
        }
    }

    private void deepCheckpoint(Node node, Session session) throws RepositoryException {
        this.checkpoint(node, session);
        NodeIterator nodes = node.getNodes();
        while (nodes.hasNext()) {
            this.deepCheckpoint(nodes.nextNode(), session);
        }
    }

    private void checkpoint(Node node, Session session) throws RepositoryException {
        if (node.isNodeType("{http://www.jcp.org/jcr/mix/1.0}versionable")) {
            logger.debug("Checkpointing node [{}]", (Object)JcrPathHelper.getIdFromAbsolutePath(node.getPath()));
            VersionManager versionManager = session.getWorkspace().getVersionManager();
            versionManager.checkpoint(node.getPath());
        }
    }

    private void createEntities(ChangeSet changeset, Session session, LicenseTransaction licenseTransaction) throws RepositoryException {
        List createCis = changeset.getCreateCis();
        if (!createCis.isEmpty()) {
            logger.debug("Creating nodes...");
        }
        this.createNodes(createCis, session, licenseTransaction);
    }

    private void updateEntities(ChangeSet changeset, Session session) throws RepositoryException {
        List updateCis = changeset.getUpdateCis();
        if (!updateCis.isEmpty()) {
            logger.debug("Updating nodes...");
        }
        this.updateNodes(updateCis, session);
    }

    private void createOrUpdateEntities(ChangeSet changeset, Session session, LicenseTransaction licenseTransaction) throws RepositoryException {
        List createOrUpdateCis = changeset.getCreateOrUpdateCis();
        if (!createOrUpdateCis.isEmpty()) {
            logger.debug("Creating or updating nodes...");
        }
        ArrayList toBeCreated = Lists.newArrayList();
        ArrayList toBeUpdated = Lists.newArrayList();
        for (ConfigurationItem createOrUpdateCi : createOrUpdateCis) {
            if (!session.nodeExists(JcrPathHelper.getAbsolutePathFromId(createOrUpdateCi.getId()))) {
                toBeCreated.add(createOrUpdateCi);
                continue;
            }
            toBeUpdated.add(createOrUpdateCi);
        }
        changeset.getCreateOrUpdateActualCreatedCis().addAll(toBeCreated);
        changeset.getCreateOrUpdateActualUpdatedCis().addAll(toBeUpdated);
        this.createNodes(toBeCreated, session, licenseTransaction);
        this.updateNodes(toBeUpdated, session);
    }

    private List<Node> retrieveNodes(Iterable<ConfigurationItem> cis, Session session) throws RepositoryException {
        ArrayList nodes = Lists.newArrayList();
        for (ConfigurationItem ci : cis) {
            Preconditions.checkNotNull((Object)ci, (Object)"ci is null");
            try {
                Node node = session.getNode(JcrPathHelper.getAbsolutePathFromId(ci.getId()));
                nodes.add(node);
            }
            catch (PathNotFoundException exc) {
                throw new NotFoundException("Repository entity [%s] not found", new Object[]{ci.getId()});
            }
        }
        return nodes;
    }

    private void createNodes(List<ConfigurationItem> createCis, Session session, LicenseTransaction licenseTransaction) throws RepositoryException {
        this.verifyEntitiesMeetCreationPreconditions(createCis);
        Collections.sort(createCis, new SortHierarchyComparator());
        this.licenseService.getCounter().registerCisCreation((Seq)JavaConversions.asScalaBuffer(createCis), licenseTransaction);
        ArrayList writers = Lists.newArrayList();
        for (ConfigurationItem entity : createCis) {
            Node node = this.createNode(entity, session);
            NodeWriter nodeWriter = new NodeWriter(session, entity, node, this.passwordEncrypter);
            nodeWriter.writeBasics();
            writers.add(nodeWriter);
        }
        for (NodeWriter writer : writers) {
            writer.write();
        }
    }

    private Node createNode(ConfigurationItem entity, Session session) throws RepositoryException {
        this.validateNodeStoredInCorrectPath(entity.getId(), entity.getType(), session);
        logger.debug("Creating node [{}]", (Object)entity.getId());
        Node node = session.getRootNode().addNode(entity.getId());
        int index = node.getIndex();
        if (index != 1) {
            node.remove();
            throw new ItemAlreadyExistsException("A Configuration Item with ID [%s] already exists.", new Object[]{entity.getId()});
        }
        this.setMixins(entity, node);
        return node;
    }

    private void updateNodes(List<ConfigurationItem> updateCis, Session session) throws RepositoryException {
        List<Node> nodes = this.retrieveNodes(updateCis, session);
        for (int i = 0; i < updateCis.size(); ++i) {
            this.updateNode(updateCis.get(i), nodes.get(i), session);
        }
    }

    private void updateNode(ConfigurationItem entity, Node node, Session session) throws RepositoryException {
        logger.debug("Updating node [{}]", (Object)entity.getId());
        new NodeWriter(session, entity, node, this.passwordEncrypter).write();
    }

    private SortedMap<String, VersionHistory> deleteEntities(List<String> entityIds, Session session, LicenseTransaction licenseTransaction) throws RepositoryException {
        List<Node> nodes = this.retrieveNodesToBeDeleted(entityIds, session);
        TreeMap versionHistories = Maps.newTreeMap();
        for (Node node : nodes) {
            this.retrieveVersionHistories(node, session, versionHistories);
        }
        for (Node node : nodes) {
            logger.debug("Deleting node [{}]", (Object)JcrPathHelper.getIdFromAbsolutePath(node.getPath()));
            this.removeParentListCiReferences(node, session);
            Type type = NodeUtils.typeOf(node);
            node.remove();
            this.licenseService.getCounter().registerTypeRemoval(type, licenseTransaction);
        }
        return versionHistories;
    }

    private void removeParentListCiReferences(Node node, Session session) throws RepositoryException {
        Node parent = node.getParent();
        Type t = NodeUtils.typeOf(parent);
        PropertyDescriptor containmentListProperty = NodeUtils.findContainmentListProperty(t, NodeUtils.typeOf(node));
        if (containmentListProperty == null) {
            return;
        }
        Property property = parent.getProperty(containmentListProperty.getName());
        Value[] values = property.getValues();
        ArrayList newValues = Lists.newArrayList();
        for (Value value : values) {
            Node referencedCiNode = NodeUtils.getReferencedCiNode(parent, value, session);
            if (node.getPath().equals(referencedCiNode.getPath())) continue;
            newValues.add(session.getValueFactory().createValue(referencedCiNode));
        }
        parent.setProperty(containmentListProperty.getName(), newValues.toArray(new Value[newValues.size()]));
    }

    private List<Node> retrieveNodesToBeDeleted(List<String> ids, Session session) throws RepositoryException {
        ArrayList nodes = Lists.newArrayList();
        for (String id : ids) {
            Preconditions.checkNotNull((Object)id, (Object)"id is null");
            logger.debug("Retrieving node {} to delete it.", (Object)id);
            try {
                Node node = session.getNode(JcrPathHelper.getAbsolutePathFromId(id));
                nodes.add(node);
            }
            catch (PathNotFoundException ignored) {}
        }
        return nodes;
    }

    private void retrieveVersionHistories(Node node, Session session, SortedMap<String, VersionHistory> versionHistories) throws RepositoryException {
        if (node.isNodeType("{http://www.jcp.org/jcr/mix/1.0}versionable")) {
            String id = JcrPathHelper.getIdFromAbsolutePath(node.getPath());
            logger.debug("Retrieving version history for node {} to delete it.", (Object)id);
            VersionHistory versionHistory = session.getWorkspace().getVersionManager().getVersionHistory(node.getPath());
            versionHistories.put(id, versionHistory);
            NodeIterator nodes = node.getNodes();
            while (nodes.hasNext()) {
                Node each = nodes.nextNode();
                this.retrieveVersionHistories(each, session, versionHistories);
            }
        }
    }

    private void renameEntities(List<Tuple<String, String>> renameCis, Session session) throws RepositoryException {
        if (!renameCis.isEmpty()) {
            logger.debug("Renaming nodes...");
        }
        for (Tuple<String, String> renameCi : renameCis) {
            String oldId = (String)renameCi.getA();
            String newId = oldId.substring(0, oldId.lastIndexOf(47) + 1) + (String)renameCi.getB();
            Type t = JcrRepositoryService.readType(session, oldId);
            if (t.equals((Object)Type.valueOf(Root.class))) {
                throw new DeployitException("Cannot rename a core.Root configuration item");
            }
            this.moveNode(JcrPathHelper.getAbsolutePathFromId(oldId), JcrPathHelper.getAbsolutePathFromId(newId), session);
        }
    }

    private void moveEntities(List<Tuple<String, String>> moveCis, Session session) throws RepositoryException {
        if (!moveCis.isEmpty()) {
            logger.debug("Moving nodes...");
        }
        for (Tuple<String, String> moveCi : moveCis) {
            String newId;
            String toBeMoved = (String)moveCi.getA();
            Checks.checkArgument((!toBeMoved.equals(newId = (String)moveCi.getB()) ? 1 : 0) != 0, (String)"Cannot move ci [%s] to same location", (Object[])new Object[]{newId});
            Type t = JcrRepositoryService.readType(session, toBeMoved);
            this.jcrRepositoryService.checkMoveAllowed(t);
            this.validateNodeStoredInCorrectPath(newId, t, session);
            this.moveNode(JcrPathHelper.getAbsolutePathFromId(toBeMoved), JcrPathHelper.getAbsolutePathFromId(newId), session);
        }
    }

    private void moveNode(String fromId, String toId, Session session) throws RepositoryException {
        logger.debug("Moving/renaming node [{}] to [{}]", (Object)fromId, (Object)toId);
        if (session.nodeExists(toId)) {
            throw new ItemAlreadyExistsException("The destination id [%s] exists.", new Object[]{toId});
        }
        session.move(fromId, toId);
    }

    private void copyEntities(List<Tuple<String, String>> copyCis, Session session, LicenseTransaction licenseTransaction) throws RepositoryException {
        if (!copyCis.isEmpty()) {
            logger.debug("Copying nodes...");
        }
        Seq<Type> types = new RepositoryUtils(this.jcrRepositoryService).readTree(copyCis);
        this.licenseService.getCounter().registerTypesCreation(types, licenseTransaction);
        for (Tuple<String, String> copyCi : copyCis) {
            String newId;
            String toBeCopied = (String)copyCi.getA();
            Checks.checkArgument((!toBeCopied.equals(newId = (String)copyCi.getB()) ? 1 : 0) != 0, (String)"Cannot copy ci [%s] to same location", (Object[])new Object[]{newId});
            Checks.checkArgument((!Type.valueOf(Root.class).equals((Object)JcrRepositoryService.readType(session, toBeCopied)) ? 1 : 0) != 0, (String)"Cannot copy root node [%s].", (Object[])new Object[]{toBeCopied});
            this.jcrRepositoryService.checkCopyAllowed(session, toBeCopied, newId);
            this.copyNode(JcrPathHelper.getAbsolutePathFromId(toBeCopied), JcrPathHelper.getAbsolutePathFromId(newId), session);
        }
    }

    private void copyNode(String fromId, String toId, Session session) throws RepositoryException {
        logger.debug("Copy node [{}] to [{}]", (Object)fromId, (Object)toId);
        if (session.nodeExists(toId)) {
            throw new ItemAlreadyExistsException("The destination id [%s] exists.", new Object[]{toId});
        }
        session.getWorkspace().copy(fromId, toId);
    }

    private void saveSession(Session session) throws RepositoryException {
        logger.debug("Committing JCR session");
        session.save();
    }

    private void removeVersionHistories(SortedMap<String, VersionHistory> versionHistories) throws RepositoryException {
        logger.debug("Removing version histories that have become obsolete because their corresponding nodes or one of their ancestors was deleted.");
        for (Map.Entry<String, VersionHistory> entry : versionHistories.entrySet()) {
            this.removeVersionHistory(entry.getKey(), entry.getValue());
        }
    }

    private void removeVersionHistory(String id, VersionHistory versionHistory) throws RepositoryException {
        logger.debug("Removing version history for node {}.", (Object)id);
        VersionIterator allVersions = versionHistory.getAllVersions();
        Version rootVersion = versionHistory.getRootVersion();
        while (allVersions.hasNext()) {
            Version version = allVersions.nextVersion();
            if (version.getName().equals(rootVersion.getName())) continue;
            logger.debug("Removing version {} from version history for node {}.", (Object)version.getName(), (Object)id);
            versionHistory.removeVersion(version.getName());
        }
    }

    private void verifyEntitiesMeetCreationPreconditions(List<ConfigurationItem> cis) {
        for (int i = 0; i < cis.size(); ++i) {
            ConfigurationItem ci = cis.get(i);
            Preconditions.checkNotNull((Object)ci, (String)"ci at index %s is null.", (Object[])new Object[]{i});
            Preconditions.checkNotNull((Object)ci.getId(), (String)"ci at index %s has null id.", (Object[])new Object[]{i});
            if (!(ci instanceof SourceArtifact)) continue;
            SourceArtifact sourceArtifact = (SourceArtifact)ci;
            boolean hasFile = sourceArtifact.getFile() != null;
            boolean hasCorrectFileUri = sourceArtifact.getFileUri() != null && ArtifactResolverRegistry.validate((SourceArtifact)sourceArtifact);
            Checks.checkArgument((hasFile || hasCorrectFileUri ? 1 : 0) != 0, (String)"Artifact %s should have either file or correct fileUri set", (Object[])new Object[]{ci.getId()});
        }
    }

    private void validateNodeStoredInCorrectPath(String id, Type type, Session session) throws RepositoryException {
        Checks.checkArgument((boolean)DescriptorRegistry.exists((Type)type), (String)"Unknown configuration item type %s", (Object[])new Object[]{type});
        Descriptor desc = DescriptorRegistry.getDescriptor((Type)type);
        String[] pathElements = id.split("/");
        if (desc.isAssignableTo(Directory.class)) {
            Checks.checkArgument((pathElements.length >= 2 ? 1 : 0) != 0, (String)"A core.Directory must be stored under a Root node, not under %s.", (Object[])new Object[]{id});
            for (Metadata.ConfigurationItemRoot configurationItemRoot : Metadata.ConfigurationItemRoot.values()) {
                if (!configurationItemRoot.getRootNodeName().equals(pathElements[0])) continue;
                return;
            }
            throw new Checks.IncorrectArgumentException("A core.Directory must be stured under a valid Root node, not under %s.", new Object[]{id});
        }
        if (desc.getRoot() == Metadata.ConfigurationItemRoot.NESTED) {
            Checks.checkArgument((pathElements.length >= 3 ? 1 : 0) != 0, (String)"Configuration item of type %s cannot be stored at %s. It should be stored under a valid parent node", (Object[])new Object[]{type, id});
            String parentId = id.substring(0, id.lastIndexOf(47));
            Node parentNode = session.getNode(JcrPathHelper.getAbsolutePathFromId(parentId));
            Checks.checkArgument((parentNode != null ? 1 : 0) != 0, (String)"Configuration item of type %s cannot be stored at %s. The parent does not exist", (Object[])new Object[]{type, id});
            Checks.checkArgument((boolean)parentNode.isNodeType("deployit:configurationItem"), (String)"Configuration item of type %s cannot be stored at %s. The parent is not a configuration item", (Object[])new Object[]{type, id});
            String parentTypeName = parentNode.getProperty("$configuration.item.type").getString();
            Descriptor parentDescriptor = DescriptorRegistry.getDescriptor((String)parentTypeName);
            for (PropertyDescriptor aPD : desc.getPropertyDescriptors()) {
                if (aPD.getKind() != PropertyKind.CI || !aPD.isAsContainment() || !parentDescriptor.isAssignableTo(aPD.getReferencedType())) continue;
                return;
            }
            for (PropertyDescriptor aPD : parentDescriptor.getPropertyDescriptors()) {
                if (!EnumSet.of(PropertyKind.SET_OF_CI, PropertyKind.LIST_OF_CI).contains(aPD.getKind()) || !aPD.isAsContainment() || !desc.isAssignableTo(aPD.getReferencedType())) continue;
                return;
            }
            throw new Checks.IncorrectArgumentException("Configuration item of type %s cannot be stored at %s. The parent cannot contain configuration items of this type", new Object[]{type, id});
        }
        Checks.checkArgument((boolean)pathElements[0].equals(desc.getRoot().getRootNodeName()), (String)"Configuration item of type %s cannot be stored at %s. It should be stored under %s", (Object[])new Object[]{type, id, desc.getRoot().getRootNodeName()});
    }

    private void setMixins(ConfigurationItem entity, Node node) throws RepositoryException {
        if (entity instanceof Artifact) {
            node.addMixin("deployit:artifact");
            node.addMixin("deployit:configurationItem");
        } else {
            node.addMixin("deployit:configurationItem");
        }
        node.addMixin("{http://www.jcp.org/jcr/mix/1.0}referenceable");
        if (entity.getType().getDescriptor().isVersioned()) {
            node.addMixin("{http://www.jcp.org/jcr/mix/1.0}versionable");
        }
    }

    private static class SortHierarchyComparator
    implements Comparator<ConfigurationItem> {
        private SortHierarchyComparator() {
        }

        @Override
        public int compare(ConfigurationItem o1, ConfigurationItem o2) {
            int nrSlashes1 = this.countMatches(o1.getId(), '/');
            int nrSlashes2 = this.countMatches(o2.getId(), '/');
            return nrSlashes1 - nrSlashes2;
        }

        private int countMatches(String s, char c) {
            int matches = 0;
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) != c) continue;
                ++matches;
            }
            return matches;
        }
    }
}

