/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.repository;

import com.xebialabs.deployit.jcr.JcrConstants;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.internal.Root;
import com.xebialabs.xlplatform.repository.JcrRepositoryMetadataService;
import com.xebialabs.xlplatform.repository.XlRepositoryConfig;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.util.Calendar;
import javax.jcr.Credentials;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001y4A!\u0001\u0002\u0001\u0017\t9\u0002\f\u001c*fa>\u001c\u0018\u000e^8ss&s\u0017\u000e^5bY&TXM\u001d\u0006\u0003\u0007\u0011\t!B]3q_NLGo\u001c:z\u0015\t)a!\u0001\u0006yYBd\u0017\r\u001e4pe6T!a\u0002\u0005\u0002\u0013a,'-[1mC\n\u001c(\"A\u0005\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001a!\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'ai\u0011\u0001\u0006\u0006\u0003+Y\tQa\u001d7gi)T\u0011aF\u0001\tOJL'P\u001f7fI&\u0011\u0011\u0004\u0006\u0002\b\u0019><w-\u001b8h\u0011!\u0019\u0001A!A!\u0002\u0013Y\u0002C\u0001\u000f\"\u001b\u0005i\"B\u0001\u0010 \u0003\rQ7M\u001d\u0006\u0002A\u0005)!.\u0019<bq&\u0011!%\b\u0002\u000b%\u0016\u0004xn]5u_JL\b\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002\r\r|gNZ5h!\t1s%D\u0001\u0003\u0013\tA#A\u0001\nYYJ+\u0007o\\:ji>\u0014\u0018pQ8oM&<\u0007\"\u0002\u0016\u0001\t\u0003Y\u0013A\u0002\u001fj]&$h\bF\u0002-[9\u0002\"A\n\u0001\t\u000b\rI\u0003\u0019A\u000e\t\u000b\u0011J\u0003\u0019A\u0013\t\u000bA\u0002A\u0011A\u0019\u0002\t%t\u0017\u000e\u001e\u000b\u0002eA\u0011QbM\u0005\u0003i9\u0011A!\u00168ji\"1a\u0007\u0001Q\u0005\n]\n1#\u001b8ji&\fG.\u001b>f\u001d>$W\rV=qKN$\"A\r\u001d\t\u000be*\u00049\u0001\u001e\u0002\u000fM,7o]5p]B\u0011AdO\u0005\u0003yu\u0011qaU3tg&|g\u000e\u0003\u0004?\u0001\u0001&IaP\u0001\rI>Le.\u001b;jC2L'0\u001a\u000b\u0003e\u0001CQ!O\u001fA\u0004iBaA\u0011\u0001!\n\u0013\u0019\u0015!D5t\u0013:LG/[1mSj,G\r\u0006\u0002E\u000fB\u0011Q\"R\u0005\u0003\r:\u0011qAQ8pY\u0016\fg\u000eC\u0003:\u0003\u0002\u0007!\b\u0003\u0004J\u0001\u0001&IAS\u0001\u0010GJ,\u0017\r^3NSbLg\u000eV=qKR\u00111*\u0014\u000b\u0003e1CQ!\u000f%A\u0004iBQA\u0014%A\u0002=\u000b\u0001\u0002^=qK:\u000bW.\u001a\t\u0003!Ns!!D)\n\u0005Is\u0011A\u0002)sK\u0012,g-\u0003\u0002U+\n11\u000b\u001e:j]\u001eT!A\u0015\b\t\r]\u0003\u0001\u0015\"\u0003Y\u00031\u0019'/Z1uKbc'k\\8u)\tI6\f\u0006\u000235\")\u0011H\u0016a\u0002u!)AL\u0016a\u0001\u001f\u0006A!o\\8u\u001d\u0006lW\r\u0003\u0004_\u0001\u0001&IaX\u0001\u000bKbL7\u000f^:O_\u0012,GC\u00011c)\t!\u0015\rC\u0003:;\u0002\u000f!\bC\u0003d;\u0002\u0007q*\u0001\u0005o_\u0012,g*Y7f\u0011\u0019)\u0007\u0001)C\u0005M\u0006)2M]3bi\u0016tu\u000eZ3JM:{G/\u0012=jgR\u001cHCA4m)\tA7\u000e\u0005\u0002\u000eS&\u0011!N\u0004\u0002\u0004\u0003:L\b\"B\u001de\u0001\bQ\u0004\"B2e\u0001\u0004y\u0005B\u00028\u0001A\u0013%q.\u0001\u0006de\u0016\fG/\u001a(pI\u0016$\"\u0001];\u0015\u0005E$\bC\u0001\u000fs\u0013\t\u0019XD\u0001\u0003O_\u0012,\u0007\"B\u001dn\u0001\bQ\u0004\"B2n\u0001\u0004y\u0005BB<\u0001A\u0013%\u00010\u0001\tti>\u0014XMU3q_Z+'o]5p]R\u0011!'\u001f\u0005\u0006sY\u0004\u001dA\u000f\u0005\u0007w\u0002\u0001K\u0011\u0002?\u0002#M$xN]3SKB|7/\u001b;pefLE\r\u0006\u00023{\")\u0011H\u001fa\u0002u\u0001")
public class XlRepositoryInitializer
implements Logging {
    private final Repository repository;
    private final XlRepositoryConfig config;
    private final Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        XlRepositoryInitializer xlRepositoryInitializer = this;
        synchronized (xlRepositoryInitializer) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.class.grizzled$slf4j$Logging$$_logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.grizzled$slf4j$Logging$$_logger;
        }
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger : this.grizzled$slf4j$Logging$$_logger$lzycompute();
    }

    public Logger logger() {
        return Logging.class.logger((Logging)this);
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.class.isErrorEnabled((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.class.isWarnEnabled((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    /*
     * WARNING - void declaration
     */
    public void init() {
        Credentials creds = (Credentials)this.config.credentials().orNull(Predef$.MODULE$.$conforms());
        Session session = this.repository.login(creds);
        try {
            if (this.isInitialized(session)) {
                this.logger().info((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Nodetypes already initialized!";
                    }
                });
            } else {
                this.initializeNodeTypes(session);
            }
            this.doInitialize(session);
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.logout();
            throw throwable;
        }
        session.logout();
    }

    private void initializeNodeTypes(Session session) {
        session.getWorkspace().getNamespaceRegistry().registerNamespace(JcrConstants.DEPLOYIT_NAMESPACE_PREFIX, JcrConstants.DEPLOYIT_NAMESPACE_URI);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{JcrConstants.CONFIGURATION_ITEM_NODETYPE_NAME, JcrConstants.ARTIFACT_NODETYPE_NAME, JcrConstants.TASK_NODETYPE_NAME, JcrConstants.STEP_NODETYPE_NAME, JcrConstants.CONFIGURATION_NODETYPE_NAME}))).foreach((Function1)new Serializable(this, session){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ XlRepositoryInitializer $outer;
            private final Session session$2;

            public final void apply(String typeName) {
                this.$outer.com$xebialabs$xlplatform$repository$XlRepositoryInitializer$$createMixinType(typeName, this.session$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.session$2 = session$2;
            }
        });
    }

    private void doInitialize(Session session) {
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Metadata.ConfigurationItemRoot.values()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Metadata.ConfigurationItemRoot x$1) {
                Metadata.ConfigurationItemRoot configurationItemRoot = x$1;
                Metadata.ConfigurationItemRoot configurationItemRoot2 = Metadata.ConfigurationItemRoot.NESTED;
                return configurationItemRoot != null ? !configurationItemRoot.equals(configurationItemRoot2) : configurationItemRoot2 != null;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Metadata.ConfigurationItemRoot x$2) {
                return x$2.getRootNodeName();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(this, session){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ XlRepositoryInitializer $outer;
            private final Session session$3;

            public final void apply(String rootName) {
                this.$outer.com$xebialabs$xlplatform$repository$XlRepositoryInitializer$$createXlRoot(rootName, this.session$3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.session$3 = session$3;
            }
        });
        if (!this.existsNode(JcrConstants.CONFIGURATION_NODE_NAME, session)) {
            this.createNode(JcrConstants.CONFIGURATION_NODE_NAME, session).addMixin(JcrConstants.CONFIGURATION_NODETYPE_NAME);
        }
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{JcrConstants.TASKS_NODE_NAME, JcrConstants.SECURITY_NODE_NAME, JcrConstants.ROLES_NODE_NAME, JcrConstants.ROLE_ASSIGNMENTS_NODE_NAME}))).foreach((Function1)new Serializable(this, session){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ XlRepositoryInitializer $outer;
            private final Session session$3;

            public final Object apply(String nodeName) {
                return this.$outer.com$xebialabs$xlplatform$repository$XlRepositoryInitializer$$createNodeIfNotExists(nodeName, this.session$3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.session$3 = session$3;
            }
        });
        this.storeRepoVersion(session);
        this.storeRepositoryId(session);
        session.save();
    }

    private boolean isInitialized(Session session) {
        return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable(this, session){
            public static final long serialVersionUID = 0L;
            private final Session session$1;

            public final String apply() {
                return this.session$1.getNamespaceURI(JcrConstants.DEPLOYIT_NAMESPACE_PREFIX);
            }
            {
                this.session$1 = session$1;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$3) {
                return true;
            }
        }).recover((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1 instanceof NamespaceException ? BoxesRunTime.boxToBoolean((boolean)false) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof NamespaceException;
                return bl;
            }
        }).get());
    }

    public void com$xebialabs$xlplatform$repository$XlRepositoryInitializer$$createMixinType(String typeName, Session session) {
        NodeTypeManager manager = session.getWorkspace().getNodeTypeManager();
        NodeTypeTemplate nodeTypeTemplate = manager.createNodeTypeTemplate();
        nodeTypeTemplate.setName(typeName);
        nodeTypeTemplate.setQueryable(true);
        nodeTypeTemplate.setAbstract(false);
        nodeTypeTemplate.setMixin(true);
        NodeType nodeType = manager.registerNodeType((NodeTypeDefinition)nodeTypeTemplate, false);
        this.logger().debug((Function0)new Serializable(this, nodeType){
            public static final long serialVersionUID = 0L;
            private final NodeType nodeType$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registered NodeType definition: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.nodeType$1}));
            }
            {
                this.nodeType$1 = nodeType$1;
            }
        });
    }

    public void com$xebialabs$xlplatform$repository$XlRepositoryInitializer$$createXlRoot(String rootName, Session session) {
        if (!this.existsNode(rootName, session)) {
            Node node = this.createNode(rootName, session);
            node.addMixin(JcrConstants.CONFIGURATION_ITEM_NODETYPE_NAME);
            node.addMixin("{http://www.jcp.org/jcr/mix/1.0}versionable");
            node.setProperty(JcrConstants.CONFIGURATION_ITEM_TYPE_PROPERTY_NAME, new StringBuilder().append((Object)"internal.").append((Object)Root.class.getSimpleName()).toString());
            node.setProperty(JcrConstants.LAST_MODIFIED_AT_PROPERTY_NAME, Calendar.getInstance());
            this.logger().debug((Function0)new Serializable(this, rootName, node){
                public static final long serialVersionUID = 0L;
                private final String rootName$1;
                private final Node node$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Configured XL Rootnode ", " at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rootName$1, this.node$1}));
                }
                {
                    this.rootName$1 = rootName$1;
                    this.node$1 = node$1;
                }
            });
        }
    }

    private boolean existsNode(String nodeName, Session session) {
        return session.getRootNode().hasNode(nodeName);
    }

    public Object com$xebialabs$xlplatform$repository$XlRepositoryInitializer$$createNodeIfNotExists(String nodeName, Session session) {
        return this.existsNode(nodeName, session) ? BoxedUnit.UNIT : this.createNode(nodeName, session);
    }

    /*
     * WARNING - void declaration
     */
    private Node createNode(String nodeName, Session session) {
        void var3_3;
        Node node = session.getRootNode().addNode(nodeName);
        this.logger().debug((Function0)new Serializable(this, node){
            public static final long serialVersionUID = 0L;
            private final Node node$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Created node ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.node$2}));
            }
            {
                this.node$2 = node$2;
            }
        });
        return var3_3;
    }

    private void storeRepoVersion(Session session) {
        if (!this.existsNode(JcrConstants.VERSIONS_NODE_NAME, session)) {
            Node node = session.getRootNode().addNode(JcrConstants.VERSIONS_NODE_NAME);
            this.logger().debug((Function0)new Serializable(this, node){
                public static final long serialVersionUID = 0L;
                private final Node node$3;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initialized repository version node at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.node$3}));
                }
                {
                    this.node$3 = node$3;
                }
            });
        }
    }

    private void storeRepositoryId(Session session) {
        JcrTemplate template = new JcrTemplate(this.repository, (Credentials)this.config.credentials().orNull(Predef$.MODULE$.$conforms()));
        JcrRepositoryMetadataService metadataService = new JcrRepositoryMetadataService(template);
        this.config.repositoryId().foreach((Function1)new Serializable(this, metadataService){
            public static final long serialVersionUID = 0L;
            private final JcrRepositoryMetadataService metadataService$1;

            public final void apply(String id) {
                this.metadataService$1.validateAndStoreRepositoryId(id);
            }
            {
                this.metadataService$1 = metadataService$1;
            }
        });
    }

    public XlRepositoryInitializer(Repository repository, XlRepositoryConfig config) {
        this.repository = repository;
        this.config = config;
        Logging.class.$init$((Logging)this);
    }
}

