/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.repositories.get;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeReadOperationRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class GetRepositoriesRequest
extends MasterNodeReadOperationRequest<GetRepositoriesRequest> {
    private String[] repositories = Strings.EMPTY_ARRAY;

    GetRepositoriesRequest() {
    }

    public GetRepositoriesRequest(String[] repositories) {
        this.repositories = repositories;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.repositories == null) {
            validationException = ValidateActions.addValidationError("repositories is null", validationException);
        }
        return validationException;
    }

    public String[] repositories() {
        return this.repositories;
    }

    public GetRepositoriesRequest repositories(String[] repositories) {
        this.repositories = repositories;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.repositories = in.readStringArray();
        this.readLocal(in, Version.V_1_0_0_RC2);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.repositories);
        this.writeLocal(out, Version.V_1_0_0_RC2);
    }
}

