/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.termvector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.termvector.TermVectorRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;

public class MultiTermVectorsRequest
extends ActionRequest<MultiTermVectorsRequest>
implements Iterable<TermVectorRequest>,
CompositeIndicesRequest {
    String preference;
    List<TermVectorRequest> requests = new ArrayList<TermVectorRequest>();
    final Set<String> ids = new HashSet<String>();

    public MultiTermVectorsRequest add(TermVectorRequest termVectorRequest) {
        this.requests.add(termVectorRequest);
        return this;
    }

    public MultiTermVectorsRequest add(String index, @Nullable String type, String id) {
        this.requests.add(new TermVectorRequest(index, type, id));
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.requests.isEmpty()) {
            validationException = ValidateActions.addValidationError("multi term vectors: no documents requested", validationException);
        } else {
            for (int i = 0; i < this.requests.size(); ++i) {
                TermVectorRequest termVectorRequest = this.requests.get(i);
                ActionRequestValidationException validationExceptionForDoc = termVectorRequest.validate();
                if (validationExceptionForDoc == null) continue;
                validationException = ValidateActions.addValidationError("at multi term vectors for doc " + i, validationExceptionForDoc);
            }
        }
        return validationException;
    }

    @Override
    public List<? extends IndicesRequest> subRequests() {
        return this.requests;
    }

    @Override
    public Iterator<TermVectorRequest> iterator() {
        return Iterators.unmodifiableIterator(this.requests.iterator());
    }

    public boolean isEmpty() {
        return this.requests.isEmpty() && this.ids.isEmpty();
    }

    public List<TermVectorRequest> getRequests() {
        return this.requests;
    }

    /*
     * Unable to fully structure code
     */
    public void add(TermVectorRequest template, BytesReference data) throws Exception {
        block21: {
            currentFieldName = null;
            if (data.length() <= 0) break block21;
            parser = XContentFactory.xContent(data).createParser(data);
            var5_5 = null;
lbl5:
            // 3 sources

            try {
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    block22: {
                        block24: {
                            block23: {
                                if (token == XContentParser.Token.FIELD_NAME) {
                                    currentFieldName = parser.currentName();
                                    continue;
                                }
                                if (token != XContentParser.Token.START_ARRAY) break block22;
                                if (!"docs".equals(currentFieldName)) break block23;
                                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                    if (token != XContentParser.Token.START_OBJECT) {
                                        throw new ElasticsearchIllegalArgumentException("docs array element should include an object");
                                    }
                                    termVectorRequest = new TermVectorRequest(template);
                                    TermVectorRequest.parseRequest(termVectorRequest, parser);
                                    this.add(termVectorRequest);
                                }
                                ** GOTO lbl5
                            }
                            if (!"ids".equals(currentFieldName)) break block24;
                            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                if (!token.isValue()) {
                                    throw new ElasticsearchIllegalArgumentException("ids array element should only contain ids");
                                }
                                this.ids.add(parser.text());
                            }
                            ** GOTO lbl5
                        }
                        throw new ElasticsearchParseException("No parameter named " + currentFieldName + "and type ARRAY");
                    }
                    if (token == XContentParser.Token.START_OBJECT && currentFieldName != null) {
                        if ("parameters".equals(currentFieldName)) {
                            TermVectorRequest.parseRequest(template, parser);
                            continue;
                        }
                        throw new ElasticsearchParseException("No parameter named " + currentFieldName + "and type OBJECT");
                    }
                    if (currentFieldName == null) continue;
                    throw new ElasticsearchParseException("_mtermvectors: Parameter " + currentFieldName + "not supported");
                }
            }
            catch (Throwable x2) {
                var5_5 = x2;
                throw x2;
            }
            finally {
                if (parser != null) {
                    if (var5_5 != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable x2) {
                            var5_5.addSuppressed(x2);
                        }
                    } else {
                        parser.close();
                    }
                }
            }
        }
        for (String id : this.ids) {
            curRequest = new TermVectorRequest(template);
            curRequest.id(id);
            this.requests.add(curRequest);
        }
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.preference = in.readOptionalString();
        int size = in.readVInt();
        this.requests = new ArrayList<TermVectorRequest>(size);
        for (int i = 0; i < size; ++i) {
            this.requests.add(TermVectorRequest.readTermVectorRequest(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.preference);
        out.writeVInt(this.requests.size());
        for (TermVectorRequest termVectorRequest : this.requests) {
            termVectorRequest.writeTo(out);
        }
    }

    public void ids(String[] ids) {
        for (String id : ids) {
            this.ids.add(id.replaceAll("\\s", ""));
        }
    }
}

