/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.io.Serializable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;

public class SnapshotId
implements Serializable,
Streamable {
    private String repository;
    private String snapshot;
    private int hashCode;

    private SnapshotId() {
    }

    public SnapshotId(String repository, String snapshot) {
        this.repository = repository;
        this.snapshot = snapshot;
        this.hashCode = this.computeHashCode();
    }

    public String getRepository() {
        return this.repository;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public String toString() {
        return this.repository + ":" + this.snapshot;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        SnapshotId snapshotId = (SnapshotId)o;
        return this.snapshot.equals(snapshotId.snapshot) && this.repository.equals(snapshotId.repository);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int result = this.repository != null ? this.repository.hashCode() : 0;
        result = 31 * result + this.snapshot.hashCode();
        return result;
    }

    public static SnapshotId readSnapshotId(StreamInput in) throws IOException {
        SnapshotId snapshot = new SnapshotId();
        snapshot.readFrom(in);
        return snapshot;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.repository = in.readString();
        this.snapshot = in.readString();
        this.hashCode = this.computeHashCode();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.repository);
        out.writeString(this.snapshot);
    }
}

