/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.TimeoutClusterStateListener;
import org.elasticsearch.cluster.TimeoutClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.ProcessClusterEventTimeoutException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeService;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.operation.OperationRouting;
import org.elasticsearch.cluster.service.PendingClusterTask;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.collect.Iterables;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.text.StringText;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.common.util.concurrent.PrioritizedEsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.PrioritizedRunnable;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoveryService;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class InternalClusterService
extends AbstractLifecycleComponent<ClusterService>
implements ClusterService {
    public static final String UPDATE_THREAD_NAME = "clusterService#updateTask";
    private final ThreadPool threadPool;
    private final DiscoveryService discoveryService;
    private final OperationRouting operationRouting;
    private final TransportService transportService;
    private final NodeSettingsService nodeSettingsService;
    private final DiscoveryNodeService discoveryNodeService;
    private final Version version;
    private final TimeValue reconnectInterval;
    private volatile PrioritizedEsThreadPoolExecutor updateTasksExecutor;
    private final Collection<ClusterStateListener> priorityClusterStateListeners = new CopyOnWriteArrayList<ClusterStateListener>();
    private final Collection<ClusterStateListener> clusterStateListeners = new CopyOnWriteArrayList<ClusterStateListener>();
    private final Collection<ClusterStateListener> lastClusterStateListeners = new CopyOnWriteArrayList<ClusterStateListener>();
    private final Collection<ClusterStateListener> postAppliedListeners = new CopyOnWriteArrayList<ClusterStateListener>();
    private final Iterable<ClusterStateListener> preAppliedListeners = Iterables.concat(this.priorityClusterStateListeners, this.clusterStateListeners, this.lastClusterStateListeners);
    private final LocalNodeMasterListeners localNodeMasterListeners;
    private final Queue<NotifyTimeout> onGoingTimeouts = ConcurrentCollections.newQueue();
    private volatile ClusterState clusterState;
    private final ClusterBlocks.Builder initialBlocks;
    private volatile ScheduledFuture reconnectToNodes;

    @Inject
    public InternalClusterService(Settings settings, DiscoveryService discoveryService, OperationRouting operationRouting, TransportService transportService, NodeSettingsService nodeSettingsService, ThreadPool threadPool, ClusterName clusterName, DiscoveryNodeService discoveryNodeService, Version version) {
        super(settings);
        this.operationRouting = operationRouting;
        this.transportService = transportService;
        this.discoveryService = discoveryService;
        this.threadPool = threadPool;
        this.nodeSettingsService = nodeSettingsService;
        this.discoveryNodeService = discoveryNodeService;
        this.version = version;
        this.clusterState = ClusterState.builder(clusterName).build();
        this.nodeSettingsService.setClusterService(this);
        this.reconnectInterval = this.componentSettings.getAsTime("reconnect_interval", TimeValue.timeValueSeconds(10L));
        this.localNodeMasterListeners = new LocalNodeMasterListeners(threadPool);
        this.initialBlocks = ClusterBlocks.builder().addGlobalBlock(discoveryService.getNoMasterBlock());
    }

    public NodeSettingsService settingsService() {
        return this.nodeSettingsService;
    }

    @Override
    public void addInitialStateBlock(ClusterBlock block) throws ElasticsearchIllegalStateException {
        if (this.lifecycle.started()) {
            throw new ElasticsearchIllegalStateException("can't set initial block when started");
        }
        this.initialBlocks.addGlobalBlock(block);
    }

    @Override
    public void removeInitialStateBlock(ClusterBlock block) throws ElasticsearchIllegalStateException {
        if (this.lifecycle.started()) {
            throw new ElasticsearchIllegalStateException("can't set initial block when started");
        }
        this.initialBlocks.removeGlobalBlock(block);
    }

    @Override
    protected void doStart() throws ElasticsearchException {
        this.add(this.localNodeMasterListeners);
        this.clusterState = ClusterState.builder(this.clusterState).blocks(this.initialBlocks).build();
        this.updateTasksExecutor = EsExecutors.newSinglePrioritizing(EsExecutors.daemonThreadFactory(this.settings, UPDATE_THREAD_NAME));
        this.reconnectToNodes = this.threadPool.schedule(this.reconnectInterval, "generic", new ReconnectToNodes());
        Map<String, String> nodeAttributes = this.discoveryNodeService.buildAttributes();
        String nodeId = DiscoveryService.generateNodeId(this.settings);
        DiscoveryNode localNode = new DiscoveryNode(this.settings.get("name"), nodeId, this.transportService.boundAddress().publishAddress(), nodeAttributes, this.version);
        DiscoveryNodes.Builder nodeBuilder = DiscoveryNodes.builder().put(localNode).localNodeId(localNode.id());
        this.clusterState = ClusterState.builder(this.clusterState).nodes(nodeBuilder).blocks(this.initialBlocks).build();
    }

    @Override
    protected void doStop() throws ElasticsearchException {
        FutureUtils.cancel(this.reconnectToNodes);
        for (NotifyTimeout onGoingTimeout : this.onGoingTimeouts) {
            onGoingTimeout.cancel();
            onGoingTimeout.listener.onClose();
        }
        ThreadPool.terminate(this.updateTasksExecutor, 10L, TimeUnit.SECONDS);
        this.remove(this.localNodeMasterListeners);
    }

    @Override
    protected void doClose() throws ElasticsearchException {
    }

    @Override
    public DiscoveryNode localNode() {
        return this.clusterState.getNodes().localNode();
    }

    @Override
    public OperationRouting operationRouting() {
        return this.operationRouting;
    }

    @Override
    public ClusterState state() {
        return this.clusterState;
    }

    @Override
    public void addFirst(ClusterStateListener listener) {
        this.priorityClusterStateListeners.add(listener);
    }

    @Override
    public void addLast(ClusterStateListener listener) {
        this.lastClusterStateListeners.add(listener);
    }

    @Override
    public void add(ClusterStateListener listener) {
        this.clusterStateListeners.add(listener);
    }

    @Override
    public void remove(ClusterStateListener listener) {
        this.clusterStateListeners.remove(listener);
        this.priorityClusterStateListeners.remove(listener);
        this.lastClusterStateListeners.remove(listener);
        this.postAppliedListeners.remove(listener);
        Iterator it = this.onGoingTimeouts.iterator();
        while (it.hasNext()) {
            NotifyTimeout timeout = (NotifyTimeout)it.next();
            if (!timeout.listener.equals(listener)) continue;
            timeout.cancel();
            it.remove();
        }
    }

    @Override
    public void add(LocalNodeMasterListener listener) {
        this.localNodeMasterListeners.add(listener);
    }

    @Override
    public void remove(LocalNodeMasterListener listener) {
        this.localNodeMasterListeners.remove(listener);
    }

    @Override
    public void add(final TimeValue timeout, final TimeoutClusterStateListener listener) {
        if (this.lifecycle.stoppedOrClosed()) {
            listener.onClose();
            return;
        }
        try {
            this.updateTasksExecutor.execute(new TimedPrioritizedRunnable(Priority.HIGH, "_add_listener_"){

                @Override
                public void run() {
                    NotifyTimeout notifyTimeout = new NotifyTimeout(listener, timeout);
                    notifyTimeout.future = InternalClusterService.this.threadPool.schedule(timeout, "generic", notifyTimeout);
                    InternalClusterService.this.onGoingTimeouts.add(notifyTimeout);
                    InternalClusterService.this.postAppliedListeners.add(listener);
                    listener.postAdded();
                }
            });
        }
        catch (EsRejectedExecutionException e) {
            if (this.lifecycle.stoppedOrClosed()) {
                listener.onClose();
            }
            throw e;
        }
    }

    @Override
    public void submitStateUpdateTask(String source, ClusterStateUpdateTask updateTask) {
        this.submitStateUpdateTask(source, Priority.NORMAL, updateTask);
    }

    @Override
    public void submitStateUpdateTask(String source, Priority priority, ClusterStateUpdateTask updateTask) {
        block5: {
            if (!this.lifecycle.started()) {
                return;
            }
            try {
                final UpdateTask task = new UpdateTask(source, priority, updateTask);
                if (updateTask instanceof TimeoutClusterStateUpdateTask) {
                    final TimeoutClusterStateUpdateTask timeoutUpdateTask = (TimeoutClusterStateUpdateTask)updateTask;
                    this.updateTasksExecutor.execute(task, this.threadPool.scheduler(), timeoutUpdateTask.timeout(), new Runnable(){

                        @Override
                        public void run() {
                            InternalClusterService.this.threadPool.generic().execute(new Runnable(){

                                @Override
                                public void run() {
                                    timeoutUpdateTask.onFailure(task.source(), new ProcessClusterEventTimeoutException(timeoutUpdateTask.timeout(), task.source()));
                                }
                            });
                        }
                    });
                } else {
                    this.updateTasksExecutor.execute(task);
                }
            }
            catch (EsRejectedExecutionException e) {
                if (this.lifecycle.stoppedOrClosed()) break block5;
                throw e;
            }
        }
    }

    @Override
    public List<PendingClusterTask> pendingTasks() {
        PrioritizedEsThreadPoolExecutor.Pending[] pendings = this.updateTasksExecutor.getPending();
        ArrayList<PendingClusterTask> pendingClusterTasks = new ArrayList<PendingClusterTask>(pendings.length);
        for (PrioritizedEsThreadPoolExecutor.Pending pending : pendings) {
            long timeInQueue;
            String source;
            Object task = pending.task;
            if (task == null) continue;
            if (task instanceof TimedPrioritizedRunnable) {
                TimedPrioritizedRunnable runnable = (TimedPrioritizedRunnable)task;
                source = runnable.source();
                timeInQueue = runnable.timeSinceCreatedInMillis();
            } else {
                assert (false) : "expected TimedPrioritizedRunnable got " + task.getClass();
                source = "unknown";
                timeInQueue = 0L;
            }
            pendingClusterTasks.add(new PendingClusterTask(pending.insertionOrder, pending.priority, new StringText(source), timeInQueue, pending.executing));
        }
        return pendingClusterTasks;
    }

    @Override
    public int numberOfPendingTasks() {
        return this.updateTasksExecutor.getNumberOfPendingTasks();
    }

    private boolean nodeRequiresConnection(DiscoveryNode node) {
        return this.localNode().shouldConnectTo(node);
    }

    private static class AckCountDownListener
    implements Discovery.AckListener {
        private static final ESLogger logger = Loggers.getLogger(AckCountDownListener.class);
        private final AckedClusterStateUpdateTask ackedUpdateTask;
        private final CountDown countDown;
        private final DiscoveryNodes nodes;
        private final long clusterStateVersion;
        private final Future<?> ackTimeoutCallback;
        private Throwable lastFailure;

        AckCountDownListener(AckedClusterStateUpdateTask ackedUpdateTask, long clusterStateVersion, DiscoveryNodes nodes, ThreadPool threadPool) {
            this.ackedUpdateTask = ackedUpdateTask;
            this.clusterStateVersion = clusterStateVersion;
            this.nodes = nodes;
            int countDown = 0;
            for (DiscoveryNode node : nodes) {
                if (!ackedUpdateTask.mustAck(node)) continue;
                ++countDown;
            }
            countDown = Math.max(1, countDown);
            logger.trace("expecting {} acknowledgements for cluster_state update (version: {})", countDown, clusterStateVersion);
            this.countDown = new CountDown(countDown);
            this.ackTimeoutCallback = threadPool.schedule(ackedUpdateTask.ackTimeout(), "generic", new Runnable(){

                @Override
                public void run() {
                    AckCountDownListener.this.onTimeout();
                }
            });
        }

        @Override
        public void onNodeAck(DiscoveryNode node, @Nullable Throwable t) {
            if (!this.ackedUpdateTask.mustAck(node) && !node.equals(this.nodes.masterNode())) {
                return;
            }
            if (t == null) {
                logger.trace("ack received from node [{}], cluster_state update (version: {})", node, this.clusterStateVersion);
            } else {
                this.lastFailure = t;
                logger.debug("ack received from node [{}], cluster_state update (version: {})", t, node, this.clusterStateVersion);
            }
            if (this.countDown.countDown()) {
                logger.trace("all expected nodes acknowledged cluster_state update (version: {})", this.clusterStateVersion);
                FutureUtils.cancel(this.ackTimeoutCallback);
                this.ackedUpdateTask.onAllNodesAcked(this.lastFailure);
            }
        }

        @Override
        public void onTimeout() {
            if (this.countDown.fastForward()) {
                logger.trace("timeout waiting for acknowledgement for cluster_state update (version: {})", this.clusterStateVersion);
                this.ackedUpdateTask.onAckTimeout();
            }
        }
    }

    private static class NoOpAckListener
    implements Discovery.AckListener {
        private NoOpAckListener() {
        }

        @Override
        public void onNodeAck(DiscoveryNode node, @Nullable Throwable t) {
        }

        @Override
        public void onTimeout() {
        }
    }

    private static class OffMasterRunnable
    implements Runnable {
        private final LocalNodeMasterListener listener;

        private OffMasterRunnable(LocalNodeMasterListener listener) {
            this.listener = listener;
        }

        @Override
        public void run() {
            this.listener.offMaster();
        }
    }

    private static class OnMasterRunnable
    implements Runnable {
        private final LocalNodeMasterListener listener;

        private OnMasterRunnable(LocalNodeMasterListener listener) {
            this.listener = listener;
        }

        @Override
        public void run() {
            this.listener.onMaster();
        }
    }

    private static class LocalNodeMasterListeners
    implements ClusterStateListener {
        private final List<LocalNodeMasterListener> listeners = new CopyOnWriteArrayList<LocalNodeMasterListener>();
        private final ThreadPool threadPool;
        private volatile boolean master = false;

        private LocalNodeMasterListeners(ThreadPool threadPool) {
            this.threadPool = threadPool;
        }

        @Override
        public void clusterChanged(ClusterChangedEvent event) {
            if (!this.master && event.localNodeMaster()) {
                this.master = true;
                for (LocalNodeMasterListener listener : this.listeners) {
                    Executor executor = this.threadPool.executor(listener.executorName());
                    executor.execute(new OnMasterRunnable(listener));
                }
                return;
            }
            if (this.master && !event.localNodeMaster()) {
                this.master = false;
                for (LocalNodeMasterListener listener : this.listeners) {
                    Executor executor = this.threadPool.executor(listener.executorName());
                    executor.execute(new OffMasterRunnable(listener));
                }
            }
        }

        private void add(LocalNodeMasterListener listener) {
            this.listeners.add(listener);
        }

        private void remove(LocalNodeMasterListener listener) {
            this.listeners.remove(listener);
        }

        private void clear() {
            this.listeners.clear();
        }
    }

    private class ReconnectToNodes
    implements Runnable {
        private ConcurrentMap<DiscoveryNode, Integer> failureCount = ConcurrentCollections.newConcurrentMap();

        private ReconnectToNodes() {
        }

        @Override
        public void run() {
            for (DiscoveryNode node : InternalClusterService.this.clusterState.nodes()) {
                if (InternalClusterService.this.lifecycle.stoppedOrClosed()) {
                    return;
                }
                if (!InternalClusterService.this.nodeRequiresConnection(node) || !InternalClusterService.this.clusterState.nodes().nodeExists(node.id()) || InternalClusterService.this.transportService.nodeConnected(node)) continue;
                try {
                    InternalClusterService.this.transportService.connectToNode(node);
                }
                catch (Exception e) {
                    if (InternalClusterService.this.lifecycle.stoppedOrClosed()) {
                        return;
                    }
                    if (!InternalClusterService.this.clusterState.nodes().nodeExists(node.id())) continue;
                    Integer nodeFailureCount = (Integer)this.failureCount.get(node);
                    nodeFailureCount = nodeFailureCount == null ? Integer.valueOf(1) : Integer.valueOf(nodeFailureCount + 1);
                    if (nodeFailureCount % 6 == 0) {
                        nodeFailureCount = 0;
                        InternalClusterService.this.logger.warn("failed to reconnect to node {}", e, node);
                    }
                    this.failureCount.put(node, nodeFailureCount);
                }
            }
            DiscoveryNodes nodes = InternalClusterService.this.clusterState.nodes();
            Iterator failedNodesIt = this.failureCount.keySet().iterator();
            while (failedNodesIt.hasNext()) {
                DiscoveryNode failedNode = (DiscoveryNode)failedNodesIt.next();
                if (nodes.nodeExists(failedNode.id())) continue;
                failedNodesIt.remove();
            }
            if (InternalClusterService.this.lifecycle.started()) {
                InternalClusterService.this.reconnectToNodes = InternalClusterService.this.threadPool.schedule(InternalClusterService.this.reconnectInterval, "generic", this);
            }
        }
    }

    class NotifyTimeout
    implements Runnable {
        final TimeoutClusterStateListener listener;
        final TimeValue timeout;
        ScheduledFuture future;

        NotifyTimeout(TimeoutClusterStateListener listener, TimeValue timeout) {
            this.listener = listener;
            this.timeout = timeout;
        }

        public void cancel() {
            FutureUtils.cancel(this.future);
        }

        @Override
        public void run() {
            if (this.future.isCancelled()) {
                return;
            }
            if (InternalClusterService.this.lifecycle.stoppedOrClosed()) {
                this.listener.onClose();
            } else {
                this.listener.onTimeout(this.timeout);
            }
        }
    }

    class UpdateTask
    extends TimedPrioritizedRunnable {
        public final ClusterStateUpdateTask updateTask;

        UpdateTask(String source, Priority priority, ClusterStateUpdateTask updateTask) {
            super(priority, source);
            this.updateTask = updateTask;
        }

        @Override
        public void run() {
            ClusterState newClusterState;
            if (!InternalClusterService.this.lifecycle.started()) {
                InternalClusterService.this.logger.debug("processing [{}]: ignoring, cluster_service not started", this.source);
                return;
            }
            InternalClusterService.this.logger.debug("processing [{}]: execute", this.source);
            ClusterState previousClusterState = InternalClusterService.this.clusterState;
            if (!previousClusterState.nodes().localNodeMaster() && this.updateTask.runOnlyOnMaster()) {
                InternalClusterService.this.logger.debug("failing [{}]: local node is no longer master", this.source);
                this.updateTask.onNoLongerMaster(this.source);
                return;
            }
            try {
                newClusterState = this.updateTask.execute(previousClusterState);
            }
            catch (Throwable e) {
                if (InternalClusterService.this.logger.isTraceEnabled()) {
                    StringBuilder sb = new StringBuilder("failed to execute cluster state update, state:\nversion [").append(previousClusterState.version()).append("], source [").append(this.source).append("]\n");
                    sb.append(previousClusterState.nodes().prettyPrint());
                    sb.append(previousClusterState.routingTable().prettyPrint());
                    sb.append(previousClusterState.readOnlyRoutingNodes().prettyPrint());
                    InternalClusterService.this.logger.trace(sb.toString(), e, new Object[0]);
                }
                this.updateTask.onFailure(this.source, e);
                return;
            }
            if (previousClusterState == newClusterState) {
                InternalClusterService.this.logger.debug("processing [{}]: no change in cluster_state", this.source);
                if (this.updateTask instanceof AckedClusterStateUpdateTask) {
                    ((AckedClusterStateUpdateTask)this.updateTask).onAllNodesAcked(null);
                }
                if (this.updateTask instanceof ProcessedClusterStateUpdateTask) {
                    ((ProcessedClusterStateUpdateTask)this.updateTask).clusterStateProcessed(this.source, previousClusterState, newClusterState);
                }
                return;
            }
            try {
                String summary;
                Discovery.AckListener ackListener = new NoOpAckListener();
                if (newClusterState.nodes().localNodeMaster()) {
                    ClusterState.Builder builder = ClusterState.builder(newClusterState).version(newClusterState.version() + 1L);
                    if (previousClusterState.routingTable() != newClusterState.routingTable()) {
                        builder.routingTable(RoutingTable.builder(newClusterState.routingTable()).version(newClusterState.routingTable().version() + 1L));
                    }
                    if (previousClusterState.metaData() != newClusterState.metaData()) {
                        builder.metaData(MetaData.builder(newClusterState.metaData()).version(newClusterState.metaData().version() + 1L));
                    }
                    newClusterState = builder.build();
                    if (this.updateTask instanceof AckedClusterStateUpdateTask) {
                        AckedClusterStateUpdateTask ackedUpdateTask = (AckedClusterStateUpdateTask)this.updateTask;
                        if (ackedUpdateTask.ackTimeout() == null || ackedUpdateTask.ackTimeout().millis() == 0L) {
                            ackedUpdateTask.onAckTimeout();
                        } else {
                            try {
                                ackListener = new AckCountDownListener(ackedUpdateTask, newClusterState.version(), newClusterState.nodes(), InternalClusterService.this.threadPool);
                            }
                            catch (EsRejectedExecutionException ex) {
                                if (InternalClusterService.this.logger.isDebugEnabled()) {
                                    InternalClusterService.this.logger.debug("Couldn't schedule timeout thread - node might be shutting down", ex, new Object[0]);
                                }
                                ackedUpdateTask.onAckTimeout();
                            }
                        }
                    }
                }
                newClusterState.status(ClusterState.ClusterStateStatus.BEING_APPLIED);
                if (InternalClusterService.this.logger.isTraceEnabled()) {
                    StringBuilder sb = new StringBuilder("cluster state updated, source [").append(this.source).append("]\n");
                    sb.append(newClusterState.prettyPrint());
                    InternalClusterService.this.logger.trace(sb.toString(), new Object[0]);
                } else if (InternalClusterService.this.logger.isDebugEnabled()) {
                    InternalClusterService.this.logger.debug("cluster state updated, version [{}], source [{}]", newClusterState.version(), this.source);
                }
                ClusterChangedEvent clusterChangedEvent = new ClusterChangedEvent(this.source, newClusterState, previousClusterState);
                DiscoveryNodes.Delta nodesDelta = clusterChangedEvent.nodesDelta();
                if (nodesDelta.hasChanges() && InternalClusterService.this.logger.isInfoEnabled() && (summary = nodesDelta.shortSummary()).length() > 0) {
                    InternalClusterService.this.logger.info("{}, reason: {}", summary, this.source);
                }
                for (DiscoveryNode node : nodesDelta.addedNodes()) {
                    if (!InternalClusterService.this.nodeRequiresConnection(node)) continue;
                    try {
                        InternalClusterService.this.transportService.connectToNode(node);
                    }
                    catch (Throwable e) {
                        InternalClusterService.this.logger.warn("failed to connect to node [" + node + "]", e, new Object[0]);
                    }
                }
                if (newClusterState.nodes().localNodeMaster()) {
                    InternalClusterService.this.logger.debug("publishing cluster state version {}", newClusterState.version());
                    InternalClusterService.this.discoveryService.publish(newClusterState, ackListener);
                }
                InternalClusterService.this.clusterState = newClusterState;
                InternalClusterService.this.logger.debug("set local cluster state to version {}", newClusterState.version());
                for (ClusterStateListener listener : InternalClusterService.this.preAppliedListeners) {
                    try {
                        listener.clusterChanged(clusterChangedEvent);
                    }
                    catch (Exception ex) {
                        InternalClusterService.this.logger.warn("failed to notify ClusterStateListener", ex, new Object[0]);
                    }
                }
                for (DiscoveryNode node : nodesDelta.removedNodes()) {
                    try {
                        InternalClusterService.this.transportService.disconnectFromNode(node);
                    }
                    catch (Throwable e) {
                        InternalClusterService.this.logger.warn("failed to disconnect to node [" + node + "]", e, new Object[0]);
                    }
                }
                newClusterState.status(ClusterState.ClusterStateStatus.APPLIED);
                for (ClusterStateListener listener : InternalClusterService.this.postAppliedListeners) {
                    try {
                        listener.clusterChanged(clusterChangedEvent);
                    }
                    catch (Exception ex) {
                        InternalClusterService.this.logger.warn("failed to notify ClusterStateListener", ex, new Object[0]);
                    }
                }
                if (newClusterState.nodes().localNodeMaster()) {
                    try {
                        ackListener.onNodeAck(newClusterState.nodes().localNode(), null);
                    }
                    catch (Throwable t) {
                        InternalClusterService.this.logger.debug("error while processing ack for master node [{}]", t, newClusterState.nodes().localNode());
                    }
                }
                if (this.updateTask instanceof ProcessedClusterStateUpdateTask) {
                    ((ProcessedClusterStateUpdateTask)this.updateTask).clusterStateProcessed(this.source, previousClusterState, newClusterState);
                }
                InternalClusterService.this.logger.debug("processing [{}]: done applying updated cluster_state (version: {})", this.source, newClusterState.version());
            }
            catch (Throwable t) {
                StringBuilder sb = new StringBuilder("failed to apply updated cluster state:\nversion [").append(newClusterState.version()).append("], source [").append(this.source).append("]\n");
                sb.append(newClusterState.nodes().prettyPrint());
                sb.append(newClusterState.routingTable().prettyPrint());
                sb.append(newClusterState.readOnlyRoutingNodes().prettyPrint());
                InternalClusterService.this.logger.warn(sb.toString(), t, new Object[0]);
            }
        }
    }

    static abstract class TimedPrioritizedRunnable
    extends PrioritizedRunnable {
        private final long creationTime;
        protected final String source;

        protected TimedPrioritizedRunnable(Priority priority, String source) {
            super(priority);
            this.source = source;
            this.creationTime = System.currentTimeMillis();
        }

        public long timeSinceCreatedInMillis() {
            return Math.max(0L, System.currentTimeMillis() - this.creationTime);
        }

        public String source() {
            return this.source;
        }
    }
}

