/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.PagedBytesReference;
import org.elasticsearch.common.io.BytesStream;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ByteArray;

public class BytesStreamOutput
extends StreamOutput
implements BytesStream {
    protected final BigArrays bigarrays;
    protected ByteArray bytes;
    protected int count;

    public BytesStreamOutput() {
        this(16384);
    }

    public BytesStreamOutput(int expectedSize) {
        this(expectedSize, BigArrays.NON_RECYCLING_INSTANCE);
    }

    protected BytesStreamOutput(int expectedSize, BigArrays bigarrays) {
        this.bigarrays = bigarrays;
        this.bytes = bigarrays.newByteArray(expectedSize);
    }

    @Override
    public boolean seekPositionSupported() {
        return true;
    }

    @Override
    public long position() throws IOException {
        return this.count;
    }

    @Override
    public void writeByte(byte b) throws IOException {
        this.ensureCapacity(this.count + 1);
        this.bytes.set(this.count, b);
        ++this.count;
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        if (length == 0) {
            return;
        }
        if (b.length < offset + length) {
            throw new IllegalArgumentException("Illegal offset " + offset + "/length " + length + " for byte[] of length " + b.length);
        }
        this.ensureCapacity(this.count + length);
        this.bytes.set(this.count, b, offset, length);
        this.count += length;
    }

    @Override
    public void reset() {
        if (this.bytes.size() > 16384L) {
            this.bytes = this.bigarrays.resize(this.bytes, 16384L);
        }
        this.count = 0;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void seek(long position) throws IOException {
        if (position > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("position " + position + " > Integer.MAX_VALUE");
        }
        this.count = (int)position;
        this.ensureCapacity(this.count);
    }

    public void skip(int length) {
        this.count += length;
        this.ensureCapacity(this.count);
    }

    @Override
    public void close() throws IOException {
    }

    public int size() {
        return this.count;
    }

    @Override
    public BytesReference bytes() {
        return new PagedBytesReference(this.bigarrays, this.bytes, this.count);
    }

    public long ramBytesUsed() {
        return this.bytes.ramBytesUsed();
    }

    private void ensureCapacity(int offset) {
        this.bytes = this.bigarrays.grow(this.bytes, (long)offset);
    }
}

