/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.jna;

import com.sun.jna.Native;
import com.sun.jna.win32.StdCallLibrary;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;

public class Kernel32Library {
    private static ESLogger logger = Loggers.getLogger(Kernel32Library.class);
    private List<NativeHandlerCallback> callbacks = new ArrayList<NativeHandlerCallback>();

    private Kernel32Library() {
        try {
            Native.register((String)"kernel32");
            logger.debug("windows/Kernel32 library loaded", new Object[0]);
        }
        catch (NoClassDefFoundError e) {
            logger.warn("JNA not found. native methods and handlers will be disabled.", new Object[0]);
        }
        catch (UnsatisfiedLinkError e) {
            logger.warn("unable to link Windows/Kernel32 library. native methods and handlers will be disabled.", new Object[0]);
        }
    }

    public static Kernel32Library getInstance() {
        return Holder.instance;
    }

    public boolean addConsoleCtrlHandler(ConsoleCtrlHandler handler) {
        NativeHandlerCallback callback;
        boolean result = false;
        if (handler != null && (result = this.SetConsoleCtrlHandler(callback = new NativeHandlerCallback(handler), true))) {
            this.callbacks.add(callback);
        }
        return result;
    }

    public ImmutableList<Object> getCallbacks() {
        return ((ImmutableList.Builder)ImmutableList.builder().addAll(this.callbacks)).build();
    }

    public native boolean SetConsoleCtrlHandler(StdCallLibrary.StdCallCallback var1, boolean var2);

    public static interface ConsoleCtrlHandler {
        public static final int CTRL_CLOSE_EVENT = 2;

        public boolean handle(int var1);
    }

    class NativeHandlerCallback
    implements StdCallLibrary.StdCallCallback {
        private final ConsoleCtrlHandler handler;

        public NativeHandlerCallback(ConsoleCtrlHandler handler) {
            this.handler = handler;
        }

        public boolean callback(long dwCtrlType) {
            int event = (int)dwCtrlType;
            if (logger.isDebugEnabled()) {
                logger.debug("console control handler receives event [{}@{}]", event, dwCtrlType);
            }
            return this.handler.handle(event);
        }
    }

    private static final class Holder {
        private static final Kernel32Library instance = new Kernel32Library();

        private Holder() {
        }
    }
}

