/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.handler.codec.marshalling;

import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelHandlerContext;
import org.elasticsearch.common.netty.channel.ExceptionEvent;
import org.elasticsearch.common.netty.handler.codec.frame.TooLongFrameException;
import org.elasticsearch.common.netty.handler.codec.marshalling.ChannelBufferByteInput;
import org.elasticsearch.common.netty.handler.codec.marshalling.LimitingByteInput;
import org.elasticsearch.common.netty.handler.codec.marshalling.UnmarshallerProvider;
import org.elasticsearch.common.netty.handler.codec.replay.ReplayingDecoder;
import org.elasticsearch.common.netty.handler.codec.replay.VoidEnum;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompatibleMarshallingDecoder
extends ReplayingDecoder<VoidEnum> {
    protected final UnmarshallerProvider provider;
    protected final int maxObjectSize;
    private boolean discardingTooLongFrame;

    public CompatibleMarshallingDecoder(UnmarshallerProvider provider, int maxObjectSize) {
        this.provider = provider;
        this.maxObjectSize = maxObjectSize;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, VoidEnum state) throws Exception {
        Object object;
        if (this.discardingTooLongFrame) {
            buffer.skipBytes(this.actualReadableBytes());
            this.checkpoint();
            return null;
        }
        Unmarshaller unmarshaller = this.provider.getUnmarshaller(ctx);
        Object input = new ChannelBufferByteInput(buffer);
        if (this.maxObjectSize != Integer.MAX_VALUE) {
            input = new LimitingByteInput((ByteInput)input, this.maxObjectSize);
        }
        try {
            unmarshaller.start((ByteInput)input);
            Object obj = unmarshaller.readObject();
            unmarshaller.finish();
            object = obj;
            Object var10_10 = null;
        }
        catch (LimitingByteInput.TooBigObjectException e) {
            try {
                this.discardingTooLongFrame = true;
                throw new TooLongFrameException();
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                unmarshaller.close();
                throw throwable;
            }
        }
        unmarshaller.close();
        return object;
    }

    @Override
    protected Object decodeLast(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, VoidEnum state) throws Exception {
        switch (buffer.readableBytes()) {
            case 0: {
                return null;
            }
            case 1: {
                if (buffer.getByte(buffer.readerIndex()) != 121) break;
                buffer.skipBytes(1);
                return null;
            }
        }
        Object decoded = this.decode(ctx, channel, buffer, state);
        return decoded;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (e.getCause() instanceof TooLongFrameException) {
            e.getChannel().close();
        } else {
            super.exceptionCaught(ctx, e);
        }
    }
}

