/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.Bits;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.LongValuesComparatorSource;
import org.elasticsearch.index.fielddata.plain.AtomicLongFieldData;
import org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.MultiValueMode;

public class NumericDVIndexFieldData
extends DocValuesIndexFieldData
implements IndexNumericFieldData {
    public NumericDVIndexFieldData(Index index, FieldMapper.Names fieldNames, FieldDataType fieldDataType) {
        super(index, fieldNames, fieldDataType);
    }

    @Override
    public AtomicLongFieldData load(AtomicReaderContext context) {
        final AtomicReader reader = context.reader();
        final String field = this.fieldNames.indexName();
        return new AtomicLongFieldData(0L){

            @Override
            public SortedNumericDocValues getLongValues() {
                try {
                    NumericDocValues values = DocValues.getNumeric((AtomicReader)reader, (String)field);
                    Bits docsWithField = DocValues.getDocsWithField((AtomicReader)reader, (String)field);
                    return DocValues.singleton((NumericDocValues)values, (Bits)docsWithField);
                }
                catch (IOException e) {
                    throw new ElasticsearchIllegalStateException("Cannot load doc values", e);
                }
            }
        };
    }

    @Override
    public AtomicLongFieldData loadDirect(AtomicReaderContext context) throws Exception {
        return this.load(context);
    }

    @Override
    public IndexFieldData.XFieldComparatorSource comparatorSource(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        return new LongValuesComparatorSource(this, missingValue, sortMode, nested);
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return IndexNumericFieldData.NumericType.LONG;
    }
}

