/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.ThreadInterruptedException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.action.WriteFailureException;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.optimize.OptimizeRequest;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RestoreSource;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.XFilteredQuery;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.aliases.IndexAliasesService;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.cache.filter.FilterCacheStats;
import org.elasticsearch.index.cache.filter.ShardFilterCache;
import org.elasticsearch.index.cache.fixedbitset.FixedBitSetFilter;
import org.elasticsearch.index.cache.fixedbitset.ShardFixedBitSetFilterCache;
import org.elasticsearch.index.cache.id.IdCacheStats;
import org.elasticsearch.index.cache.query.ShardQueryCache;
import org.elasticsearch.index.codec.CodecService;
import org.elasticsearch.index.deletionpolicy.SnapshotDeletionPolicy;
import org.elasticsearch.index.deletionpolicy.SnapshotIndexCommit;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineClosedException;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.engine.IgnoreOnRecoveryEngineException;
import org.elasticsearch.index.engine.OptimizeFailedEngineException;
import org.elasticsearch.index.engine.RefreshFailedEngineException;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.fielddata.FieldDataStats;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.fielddata.ShardFieldData;
import org.elasticsearch.index.flush.FlushStats;
import org.elasticsearch.index.get.GetStats;
import org.elasticsearch.index.get.ShardGetService;
import org.elasticsearch.index.indexing.IndexingStats;
import org.elasticsearch.index.indexing.ShardIndexingService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.merge.policy.MergePolicyProvider;
import org.elasticsearch.index.merge.scheduler.MergeSchedulerProvider;
import org.elasticsearch.index.percolator.PercolatorQueriesRegistry;
import org.elasticsearch.index.percolator.stats.ShardPercolateService;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.recovery.RecoveryStats;
import org.elasticsearch.index.refresh.RefreshStats;
import org.elasticsearch.index.search.nested.NonNestedDocsFilter;
import org.elasticsearch.index.search.stats.SearchStats;
import org.elasticsearch.index.search.stats.ShardSearchService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexShardException;
import org.elasticsearch.index.shard.IndexShardNotRecoveringException;
import org.elasticsearch.index.shard.IndexShardNotStartedException;
import org.elasticsearch.index.shard.IndexShardRecoveringException;
import org.elasticsearch.index.shard.IndexShardRelocatedException;
import org.elasticsearch.index.shard.IndexShardStartedException;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.index.suggest.stats.ShardSuggestService;
import org.elasticsearch.index.suggest.stats.SuggestStats;
import org.elasticsearch.index.termvectors.ShardTermVectorService;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogStats;
import org.elasticsearch.index.warmer.ShardIndexWarmerService;
import org.elasticsearch.index.warmer.WarmerStats;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.indices.IndicesWarmer;
import org.elasticsearch.indices.InternalIndicesLifecycle;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.search.suggest.completion.Completion090PostingsFormat;
import org.elasticsearch.search.suggest.completion.CompletionStats;
import org.elasticsearch.threadpool.ThreadPool;

public class IndexShard
extends AbstractIndexShardComponent {
    private final ThreadPool threadPool;
    private final IndexSettingsService indexSettingsService;
    private final MapperService mapperService;
    private final IndexQueryParserService queryParserService;
    private final IndexCache indexCache;
    private final InternalIndicesLifecycle indicesLifecycle;
    private final Store store;
    private final MergeSchedulerProvider mergeScheduler;
    private final Translog translog;
    private final IndexAliasesService indexAliasesService;
    private final ShardIndexingService indexingService;
    private final ShardSearchService searchService;
    private final ShardGetService getService;
    private final ShardIndexWarmerService shardWarmerService;
    private final ShardFilterCache shardFilterCache;
    private final ShardQueryCache shardQueryCache;
    private final ShardFieldData shardFieldData;
    private final PercolatorQueriesRegistry percolatorQueriesRegistry;
    private final ShardPercolateService shardPercolateService;
    private final CodecService codecService;
    private final ShardTermVectorService termVectorService;
    private final IndexFieldDataService indexFieldDataService;
    private final IndexService indexService;
    private final ShardSuggestService shardSuggestService;
    private final ShardFixedBitSetFilterCache shardFixedBitSetFilterCache;
    private final DiscoveryNode localNode;
    private final Object mutex = new Object();
    private final String checkIndexOnStartup;
    private TimeValue refreshInterval;
    private final TimeValue mergeInterval;
    private volatile ScheduledFuture refreshScheduledFuture;
    private volatile ScheduledFuture mergeScheduleFuture;
    protected volatile ShardRouting shardRouting;
    protected volatile IndexShardState state;
    protected final AtomicReference<Engine> currentEngineReference = new AtomicReference();
    protected final EngineConfig config;
    protected final EngineFactory engineFactory;
    @Nullable
    private RecoveryState recoveryState;
    private final RecoveryStats recoveryStats = new RecoveryStats();
    private ApplyRefreshSettings applyRefreshSettings = new ApplyRefreshSettings();
    private final MeanMetric refreshMetric = new MeanMetric();
    private final MeanMetric flushMetric = new MeanMetric();
    private final ShardEngineFailListener failedEngineListener = new ShardEngineFailListener();
    private volatile boolean flushOnClose = true;
    public static final String INDEX_FLUSH_ON_CLOSE = "index.flush_on_close";
    public static final String INDEX_REFRESH_INTERVAL = "index.refresh_interval";

    @Inject
    public IndexShard(ShardId shardId, @IndexSettings Settings indexSettings, IndexSettingsService indexSettingsService, IndicesLifecycle indicesLifecycle, Store store, MergeSchedulerProvider mergeScheduler, Translog translog, ThreadPool threadPool, MapperService mapperService, IndexQueryParserService queryParserService, IndexCache indexCache, IndexAliasesService indexAliasesService, ShardIndexingService indexingService, ShardGetService getService, ShardSearchService searchService, ShardIndexWarmerService shardWarmerService, ShardFilterCache shardFilterCache, ShardFieldData shardFieldData, PercolatorQueriesRegistry percolatorQueriesRegistry, ShardPercolateService shardPercolateService, CodecService codecService, ShardTermVectorService termVectorService, IndexFieldDataService indexFieldDataService, IndexService indexService, ShardSuggestService shardSuggestService, ShardQueryCache shardQueryCache, ShardFixedBitSetFilterCache shardFixedBitSetFilterCache, @Nullable IndicesWarmer warmer, SnapshotDeletionPolicy deletionPolicy, AnalysisService analysisService, SimilarityService similarityService, MergePolicyProvider mergePolicyProvider, EngineFactory factory, ClusterService clusterService) {
        super(shardId, indexSettings);
        Preconditions.checkNotNull(store, "Store must be provided to the index shard");
        Preconditions.checkNotNull(deletionPolicy, "Snapshot deletion policy must be provided to the index shard");
        Preconditions.checkNotNull(translog, "Translog must be provided to the index shard");
        this.engineFactory = factory;
        this.indicesLifecycle = (InternalIndicesLifecycle)indicesLifecycle;
        this.indexSettingsService = indexSettingsService;
        this.store = store;
        this.mergeScheduler = mergeScheduler;
        this.translog = translog;
        this.threadPool = threadPool;
        this.mapperService = mapperService;
        this.queryParserService = queryParserService;
        this.indexCache = indexCache;
        this.indexAliasesService = indexAliasesService;
        this.indexingService = indexingService;
        this.getService = getService.setIndexShard(this);
        this.termVectorService = termVectorService.setIndexShard(this);
        this.searchService = searchService;
        this.shardWarmerService = shardWarmerService;
        this.shardFilterCache = shardFilterCache;
        this.shardQueryCache = shardQueryCache;
        this.shardFieldData = shardFieldData;
        this.percolatorQueriesRegistry = percolatorQueriesRegistry;
        this.shardPercolateService = shardPercolateService;
        this.indexFieldDataService = indexFieldDataService;
        this.indexService = indexService;
        this.codecService = codecService;
        this.shardSuggestService = shardSuggestService;
        this.shardFixedBitSetFilterCache = shardFixedBitSetFilterCache;
        assert (clusterService.localNode() != null) : "Local node is null lifecycle state is: " + (Object)((Object)clusterService.lifecycleState());
        this.localNode = clusterService.localNode();
        this.state = IndexShardState.CREATED;
        this.refreshInterval = indexSettings.getAsTime(INDEX_REFRESH_INTERVAL, EngineConfig.DEFAULT_REFRESH_INTERVAL);
        this.flushOnClose = indexSettings.getAsBoolean(INDEX_FLUSH_ON_CLOSE, (Boolean)true);
        indexSettingsService.addListener(this.applyRefreshSettings);
        this.refreshInterval = indexSettings.getAsTime(INDEX_REFRESH_INTERVAL, EngineConfig.DEFAULT_REFRESH_INTERVAL);
        this.mergeInterval = indexSettings.getAsTime("index.merge.async_interval", TimeValue.timeValueSeconds(1L));
        this.config = new EngineConfig(shardId, indexSettings.getAsBoolean("index.optimize_auto_generated_id", (Boolean)false), threadPool, indexingService, indexSettingsService, warmer, store, deletionPolicy, translog, mergePolicyProvider, mergeScheduler, (Analyzer)analysisService.defaultIndexAnalyzer(), similarityService.similarity(), codecService, this.failedEngineListener);
        this.logger.debug("state: [CREATED]", new Object[0]);
        this.checkIndexOnStartup = indexSettings.get("index.shard.check_on_startup", "false");
    }

    public MergeSchedulerProvider mergeScheduler() {
        return this.mergeScheduler;
    }

    public Store store() {
        return this.store;
    }

    public Translog translog() {
        return this.translog;
    }

    public ShardIndexingService indexingService() {
        return this.indexingService;
    }

    public ShardGetService getService() {
        return this.getService;
    }

    public ShardTermVectorService termVectorService() {
        return this.termVectorService;
    }

    public ShardSuggestService shardSuggestService() {
        return this.shardSuggestService;
    }

    public ShardFixedBitSetFilterCache shardFixedBitSetFilterCache() {
        return this.shardFixedBitSetFilterCache;
    }

    public IndexFieldDataService indexFieldDataService() {
        return this.indexFieldDataService;
    }

    public MapperService mapperService() {
        return this.mapperService;
    }

    public IndexService indexService() {
        return this.indexService;
    }

    public ShardSearchService searchService() {
        return this.searchService;
    }

    public ShardIndexWarmerService warmerService() {
        return this.shardWarmerService;
    }

    public ShardFilterCache filterCache() {
        return this.shardFilterCache;
    }

    public ShardQueryCache queryCache() {
        return this.shardQueryCache;
    }

    public ShardFieldData fieldData() {
        return this.shardFieldData;
    }

    public ShardRouting routingEntry() {
        return this.shardRouting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexShard routingEntry(ShardRouting newRouting) {
        ShardRouting currentRouting = this.shardRouting;
        if (!newRouting.shardId().equals(this.shardId())) {
            throw new ElasticsearchIllegalArgumentException("Trying to set a routing entry with shardId [" + newRouting.shardId() + "] on a shard with shardId [" + this.shardId() + "]");
        }
        if (currentRouting != null) {
            if (!newRouting.primary() && currentRouting.primary()) {
                this.logger.warn("suspect illegal state: trying to move shard from primary mode to replica mode", new Object[0]);
            }
            if (currentRouting.equals(newRouting)) {
                return this;
            }
        }
        if (this.state == IndexShardState.POST_RECOVERY && (newRouting.state() == ShardRoutingState.STARTED || newRouting.state() == ShardRoutingState.RELOCATING)) {
            try {
                this.engine().refresh("cluster_state_started");
            }
            catch (Throwable t) {
                this.logger.debug("failed to refresh due to move to cluster wide started", t, new Object[0]);
            }
            boolean movedToStarted = false;
            Object object = this.mutex;
            synchronized (object) {
                if (this.state == IndexShardState.POST_RECOVERY) {
                    this.changeState(IndexShardState.STARTED, "global state is [" + (Object)((Object)newRouting.state()) + "]");
                    movedToStarted = true;
                } else {
                    this.logger.debug("state [{}] not changed, not in POST_RECOVERY, global state is [{}]", new Object[]{this.state, newRouting.state()});
                }
            }
            if (movedToStarted) {
                this.indicesLifecycle.afterIndexShardStarted(this);
            }
        }
        this.shardRouting = newRouting;
        this.indicesLifecycle.shardRoutingChanged(this, currentRouting, newRouting);
        return this;
    }

    public IndexShardState recovering(String reason, RecoveryState.Type type, DiscoveryNode sourceNode) throws IndexShardStartedException, IndexShardRelocatedException, IndexShardRecoveringException, IndexShardClosedException {
        return this.recovering(reason, new RecoveryState(this.shardId, this.shardRouting.primary(), type, sourceNode, this.localNode));
    }

    public IndexShardState recovering(String reason, RecoveryState.Type type, RestoreSource restoreSource) throws IndexShardStartedException {
        return this.recovering(reason, new RecoveryState(this.shardId, this.shardRouting.primary(), type, restoreSource, this.localNode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexShardState recovering(String reason, RecoveryState recoveryState) throws IndexShardStartedException, IndexShardRelocatedException, IndexShardRecoveringException, IndexShardClosedException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state == IndexShardState.CLOSED) {
                throw new IndexShardClosedException(this.shardId);
            }
            if (this.state == IndexShardState.STARTED) {
                throw new IndexShardStartedException(this.shardId);
            }
            if (this.state == IndexShardState.RELOCATED) {
                throw new IndexShardRelocatedException(this.shardId);
            }
            if (this.state == IndexShardState.RECOVERING) {
                throw new IndexShardRecoveringException(this.shardId);
            }
            if (this.state == IndexShardState.POST_RECOVERY) {
                throw new IndexShardRecoveringException(this.shardId);
            }
            this.recoveryState = recoveryState;
            return this.changeState(IndexShardState.RECOVERING, reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexShard relocated(String reason) throws IndexShardNotStartedException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state != IndexShardState.STARTED) {
                throw new IndexShardNotStartedException(this.shardId, this.state);
            }
            this.changeState(IndexShardState.RELOCATED, reason);
        }
        return this;
    }

    public IndexShardState state() {
        return this.state;
    }

    private IndexShardState changeState(IndexShardState newState, String reason) {
        this.logger.debug("state: [{}]->[{}], reason [{}]", new Object[]{this.state, newState, reason});
        IndexShardState previousState = this.state;
        this.state = newState;
        this.indicesLifecycle.indexShardStateChanged(this, previousState, reason);
        return previousState;
    }

    public Engine.Create prepareCreate(SourceToParse source, long version, VersionType versionType, Engine.Operation.Origin origin, boolean canHaveDuplicates, boolean autoGeneratedId) throws ElasticsearchException {
        long startTime = System.nanoTime();
        Tuple<DocumentMapper, Boolean> docMapper = this.mapperService.documentMapperWithAutoCreate(source.type());
        try {
            ParsedDocument doc = docMapper.v1().parse(source).setMappingsModified(docMapper);
            return new Engine.Create(docMapper.v1(), docMapper.v1().uidMapper().term(doc.uid().stringValue()), doc, version, versionType, origin, startTime, this.state != IndexShardState.STARTED || canHaveDuplicates, autoGeneratedId);
        }
        catch (Throwable t) {
            if (docMapper.v2().booleanValue()) {
                throw new WriteFailureException(t, docMapper.v1().type());
            }
            throw t;
        }
    }

    public ParsedDocument create(Engine.Create create) throws ElasticsearchException {
        this.writeAllowed(create.origin());
        create = this.indexingService.preCreate(create);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("index [{}][{}]{}", create.type(), create.id(), create.docs());
        }
        this.engine().create(create);
        create.endTime(System.nanoTime());
        this.indexingService.postCreate(create);
        return create.parsedDoc();
    }

    public Engine.Index prepareIndex(SourceToParse source, long version, VersionType versionType, Engine.Operation.Origin origin, boolean canHaveDuplicates) throws ElasticsearchException {
        long startTime = System.nanoTime();
        Tuple<DocumentMapper, Boolean> docMapper = this.mapperService.documentMapperWithAutoCreate(source.type());
        try {
            ParsedDocument doc = docMapper.v1().parse(source).setMappingsModified(docMapper);
            return new Engine.Index(docMapper.v1(), docMapper.v1().uidMapper().term(doc.uid().stringValue()), doc, version, versionType, origin, startTime, this.state != IndexShardState.STARTED || canHaveDuplicates);
        }
        catch (Throwable t) {
            if (docMapper.v2().booleanValue()) {
                throw new WriteFailureException(t, docMapper.v1().type());
            }
            throw t;
        }
    }

    public ParsedDocument index(Engine.Index index) throws ElasticsearchException {
        this.writeAllowed(index.origin());
        index = this.indexingService.preIndex(index);
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("index [{}][{}]{}", index.type(), index.id(), index.docs());
            }
            this.engine().index(index);
            index.endTime(System.nanoTime());
        }
        catch (RuntimeException ex) {
            this.indexingService.failedIndex(index);
            throw ex;
        }
        this.indexingService.postIndex(index);
        return index.parsedDoc();
    }

    public Engine.Delete prepareDelete(String type, String id, long version, VersionType versionType, Engine.Operation.Origin origin) throws ElasticsearchException {
        long startTime = System.nanoTime();
        DocumentMapper docMapper = this.mapperService.documentMapperWithAutoCreate(type).v1();
        return new Engine.Delete(type, id, docMapper.uidMapper().term(type, id), version, versionType, origin, startTime, false);
    }

    public void delete(Engine.Delete delete) throws ElasticsearchException {
        this.writeAllowed(delete.origin());
        delete = this.indexingService.preDelete(delete);
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("delete [{}]", delete.uid().text());
            }
            this.engine().delete(delete);
            delete.endTime(System.nanoTime());
        }
        catch (RuntimeException ex) {
            this.indexingService.failedDelete(delete);
            throw ex;
        }
        this.indexingService.postDelete(delete);
    }

    public Engine.DeleteByQuery prepareDeleteByQuery(BytesReference source, @Nullable String[] filteringAliases, Engine.Operation.Origin origin, String ... types) throws ElasticsearchException {
        long startTime = System.nanoTime();
        if (types == null) {
            types = Strings.EMPTY_ARRAY;
        }
        Query query = this.queryParserService.parseQuery(source).query();
        query = this.filterQueryIfNeeded(query, types);
        Filter aliasFilter = this.indexAliasesService.aliasFilter(filteringAliases);
        FixedBitSetFilter parentFilter = this.mapperService.hasNested() ? this.indexCache.fixedBitSetFilterCache().getFixedBitSetFilter(NonNestedDocsFilter.INSTANCE) : null;
        return new Engine.DeleteByQuery(query, source, filteringAliases, aliasFilter, parentFilter, origin, startTime, types);
    }

    public void deleteByQuery(Engine.DeleteByQuery deleteByQuery) throws ElasticsearchException {
        this.writeAllowed(deleteByQuery.origin());
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("delete_by_query [{}]", deleteByQuery.query());
        }
        deleteByQuery = this.indexingService.preDeleteByQuery(deleteByQuery);
        this.engine().delete(deleteByQuery);
        deleteByQuery.endTime(System.nanoTime());
        this.indexingService.postDeleteByQuery(deleteByQuery);
    }

    public Engine.GetResult get(Engine.Get get) throws ElasticsearchException {
        this.readAllowed();
        return this.engine().get(get);
    }

    public void refresh(String source) throws ElasticsearchException {
        this.verifyNotClosed();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("refresh with soruce: {}", source);
        }
        long time = System.nanoTime();
        this.engine().refresh(source);
        this.refreshMetric.inc(System.nanoTime() - time);
    }

    public RefreshStats refreshStats() {
        return new RefreshStats(this.refreshMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.refreshMetric.sum()));
    }

    public FlushStats flushStats() {
        return new FlushStats(this.flushMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.flushMetric.sum()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocsStats docStats() {
        try (Engine.Searcher searcher = this.acquireSearcher("doc_stats");){
            DocsStats docsStats = new DocsStats(searcher.reader().numDocs(), searcher.reader().numDeletedDocs());
            return docsStats;
        }
    }

    public IndexingStats indexingStats(String ... types) {
        return this.indexingService.stats(types);
    }

    public SearchStats searchStats(String ... groups) {
        return this.searchService.stats(groups);
    }

    public GetStats getStats() {
        return this.getService.stats();
    }

    public StoreStats storeStats() {
        try {
            return this.store.stats();
        }
        catch (IOException e) {
            throw new ElasticsearchException("io exception while building 'store stats'", e);
        }
        catch (AlreadyClosedException ex) {
            return null;
        }
    }

    public MergeStats mergeStats() {
        return this.mergeScheduler.stats();
    }

    public SegmentsStats segmentStats() {
        SegmentsStats segmentsStats = this.engine().segmentsStats();
        segmentsStats.addFixedBitSetMemoryInBytes(this.shardFixedBitSetFilterCache.getMemorySizeInBytes());
        return segmentsStats;
    }

    public WarmerStats warmerStats() {
        return this.shardWarmerService.stats();
    }

    public FilterCacheStats filterCacheStats() {
        return this.shardFilterCache.stats();
    }

    public FieldDataStats fieldDataStats(String ... fields) {
        return this.shardFieldData.stats(fields);
    }

    public PercolatorQueriesRegistry percolateRegistry() {
        return this.percolatorQueriesRegistry;
    }

    public ShardPercolateService shardPercolateService() {
        return this.shardPercolateService;
    }

    public IdCacheStats idCacheStats() {
        long memorySizeInBytes = this.shardFieldData.stats("_parent").getFields().get("_parent");
        return new IdCacheStats(memorySizeInBytes);
    }

    public TranslogStats translogStats() {
        return this.translog.stats();
    }

    public SuggestStats suggestStats() {
        return this.shardSuggestService.stats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStats completionStats(String ... fields) {
        CompletionStats completionStats = new CompletionStats();
        try (Engine.Searcher currentSearcher = this.acquireSearcher("completion_stats");){
            PostingsFormat postingsFormat = this.codecService.postingsFormatService().get("completion090").get();
            if (postingsFormat instanceof Completion090PostingsFormat) {
                Completion090PostingsFormat completionPostingsFormat = (Completion090PostingsFormat)postingsFormat;
                completionStats.add(completionPostingsFormat.completionStats(currentSearcher.reader(), fields));
            }
        }
        return completionStats;
    }

    public void flush(FlushRequest request) throws ElasticsearchException {
        this.verifyStartedOrRecovering();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("flush with {}", request);
        }
        long time = System.nanoTime();
        this.engine().flush(request.force(), request.waitIfOngoing());
        this.flushMetric.inc(System.nanoTime() - time);
    }

    public void optimize(OptimizeRequest optimize) throws ElasticsearchException {
        this.verifyStarted();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("optimize with {}", optimize);
        }
        this.engine().forceMerge(optimize.flush(), optimize.maxNumSegments(), optimize.onlyExpungeDeletes(), optimize.upgrade());
    }

    public SnapshotIndexCommit snapshotIndex() throws EngineException {
        IndexShardState state = this.state;
        if (state == IndexShardState.STARTED || state == IndexShardState.RELOCATED || state == IndexShardState.CLOSED) {
            return this.engine().snapshotIndex();
        }
        throw new IllegalIndexShardStateException(this.shardId, state, "snapshot is not allowed");
    }

    public void recover(Engine.RecoveryHandler recoveryHandler) throws EngineException {
        this.verifyStarted();
        this.engine().recover(recoveryHandler);
    }

    public void failShard(String reason, Throwable e) {
        this.engine().failEngine(reason, e);
    }

    public Engine.Searcher acquireSearcher(String source) {
        return this.acquireSearcher(source, false);
    }

    public Engine.Searcher acquireSearcher(String source, boolean searcherForWriteOperation) {
        this.readAllowed(searcherForWriteOperation);
        return this.engine().acquireSearcher(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String reason, boolean flushEngine) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            try {
                this.indexSettingsService.removeListener(this.applyRefreshSettings);
                if (this.state != IndexShardState.CLOSED) {
                    FutureUtils.cancel(this.refreshScheduledFuture);
                    this.refreshScheduledFuture = null;
                    FutureUtils.cancel(this.mergeScheduleFuture);
                    this.mergeScheduleFuture = null;
                }
                this.changeState(IndexShardState.CLOSED, reason);
            }
            catch (Throwable throwable) {
                Engine engine = this.currentEngineReference.getAndSet(null);
                try {
                    if (flushEngine && this.flushOnClose) {
                        engine.flushAndClose();
                    }
                }
                catch (Throwable throwable2) {
                    IOUtils.close((Closeable[])new Closeable[]{engine});
                    throw throwable2;
                }
                IOUtils.close((Closeable[])new Closeable[]{engine});
                throw throwable;
            }
            Engine engine = this.currentEngineReference.getAndSet(null);
            try {
                if (flushEngine && this.flushOnClose) {
                    engine.flushAndClose();
                }
            }
            catch (Throwable throwable) {
                IOUtils.close((Closeable[])new Closeable[]{engine});
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{engine});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexShard postRecovery(String reason) throws IndexShardStartedException, IndexShardRelocatedException, IndexShardClosedException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state == IndexShardState.CLOSED) {
                throw new IndexShardClosedException(this.shardId);
            }
            if (this.state == IndexShardState.STARTED) {
                throw new IndexShardStartedException(this.shardId);
            }
            if (this.state == IndexShardState.RELOCATED) {
                throw new IndexShardRelocatedException(this.shardId);
            }
            this.recoveryState.setStage(RecoveryState.Stage.DONE);
            this.changeState(IndexShardState.POST_RECOVERY, reason);
        }
        this.indicesLifecycle.afterIndexShardPostRecovery(this);
        return this;
    }

    public void prepareForIndexRecovery() throws ElasticsearchException {
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        this.recoveryState.setStage(RecoveryState.Stage.INDEX);
        assert (this.currentEngineReference.get() == null);
    }

    public void prepareForTranslogRecovery() throws ElasticsearchException {
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        this.recoveryState.setStage(RecoveryState.Stage.START);
        if (Booleans.parseBoolean(this.checkIndexOnStartup, false)) {
            this.checkIndex(true);
        }
        this.config.setEnableGcDeletes(false);
        this.createNewEngine();
        this.recoveryState.setStage(RecoveryState.Stage.TRANSLOG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performRecoveryRestart() throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state != IndexShardState.RECOVERING) {
                throw new IndexShardNotRecoveringException(this.shardId, this.state);
            }
            Engine engine = this.currentEngineReference.getAndSet(null);
            IOUtils.close((Closeable[])new Closeable[]{engine});
            this.recoveryState().setStage(RecoveryState.Stage.INIT);
        }
    }

    public RecoveryStats recoveryStats() {
        return this.recoveryStats;
    }

    public RecoveryState recoveryState() {
        return this.recoveryState;
    }

    public void finalizeRecovery() {
        this.recoveryState().setStage(RecoveryState.Stage.FINALIZE);
        this.translog.clearUnreferenced();
        this.engine().refresh("recovery_finalization");
        this.startScheduledTasksIfNeeded();
        this.config.setEnableGcDeletes(true);
    }

    public Engine.IndexingOperation performRecoveryOperation(Translog.Operation operation) throws ElasticsearchException {
        Engine.IndexingOperation indexOperation;
        block11: {
            if (this.state != IndexShardState.RECOVERING) {
                throw new IndexShardNotRecoveringException(this.shardId, this.state);
            }
            indexOperation = null;
            try {
                switch (operation.opType()) {
                    case CREATE: {
                        Translog.Create create = (Translog.Create)operation;
                        Engine.Create engineCreate = this.prepareCreate(SourceToParse.source(create.source()).type(create.type()).id(create.id()).routing(create.routing()).parent(create.parent()).timestamp(create.timestamp()).ttl(create.ttl()), create.version(), create.versionType().versionTypeForReplicationAndRecovery(), Engine.Operation.Origin.RECOVERY, true, false);
                        this.engine().create(engineCreate);
                        indexOperation = engineCreate;
                        break;
                    }
                    case SAVE: {
                        Translog.Index index = (Translog.Index)operation;
                        Engine.Index engineIndex = this.prepareIndex(SourceToParse.source(index.source()).type(index.type()).id(index.id()).routing(index.routing()).parent(index.parent()).timestamp(index.timestamp()).ttl(index.ttl()), index.version(), index.versionType().versionTypeForReplicationAndRecovery(), Engine.Operation.Origin.RECOVERY, true);
                        this.engine().index(engineIndex);
                        indexOperation = engineIndex;
                        break;
                    }
                    case DELETE: {
                        Translog.Delete delete = (Translog.Delete)operation;
                        Uid uid = Uid.createUid(delete.uid().text());
                        this.engine().delete(new Engine.Delete(uid.type(), uid.id(), delete.uid(), delete.version(), delete.versionType().versionTypeForReplicationAndRecovery(), Engine.Operation.Origin.RECOVERY, System.nanoTime(), false));
                        break;
                    }
                    case DELETE_BY_QUERY: {
                        Translog.DeleteByQuery deleteByQuery = (Translog.DeleteByQuery)operation;
                        this.engine().delete(this.prepareDeleteByQuery(deleteByQuery.source(), deleteByQuery.filteringAliases(), Engine.Operation.Origin.RECOVERY, deleteByQuery.types()));
                        break;
                    }
                    default: {
                        throw new ElasticsearchIllegalStateException("No operation defined for [" + operation + "]");
                    }
                }
            }
            catch (ElasticsearchException e) {
                boolean hasIgnoreOnRecoveryException = false;
                ElasticsearchException current = e;
                while (true) {
                    if (current instanceof IgnoreOnRecoveryEngineException) {
                        hasIgnoreOnRecoveryException = true;
                        break;
                    }
                    if (!(current.getCause() instanceof ElasticsearchException)) break;
                    current = (ElasticsearchException)current.getCause();
                }
                if (hasIgnoreOnRecoveryException) break block11;
                throw e;
            }
        }
        return indexOperation;
    }

    public boolean ignoreRecoveryAttempt() {
        IndexShardState state = this.state();
        return state == IndexShardState.POST_RECOVERY || state == IndexShardState.RECOVERING || state == IndexShardState.STARTED || state == IndexShardState.RELOCATED || state == IndexShardState.CLOSED;
    }

    public void readAllowed() throws IllegalIndexShardStateException {
        this.readAllowed(false);
    }

    private void readAllowed(boolean writeOperation) throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (writeOperation ? state != IndexShardState.STARTED && state != IndexShardState.RELOCATED && state != IndexShardState.RECOVERING && state != IndexShardState.POST_RECOVERY : state != IndexShardState.STARTED && state != IndexShardState.RELOCATED) {
            throw new IllegalIndexShardStateException(this.shardId, state, "operations only allowed when started/relocated");
        }
    }

    private void writeAllowed(Engine.Operation.Origin origin) throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (origin == Engine.Operation.Origin.PRIMARY ? state != IndexShardState.STARTED && state != IndexShardState.RELOCATED : state != IndexShardState.STARTED && state != IndexShardState.RELOCATED && state != IndexShardState.RECOVERING && state != IndexShardState.POST_RECOVERY) {
            throw new IllegalIndexShardStateException(this.shardId, state, "operation only allowed when started/recovering, origin [" + (Object)((Object)origin) + "]");
        }
    }

    protected final void verifyStartedOrRecovering() throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (state != IndexShardState.STARTED && state != IndexShardState.RECOVERING && state != IndexShardState.POST_RECOVERY) {
            throw new IllegalIndexShardStateException(this.shardId, state, "operation only allowed when started/recovering");
        }
    }

    private void verifyNotClosed() throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (state == IndexShardState.CLOSED) {
            throw new IllegalIndexShardStateException(this.shardId, state, "operation only allowed when not closed");
        }
    }

    protected final void verifyStarted() throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (state != IndexShardState.STARTED) {
            throw new IndexShardNotStartedException(this.shardId, state);
        }
    }

    private void startScheduledTasksIfNeeded() {
        if (this.refreshInterval.millis() > 0L) {
            this.refreshScheduledFuture = this.threadPool.schedule(this.refreshInterval, "same", new EngineRefresher());
            this.logger.debug("scheduling refresher every {}", this.refreshInterval);
        } else {
            this.logger.debug("scheduled refresher disabled", new Object[0]);
        }
        if (this.mergeInterval.millis() > 0L) {
            this.mergeScheduleFuture = this.threadPool.schedule(this.mergeInterval, "same", new EngineMerger());
            this.logger.debug("scheduling optimizer / merger every {}", this.mergeInterval);
        } else {
            this.logger.debug("scheduled optimizer / merger disabled", new Object[0]);
        }
    }

    private Query filterQueryIfNeeded(Query query, String[] types) {
        Filter searchFilter = this.mapperService.searchFilter(types);
        if (searchFilter != null) {
            query = new XFilteredQuery(query, this.indexCache.filter().cache(searchFilter));
        }
        return query;
    }

    public void addFailedEngineListener(Engine.FailedEngineListener failedEngineListener) {
        this.failedEngineListener.delegates.add(failedEngineListener);
    }

    public void updateBufferSize(ByteSizeValue shardIndexingBufferSize, ByteSizeValue shardTranslogBufferSize) {
        ByteSizeValue preValue = this.config.getIndexingBufferSize();
        this.config.setIndexingBufferSize(shardIndexingBufferSize);
        if (preValue.bytes() != shardIndexingBufferSize.bytes() && this.engineUnsafe() != null) {
            if (shardIndexingBufferSize == EngineConfig.INACTIVE_SHARD_INDEXING_BUFFER && preValue != EngineConfig.INACTIVE_SHARD_INDEXING_BUFFER) {
                this.logger.debug("updating index_buffer_size from [{}] to (inactive) [{}]", preValue, shardIndexingBufferSize);
                try {
                    this.refresh("update index buffer");
                }
                catch (Throwable e) {
                    this.logger.warn("failed to refresh after setting shard to inactive", e, new Object[0]);
                }
            } else {
                this.logger.debug("updating index_buffer_size from [{}] to [{}]", preValue, shardIndexingBufferSize);
            }
        }
        this.translog().updateBuffer(shardTranslogBufferSize);
    }

    public void markAsInactive() {
        this.updateBufferSize(EngineConfig.INACTIVE_SHARD_INDEXING_BUFFER, Translog.INACTIVE_SHARD_TRANSLOG_BUFFER);
    }

    public final boolean isFlushOnClose() {
        return this.flushOnClose;
    }

    private void checkIndex(boolean throwException) throws IndexShardException {
        try {
            long time = System.currentTimeMillis();
            if (!Lucene.indexExists(this.store.directory())) {
                return;
            }
            CheckIndex checkIndex = new CheckIndex(this.store.directory());
            BytesStreamOutput os = new BytesStreamOutput();
            PrintStream out = new PrintStream((OutputStream)os, false, Charsets.UTF_8.name());
            checkIndex.setInfoStream(out);
            out.flush();
            CheckIndex.Status status = checkIndex.checkIndex();
            if (!status.clean) {
                if (this.state == IndexShardState.CLOSED) {
                    return;
                }
                this.logger.warn("check index [failure]\n{}", new String(os.bytes().toBytes(), Charsets.UTF_8));
                if ("fix".equalsIgnoreCase(this.checkIndexOnStartup)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("fixing index, writing new segments file ...", new Object[0]);
                    }
                    checkIndex.fixIndex(status);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("index fixed, wrote new segments file \"{}\"", status.segmentsFileName);
                    }
                } else if (throwException) {
                    throw new IndexShardException(this.shardId, "index check failure");
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("check index [success]\n{}", new String(os.bytes().toBytes(), Charsets.UTF_8));
            }
            this.recoveryState.getStart().checkIndexTime(Math.max(0L, System.currentTimeMillis() - time));
        }
        catch (Exception e) {
            this.logger.warn("failed to check index", e, new Object[0]);
        }
    }

    public Engine engine() {
        Engine engine = this.engineUnsafe();
        if (engine == null) {
            throw new EngineClosedException(this.shardId);
        }
        return engine;
    }

    protected Engine engineUnsafe() {
        return this.currentEngineReference.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewEngine() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state == IndexShardState.CLOSED) {
                throw new EngineClosedException(this.shardId);
            }
            assert (this.currentEngineReference.get() == null);
            this.currentEngineReference.set(this.newEngine());
        }
    }

    protected Engine newEngine() {
        return this.engineFactory.newReadWriteEngine(this.config);
    }

    public boolean allowsPrimaryPromotion() {
        return true;
    }

    class ShardEngineFailListener
    implements Engine.FailedEngineListener {
        private final CopyOnWriteArrayList<Engine.FailedEngineListener> delegates = new CopyOnWriteArrayList();

        ShardEngineFailListener() {
        }

        @Override
        public void onFailedEngine(ShardId shardId, String reason, @Nullable Throwable failure) {
            for (Engine.FailedEngineListener listener : this.delegates) {
                try {
                    listener.onFailedEngine(shardId, reason, failure);
                }
                catch (Exception e) {
                    IndexShard.this.logger.warn("exception while notifying engine failure", e, new Object[0]);
                }
            }
        }
    }

    class EngineMerger
    implements Runnable {
        EngineMerger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!IndexShard.this.engine().possibleMergeNeeded()) {
                Object object = IndexShard.this.mutex;
                synchronized (object) {
                    if (IndexShard.this.state != IndexShardState.CLOSED) {
                        IndexShard.this.mergeScheduleFuture = IndexShard.this.threadPool.schedule(IndexShard.this.mergeInterval, "same", this);
                    }
                }
                return;
            }
            IndexShard.this.threadPool.executor("merge").execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block9: {
                        try {
                            IndexShard.this.engine().maybeMerge();
                        }
                        catch (EngineClosedException e) {
                        }
                        catch (OptimizeFailedEngineException e) {
                            if (!(e.getCause() instanceof EngineClosedException || e.getCause() instanceof InterruptedException || e.getCause() instanceof ClosedByInterruptException || e.getCause() instanceof ThreadInterruptedException || IndexShard.this.state == IndexShardState.CLOSED)) {
                                IndexShard.this.logger.warn("Failed to perform scheduled engine optimize/merge", e, new Object[0]);
                            }
                        }
                        catch (Exception e) {
                            if (IndexShard.this.state == IndexShardState.CLOSED) break block9;
                            IndexShard.this.logger.warn("Failed to perform scheduled engine optimize/merge", e, new Object[0]);
                        }
                    }
                    Object object = IndexShard.this.mutex;
                    synchronized (object) {
                        if (IndexShard.this.state != IndexShardState.CLOSED) {
                            IndexShard.this.mergeScheduleFuture = IndexShard.this.threadPool.schedule(IndexShard.this.mergeInterval, "same", EngineMerger.this);
                        }
                    }
                }
            });
        }
    }

    class EngineRefresher
    implements Runnable {
        EngineRefresher() {
        }

        @Override
        public void run() {
            if (!IndexShard.this.engine().refreshNeeded()) {
                this.reschedule();
                return;
            }
            IndexShard.this.threadPool.executor("refresh").execute(new Runnable(){

                @Override
                public void run() {
                    block6: {
                        try {
                            if (IndexShard.this.engine().refreshNeeded()) {
                                IndexShard.this.refresh("schedule");
                            }
                        }
                        catch (EngineClosedException e) {
                        }
                        catch (RefreshFailedEngineException e) {
                            if (!(e.getCause() instanceof InterruptedException || e.getCause() instanceof ClosedByInterruptException || e.getCause() instanceof ThreadInterruptedException || IndexShard.this.state == IndexShardState.CLOSED)) {
                                IndexShard.this.logger.warn("Failed to perform scheduled engine refresh", e, new Object[0]);
                            }
                        }
                        catch (Exception e) {
                            if (IndexShard.this.state == IndexShardState.CLOSED) break block6;
                            IndexShard.this.logger.warn("Failed to perform scheduled engine refresh", e, new Object[0]);
                        }
                    }
                    EngineRefresher.this.reschedule();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reschedule() {
            Object object = IndexShard.this.mutex;
            synchronized (object) {
                if (IndexShard.this.state != IndexShardState.CLOSED && IndexShard.this.refreshInterval.millis() > 0L) {
                    IndexShard.this.refreshScheduledFuture = IndexShard.this.threadPool.schedule(IndexShard.this.refreshInterval, "same", this);
                }
            }
        }
    }

    private class ApplyRefreshSettings
    implements IndexSettingsService.Listener {
        private ApplyRefreshSettings() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRefreshSettings(Settings settings) {
            boolean change = false;
            Object object = IndexShard.this.mutex;
            synchronized (object) {
                boolean checksumOnMerge;
                boolean failOnMergeFailure;
                boolean failEngineOnCorruption;
                boolean compoundOnFlush;
                long gcDeletesInMillis;
                TimeValue refreshInterval;
                if (IndexShard.this.state == IndexShardState.CLOSED) {
                    return;
                }
                boolean flushOnClose = settings.getAsBoolean(IndexShard.INDEX_FLUSH_ON_CLOSE, (Boolean)IndexShard.this.flushOnClose);
                if (flushOnClose != IndexShard.this.flushOnClose) {
                    IndexShard.this.logger.info("updating {} from [{}] to [{}]", IndexShard.INDEX_FLUSH_ON_CLOSE, IndexShard.this.flushOnClose, flushOnClose);
                    IndexShard.this.flushOnClose = flushOnClose;
                }
                if (!(refreshInterval = settings.getAsTime(IndexShard.INDEX_REFRESH_INTERVAL, IndexShard.this.refreshInterval)).equals(IndexShard.this.refreshInterval)) {
                    IndexShard.this.logger.info("updating refresh_interval from [{}] to [{}]", IndexShard.this.refreshInterval, refreshInterval);
                    if (IndexShard.this.refreshScheduledFuture != null) {
                        FutureUtils.cancel(IndexShard.this.refreshScheduledFuture);
                        IndexShard.this.refreshScheduledFuture = null;
                    }
                    IndexShard.this.refreshInterval = refreshInterval;
                    if (refreshInterval.millis() > 0L) {
                        IndexShard.this.refreshScheduledFuture = IndexShard.this.threadPool.schedule(refreshInterval, "same", new EngineRefresher());
                    }
                }
                if ((gcDeletesInMillis = settings.getAsTime("index.gc_deletes", TimeValue.timeValueMillis(IndexShard.this.config.getGcDeletesInMillis())).millis()) != IndexShard.this.config.getGcDeletesInMillis()) {
                    IndexShard.this.logger.info("updating {} from [{}] to [{}]", "index.gc_deletes", TimeValue.timeValueMillis(IndexShard.this.config.getGcDeletesInMillis()), TimeValue.timeValueMillis(gcDeletesInMillis));
                    IndexShard.this.config.setGcDeletesInMillis(gcDeletesInMillis);
                    change = true;
                }
                if ((compoundOnFlush = settings.getAsBoolean("index.compound_on_flush", (Boolean)IndexShard.this.config.isCompoundOnFlush()).booleanValue()) != IndexShard.this.config.isCompoundOnFlush()) {
                    IndexShard.this.logger.info("updating {} from [{}] to [{}]", "index.compound_on_flush", IndexShard.this.config.isCompoundOnFlush(), compoundOnFlush);
                    IndexShard.this.config.setCompoundOnFlush(compoundOnFlush);
                    change = true;
                }
                if ((failEngineOnCorruption = settings.getAsBoolean("index.fail_on_corruption", (Boolean)IndexShard.this.config.isFailEngineOnCorruption()).booleanValue()) != IndexShard.this.config.isFailEngineOnCorruption()) {
                    IndexShard.this.logger.info("updating {} from [{}] to [{}]", "index.fail_on_corruption", IndexShard.this.config.isFailEngineOnCorruption(), failEngineOnCorruption);
                    IndexShard.this.config.setFailEngineOnCorruption(failEngineOnCorruption);
                    change = true;
                }
                if ((failOnMergeFailure = settings.getAsBoolean("index.fail_on_merge_failure", (Boolean)IndexShard.this.config.isFailOnMergeFailure()).booleanValue()) != IndexShard.this.config.isFailOnMergeFailure()) {
                    IndexShard.this.logger.info("updating {} from [{}] to [{}]", "index.fail_on_merge_failure", IndexShard.this.config.isFailOnMergeFailure(), failOnMergeFailure);
                    IndexShard.this.config.setFailOnMergeFailure(failOnMergeFailure);
                    change = true;
                }
                if ((checksumOnMerge = settings.getAsBoolean("index.checksum_on_merge", (Boolean)IndexShard.this.config.isChecksumOnMerge()).booleanValue()) != IndexShard.this.config.isChecksumOnMerge()) {
                    IndexShard.this.logger.info("updating {} from [{}] to [{}]", "index.checksum_on_merge", IndexShard.this.config.isChecksumOnMerge(), checksumOnMerge);
                    IndexShard.this.config.setChecksumOnMerge(checksumOnMerge);
                    change = true;
                }
                String versionMapSize = settings.get("index.version_map_size", IndexShard.this.config.getVersionMapSizeSetting());
                if (!IndexShard.this.config.getVersionMapSizeSetting().equals(versionMapSize)) {
                    IndexShard.this.config.setVersionMapSizeSetting(versionMapSize);
                }
            }
            if (change) {
                IndexShard.this.refresh("apply settings");
            }
        }
    }
}

