/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.fs;

import java.io.File;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.monitor.fs.FsProbe;
import org.elasticsearch.monitor.fs.FsStats;

public class JmxFsProbe
extends AbstractComponent
implements FsProbe {
    private final NodeEnvironment nodeEnv;

    @Inject
    public JmxFsProbe(Settings settings, NodeEnvironment nodeEnv) {
        super(settings);
        this.nodeEnv = nodeEnv;
    }

    @Override
    public FsStats stats() {
        if (!this.nodeEnv.hasNodeFile()) {
            return new FsStats(System.currentTimeMillis(), new FsStats.Info[0]);
        }
        File[] dataLocations = this.nodeEnv.nodeDataLocations();
        FsStats.Info[] infos = new FsStats.Info[dataLocations.length];
        for (int i = 0; i < dataLocations.length; ++i) {
            File dataLocation = dataLocations[i];
            FsStats.Info info = new FsStats.Info();
            info.path = dataLocation.getAbsolutePath();
            info.total = dataLocation.getTotalSpace();
            info.free = dataLocation.getFreeSpace();
            info.available = dataLocation.getUsableSpace();
            infos[i] = info;
        }
        return new FsStats(System.currentTimeMillis(), infos);
    }
}

