/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.util.List;
import org.elasticsearch.common.joda.time.DateTime;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;

public interface DateHistogram
extends Histogram {
    public List<? extends Bucket> getBuckets();

    @Override
    public Bucket getBucketByKey(String var1);

    @Override
    public Bucket getBucketByKey(Number var1);

    public Bucket getBucketByKey(DateTime var1);

    public static class Interval {
        public static final Interval SECOND = new Interval("1s");
        public static final Interval MINUTE = new Interval("1m");
        public static final Interval HOUR = new Interval("1h");
        public static final Interval DAY = new Interval("1d");
        public static final Interval WEEK = new Interval("1w");
        public static final Interval MONTH = new Interval("1M");
        public static final Interval QUARTER = new Interval("1q");
        public static final Interval YEAR = new Interval("1y");
        private final String expression;

        public static Interval seconds(int sec) {
            return new Interval(sec + "s");
        }

        public static Interval minutes(int min) {
            return new Interval(min + "m");
        }

        public static Interval hours(int hours) {
            return new Interval(hours + "h");
        }

        public static Interval days(int days) {
            return new Interval(days + "d");
        }

        public static Interval weeks(int weeks) {
            return new Interval(weeks + "w");
        }

        public Interval(String expression) {
            this.expression = expression;
        }

        public String toString() {
            return this.expression;
        }
    }

    public static interface Bucket
    extends Histogram.Bucket {
        public DateTime getKeyAsDate();
    }
}

