/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.datehistogram;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.common.hppc.LongObjectOpenHashMap;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.rounding.Rounding;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.facet.DoubleFacetAggregatorBase;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.LongFacetAggregatorBase;
import org.elasticsearch.search.facet.datehistogram.DateHistogramFacet;
import org.elasticsearch.search.facet.datehistogram.InternalFullDateHistogramFacet;

public class ValueDateHistogramFacetExecutor
extends FacetExecutor {
    private final IndexNumericFieldData keyIndexFieldData;
    private final IndexNumericFieldData valueIndexFieldData;
    private final DateHistogramFacet.ComparatorType comparatorType;
    final Rounding tzRounding;
    final Recycler.V<LongObjectOpenHashMap<InternalFullDateHistogramFacet.FullEntry>> entries;

    public ValueDateHistogramFacetExecutor(IndexNumericFieldData keyIndexFieldData, IndexNumericFieldData valueIndexFieldData, Rounding tzRounding, DateHistogramFacet.ComparatorType comparatorType, CacheRecycler cacheRecycler) {
        this.comparatorType = comparatorType;
        this.keyIndexFieldData = keyIndexFieldData;
        this.valueIndexFieldData = valueIndexFieldData;
        this.tzRounding = tzRounding;
        this.entries = cacheRecycler.longObjectMap(-1);
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        ArrayList<InternalFullDateHistogramFacet.FullEntry> entries1 = new ArrayList<InternalFullDateHistogramFacet.FullEntry>(this.entries.v().size());
        boolean[] states = this.entries.v().allocated;
        VType[] values = this.entries.v().values;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            InternalFullDateHistogramFacet.FullEntry value = (InternalFullDateHistogramFacet.FullEntry)values[i];
            entries1.add(value);
        }
        this.entries.close();
        return new InternalFullDateHistogramFacet(facetName, this.comparatorType, entries1);
    }

    public static class DateHistogramProc
    extends LongFacetAggregatorBase {
        final LongObjectOpenHashMap<InternalFullDateHistogramFacet.FullEntry> entries;
        private final Rounding tzRounding;
        SortedNumericDoubleValues valueValues;
        final ValueAggregator valueAggregator = new ValueAggregator();

        public DateHistogramProc(Rounding tzRounding, LongObjectOpenHashMap<InternalFullDateHistogramFacet.FullEntry> entries) {
            this.tzRounding = tzRounding;
            this.entries = entries;
        }

        @Override
        public void onValue(int docId, long value) {
            long time = this.tzRounding.round(value);
            InternalFullDateHistogramFacet.FullEntry entry = this.entries.get(time);
            if (entry == null) {
                entry = new InternalFullDateHistogramFacet.FullEntry(time, 0L, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 0L, 0.0);
                this.entries.put(time, entry);
            }
            ++entry.count;
            this.valueAggregator.entry = entry;
            this.valueAggregator.onDoc(docId, this.valueValues);
        }

        public static final class ValueAggregator
        extends DoubleFacetAggregatorBase {
            InternalFullDateHistogramFacet.FullEntry entry;

            @Override
            public void onValue(int docId, double value) {
                ++this.entry.totalCount;
                this.entry.total += value;
                if (value < this.entry.min) {
                    this.entry.min = value;
                }
                if (value > this.entry.max) {
                    this.entry.max = value;
                }
            }
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private final DateHistogramProc histoProc;
        private SortedNumericDocValues keyValues;

        public Collector() {
            this.histoProc = new DateHistogramProc(ValueDateHistogramFacetExecutor.this.tzRounding, ValueDateHistogramFacetExecutor.this.entries.v());
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.keyValues = ((AtomicNumericFieldData)ValueDateHistogramFacetExecutor.this.keyIndexFieldData.load(context)).getLongValues();
            this.histoProc.valueValues = ((AtomicNumericFieldData)ValueDateHistogramFacetExecutor.this.valueIndexFieldData.load(context)).getDoubleValues();
        }

        public void collect(int doc) throws IOException {
            this.histoProc.onDoc(doc, this.keyValues);
        }

        @Override
        public void postCollection() {
        }
    }
}

