/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.search.type.ParsedScrollId;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.internal.ShardSearchRequest;

public class ShardSearchLocalRequest
implements ShardSearchRequest {
    private String index;
    private int shardId;
    private int numberOfShards;
    private SearchType searchType;
    private Scroll scroll;
    private String[] types = Strings.EMPTY_ARRAY;
    private String[] filteringAliases;
    private BytesReference source;
    private BytesReference extraSource;
    private BytesReference templateSource;
    private String templateName;
    private ScriptService.ScriptType templateType;
    private Map<String, Object> templateParams;
    private Boolean queryCache;
    private long nowInMillis;
    private boolean useSlowScroll;

    ShardSearchLocalRequest() {
    }

    ShardSearchLocalRequest(SearchRequest searchRequest, ShardRouting shardRouting, int numberOfShards, boolean useSlowScroll, String[] filteringAliases, long nowInMillis) {
        this(shardRouting.shardId(), numberOfShards, searchRequest.searchType(), searchRequest.source(), searchRequest.types(), searchRequest.queryCache());
        this.extraSource = searchRequest.extraSource();
        this.templateSource = searchRequest.templateSource();
        this.templateName = searchRequest.templateName();
        this.templateType = searchRequest.templateType();
        this.templateParams = searchRequest.templateParams();
        this.scroll = searchRequest.scroll();
        this.useSlowScroll = useSlowScroll;
        this.filteringAliases = filteringAliases;
        this.nowInMillis = nowInMillis;
    }

    public ShardSearchLocalRequest(String[] types, long nowInMillis) {
        this.types = types;
        this.nowInMillis = nowInMillis;
    }

    public ShardSearchLocalRequest(String[] types, long nowInMillis, String[] filteringAliases) {
        this(types, nowInMillis);
        this.filteringAliases = filteringAliases;
    }

    public ShardSearchLocalRequest(ShardId shardId, int numberOfShards, SearchType searchType, BytesReference source, String[] types, Boolean queryCache) {
        this.index = shardId.getIndex();
        this.shardId = shardId.id();
        this.numberOfShards = numberOfShards;
        this.searchType = searchType;
        this.source = source;
        this.types = types;
        this.queryCache = queryCache;
    }

    @Override
    public String index() {
        return this.index;
    }

    @Override
    public int shardId() {
        return this.shardId;
    }

    @Override
    public String[] types() {
        return this.types;
    }

    @Override
    public BytesReference source() {
        return this.source;
    }

    @Override
    public void source(BytesReference source) {
        this.source = source;
    }

    @Override
    public BytesReference extraSource() {
        return this.extraSource;
    }

    @Override
    public int numberOfShards() {
        return this.numberOfShards;
    }

    @Override
    public SearchType searchType() {
        return this.searchType;
    }

    @Override
    public String[] filteringAliases() {
        return this.filteringAliases;
    }

    @Override
    public long nowInMillis() {
        return this.nowInMillis;
    }

    @Override
    public String templateName() {
        return this.templateName;
    }

    @Override
    public ScriptService.ScriptType templateType() {
        return this.templateType;
    }

    @Override
    public Map<String, Object> templateParams() {
        return this.templateParams;
    }

    @Override
    public BytesReference templateSource() {
        return this.templateSource;
    }

    @Override
    public Boolean queryCache() {
        return this.queryCache;
    }

    @Override
    public Scroll scroll() {
        return this.scroll;
    }

    @Override
    public boolean useSlowScroll() {
        return this.useSlowScroll;
    }

    protected void innerReadFrom(StreamInput in) throws IOException {
        this.index = in.readString();
        this.shardId = in.readVInt();
        this.searchType = SearchType.fromId(in.readByte());
        this.numberOfShards = in.readVInt();
        if (in.readBoolean()) {
            this.scroll = Scroll.readScroll(in);
        }
        this.source = in.readBytesReference();
        this.extraSource = in.readBytesReference();
        this.types = in.readStringArray();
        this.filteringAliases = in.readStringArray();
        this.nowInMillis = in.readVLong();
        if (in.getVersion().onOrAfter(Version.V_1_1_0)) {
            this.templateSource = in.readBytesReference();
            this.templateName = in.readOptionalString();
            if (in.getVersion().onOrAfter(Version.V_1_3_0)) {
                this.templateType = ScriptService.ScriptType.readFrom(in);
            }
            if (in.readBoolean()) {
                this.templateParams = (Map)in.readGenericValue();
            }
        }
        this.useSlowScroll = in.getVersion().onOrAfter(ParsedScrollId.SCROLL_SEARCH_AFTER_MINIMUM_VERSION) ? in.readBoolean() : in.getVersion().before(ParsedScrollId.SCROLL_SEARCH_AFTER_MINIMUM_VERSION);
        if (in.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            this.queryCache = in.readOptionalBoolean();
        }
    }

    protected void innerWriteTo(StreamOutput out, boolean asKey) throws IOException {
        out.writeString(this.index);
        out.writeVInt(this.shardId);
        out.writeByte(this.searchType.id());
        if (!asKey) {
            out.writeVInt(this.numberOfShards);
        }
        if (this.scroll == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.scroll.writeTo(out);
        }
        out.writeBytesReference(this.source);
        out.writeBytesReference(this.extraSource);
        out.writeStringArray(this.types);
        out.writeStringArrayNullable(this.filteringAliases);
        if (!asKey) {
            out.writeVLong(this.nowInMillis);
        }
        if (out.getVersion().onOrAfter(Version.V_1_1_0)) {
            out.writeBytesReference(this.templateSource);
            out.writeOptionalString(this.templateName);
            if (out.getVersion().onOrAfter(Version.V_1_3_0)) {
                ScriptService.ScriptType.writeTo(this.templateType, out);
            }
            boolean existTemplateParams = this.templateParams != null;
            out.writeBoolean(existTemplateParams);
            if (existTemplateParams) {
                out.writeGenericValue(this.templateParams);
            }
        }
        if (out.getVersion().onOrAfter(ParsedScrollId.SCROLL_SEARCH_AFTER_MINIMUM_VERSION)) {
            out.writeBoolean(this.useSlowScroll);
        }
        if (out.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            out.writeOptionalBoolean(this.queryCache);
        }
    }

    @Override
    public BytesReference cacheKey() throws IOException {
        BytesStreamOutput out = new BytesStreamOutput();
        this.innerWriteTo(out, true);
        return out.bytes().copyBytesArray();
    }
}

