/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest;

class Spinner
extends Thread {
    private final String message;
    private volatile boolean showProgress = true;

    Spinner(String message) {
        this.message = message;
        this.setDaemon(true);
    }

    public void finish() {
        this.finishQuietly();
        System.out.println("\r" + this.message + " ... done.");
    }

    public void finishQuietly() {
        this.showProgress = false;
        while (this.isAlive()) {
            this.sleepOnIt();
        }
    }

    @Override
    public void run() {
        String anim = "\\-/|";
        int x = 0;
        while (this.showProgress) {
            System.out.print("\r" + this.message + " ... " + anim.charAt(x++ % anim.length()));
            this.sleepOnIt();
        }
    }

    public void sleepOnIt() {
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

