/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest;

import com.xebialabs.xltest.domain.Dashboard;
import com.xebialabs.xltest.utils.JcrUtils;
import java.util.UUID;

public enum Synthetic {
    REPORTS("xlt.Reports", "Configuration/Reports"),
    DASHBOARD("xlt.Dashboard", "Configuration/Dashboards"),
    HOST("xlt.Host", "Infrastructure/Hosts"),
    TAG("xlt.Tag", "Configuration/Tags"),
    PROJECT("xlt.Project", "Configuration/Projects");

    public static final String XLTESTVIEW_COMPONENT = "xl-testview";
    public final String jcrDirectory;
    public final String name;

    private Synthetic(String name, String jcrDirectory) {
        this.name = name;
        this.jcrDirectory = jcrDirectory;
    }

    public static Synthetic withName(String name) {
        for (Synthetic synthetic : Synthetic.values()) {
            if (!synthetic.name.equals(name)) continue;
            return synthetic;
        }
        return null;
    }

    public static String createNotEncodedHostId(String name) {
        return Synthetic.HOST.jcrDirectory + "/" + name;
    }

    public static String createHostId(String name) {
        return Synthetic.HOST.jcrDirectory + "/" + JcrUtils.encodeJcrId(name);
    }

    public static String createSpecificationForProjectId(String projectName, String testSpecificationName) {
        return Synthetic.createProjectId(projectName) + "/" + testSpecificationName;
    }

    public static String createNewSpecificationForProjectId(String projectName) {
        return Synthetic.createProjectId(projectName) + "/" + UUID.randomUUID().toString();
    }

    public static String createProjectId(String projectName) {
        return Synthetic.PROJECT.jcrDirectory + "/" + projectName;
    }

    public static String createNewProjectId() {
        return Synthetic.createProjectId(UUID.randomUUID().toString());
    }

    public static String retrieveFullNameFromNotEncodedHostId(String absoluteId) {
        try {
            String prefix = Synthetic.HOST.jcrDirectory + "/";
            return absoluteId.substring(prefix.length());
        }
        catch (StringIndexOutOfBoundsException ie) {
            throw new IllegalArgumentException("Unable to determine full name from [" + absoluteId + "]", ie);
        }
    }

    public static String createNewDashboardId() {
        return Synthetic.createNewDashboardId(UUID.randomUUID().toString());
    }

    public static String createNewDashboardId(String dashboardName) {
        return Synthetic.DASHBOARD.jcrDirectory + "/" + dashboardName;
    }

    public static String createNewDashboardTileId(Dashboard dashboard) {
        return dashboard.getId() + "/" + UUID.randomUUID().toString();
    }

    public static String createNewDashboardTileId(String dashboardName, String dashboardTileName) {
        return Synthetic.createNewDashboardId(dashboardName) + "/" + dashboardTileName;
    }

    public static String retrieveDashboardIdFromDashboardTileId(String dashboardTileId) {
        try {
            int lastSlash = dashboardTileId.lastIndexOf("/");
            return dashboardTileId.substring(0, lastSlash);
        }
        catch (StringIndexOutOfBoundsException ie) {
            throw new IllegalArgumentException("Unable to determine full name from [" + dashboardTileId + "]", ie);
        }
    }
}

