/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api.internal;

import com.google.common.base.Joiner;
import com.jayway.jsonpath.spi.JsonProviderFactory;
import com.xebialabs.xlt.plugin.api.testrun.TestRun;
import com.xebialabs.xlt.plugin.api.testrun.TestRunsRepository;
import com.xebialabs.xltest.domain.Report;
import com.xebialabs.xltest.service.ReportService;
import com.xebialabs.xltest.utils.JcrUtils;
import com.xebialabs.xltest.utils.PeriodToDates;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;

@Controller
@Path(value="/api/internal/reports")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@NoCache
public class ReportController {
    private final TestRunsRepository testRunsRepository;
    private final ReportService reportService;

    @Autowired
    public ReportController(TestRunsRepository testRunsRepository, ReportService reportService) {
        this.testRunsRepository = testRunsRepository;
        this.reportService = reportService;
    }

    @GET
    @Path(value="/{reportName}/testspecification/{testSpecificationName:.*}")
    public Response generateReportFromTestSpecification(@PathParam(value="testSpecificationName") String testSpecificationName, @PathParam(value="reportName") String reportName, @Context UriInfo uriInfo, @QueryParam(value="date") String date, @QueryParam(value="range") String range) throws IOException {
        DateTime parsedDate = DateTime.now();
        if (StringUtils.hasText((String)date) && !"now".equals(date)) {
            parsedDate = DateTime.parse((String)date);
        }
        PeriodToDates period = new PeriodToDates(parsedDate);
        DateTime startDate = period.getBeginDateOf(range);
        DateTime endDate = period.getEndDateWithTimeEndOfDay();
        TestRun latestTestRun = this.testRunsRepository.getLatestTestRun(JcrUtils.encodeJcrId(testSpecificationName), startDate.getMillis(), endDate.getMillis());
        if (latestTestRun == null) {
            return Response.noContent().build();
        }
        Report report = this.reportService.createReport(reportName);
        Map<String, Object> resultObject = this.reportService.generateReport(latestTestRun, report, this.convertMultivaluedMapToMap((MultivaluedMap<String, String>)uriInfo.getQueryParameters()), startDate.toDate(), endDate.toDate());
        return Response.ok((Object)JsonProviderFactory.createProvider().toJson(resultObject)).build();
    }

    @GET
    @Path(value="/{reportName}/testrun/{testRunId:.*}")
    public Response generateReportFromTestRun(@PathParam(value="testRunId") String testRunId, @PathParam(value="reportName") String reportName, @Context UriInfo uriInfo) throws IOException {
        TestRun testRun = this.testRunsRepository.getTestRun(testRunId);
        if (testRun == null) {
            return Response.noContent().build();
        }
        Map<String, Object> resultObject = this.reportService.generateReport(testRun, this.reportService.createReport(reportName), this.convertMultivaluedMapToMap((MultivaluedMap<String, String>)uriInfo.getQueryParameters()), testRun.getStartTime(), testRun.getFinishedTime());
        return Response.ok(resultObject).build();
    }

    private Map<String, String> convertMultivaluedMapToMap(MultivaluedMap<String, String> multivaluedMap) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String key : multivaluedMap.keySet()) {
            if (((List)multivaluedMap.get((Object)key)).size() == 1) {
                map.put(key, (String)multivaluedMap.getFirst((Object)key));
                continue;
            }
            map.put(key, Joiner.on((String)";").join((Iterable)multivaluedMap.get((Object)key)));
        }
        return map;
    }
}

