/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.configuration;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import com.xebialabs.xltest.SystemProperties;
import com.xebialabs.xltest.authentication.Http401AuthenticationEntryPoint;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.security.authentication.AnonymousAuthenticationProvider;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.ldap.authentication.NullLdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.security.web.AuthenticationEntryPoint;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity
@PropertySource(value={"classpath:users.conf"})
public class WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(WebSecurityConfig.class);
    @Autowired
    private Config config;

    private SystemProperties.AuthenticationMethods getAuthenticationMethod() {
        try {
            return SystemProperties.AuthenticationMethods.valueOf(this.config.getString("xlt.authentication.method").toLowerCase());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(String.format("Invalid value for System Property %s. Valid values are %s", "xlt.authentication.method", Lists.newArrayList((Object[])SystemProperties.AuthenticationMethods.values())));
        }
    }

    protected void configure(HttpSecurity http) throws Exception {
        switch (this.getAuthenticationMethod()) {
            case none: {
                http.csrf().disable();
                break;
            }
            default: {
                ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).authorizeRequests().antMatchers(new String[]{"/", "/js/**", "/styles/**", "/fonts/**", "/images/**", "/public/**", "/wro.xml", "/dev.less", "/booting.html", "/upgrading.html", "/registration.html", "/favicon.ico", "/favicon.png", "/api/internal/license/**", "/productregistration", "/xltest.js", "/libs.js", "/xltest.css"})).permitAll().anyRequest()).fullyAuthenticated().and()).httpBasic().authenticationEntryPoint((AuthenticationEntryPoint)new Http401AuthenticationEntryPoint()).realmName("XL TestView");
            }
        }
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer() {
        return new PropertySourcesPlaceholderConfigurer();
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        switch (this.getAuthenticationMethod()) {
            case ldap: {
                LOG.info("Enabling LDAP security");
                String ldapUrl = this.config.getString("xlt.authentication.ldap.url");
                String ldapUserDnPattern = this.config.getString("xlt.authentication.ldap.user-dn");
                NullLdapAuthoritiesPopulator ldapAuthoritiesPopulator = new NullLdapAuthoritiesPopulator();
                if (Strings.isNullOrEmpty((String)ldapUserDnPattern)) {
                    String ldapUserSearchBase = this.config.getString("xlt.authentication.ldap.user-search-base");
                    String ldapUserSearchFilter = this.config.getString("xlt.authentication.ldap.user-search-filter");
                    auth.ldapAuthentication().userSearchBase(ldapUserSearchBase).ldapAuthoritiesPopulator((LdapAuthoritiesPopulator)ldapAuthoritiesPopulator).userSearchFilter(ldapUserSearchFilter).contextSource().url(ldapUrl);
                    break;
                }
                auth.ldapAuthentication().ldapAuthoritiesPopulator((LdapAuthoritiesPopulator)ldapAuthoritiesPopulator).userDnPatterns(new String[]{ldapUserDnPattern}).contextSource().url(ldapUrl);
                break;
            }
            case file: {
                LOG.info("Enabling simple file based security");
                Properties users = new Properties();
                users.load(((Object)((Object)this)).getClass().getResourceAsStream("/users.conf"));
                InMemoryUserDetailsManager inMemoryUserDetailsManager = new InMemoryUserDetailsManager(users);
                auth.userDetailsService((UserDetailsService)inMemoryUserDetailsManager);
                break;
            }
            case none: {
                auth.authenticationProvider((AuthenticationProvider)new AnonymousAuthenticationProvider("_"));
            }
        }
    }
}

