/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import java.util.UUID;

@Metadata(description="Tags can be put on test results, for example to identify common causes.", root=Metadata.ConfigurationItemRoot.CONFIGURATION, versioned=false)
public class Tag
extends BaseConfigurationItem {
    @Property(required=true, description="The text used for this tag in the UI.")
    private String title;
    @Property(required=false, description="The color of this tag in the UI. One of these html colors: dodger-blue, dark-orange, dark-orchid, crimson, lime-green, gold, blanced-almond, light-salmon.")
    private String color;
    @Property
    private String tagId;

    public Tag(String color, String title) {
        this(UUID.randomUUID().toString(), color, title);
    }

    public Tag() {
    }

    public Tag(String tagId, String color, String title) {
        this.tagId = tagId;
        this.color = color;
        this.title = title;
        this.id = "Configuration/Tags/" + tagId;
    }

    public String getColor() {
        return this.color;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTagId() {
        return this.tagId;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setTitle(String name) {
        this.title = name;
    }

    public void setTagId(String tagId) {
        this.tagId = tagId;
    }

    public void validate() {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getTitle()) ? 1 : 0) != 0, (Object)"title should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getColor()) ? 1 : 0) != 0, (Object)"color should not be empty");
        Preconditions.checkArgument((boolean)this.id.endsWith(this.getTagId()), (Object)String.format("the end of id (%s) should be equal to the tagId (%s)", this.id, this.getTagId()));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("color", (Object)this.color).add("title", (Object)this.title).add("tagId", (Object)this.tagId).toString();
    }
}

