/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.xebialabs.xlt.plugin.api.testrun.Event;
import com.xebialabs.xlt.plugin.api.testrun.TestRun;
import com.xebialabs.xltest.domain.NoTestRunFoundException;
import com.xebialabs.xltest.domain.QualificationResult;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRunImpl
implements TestRun {
    private static final Logger LOG = LoggerFactory.getLogger(TestRunImpl.class);
    private static final Set<String> standardProps = new HashSet<String>(Arrays.asList("@createdAt", "@testSpecification", "@runId", "@type"));
    private final String testRunId;
    private String testSpecificationName;
    private Date startTime;
    private Date finishedTime;
    private boolean qualificationResult;
    private String failureReason;
    private Map<String, Object> parameters;
    private int duration;

    public TestRunImpl(String id) {
        this.testRunId = id;
    }

    public TestRunImpl(List<Event> events) {
        this(events, null);
    }

    public TestRunImpl(List<Event> events, QualificationResult qualificationResult) {
        this.parameters = new HashMap<String, Object>();
        this.testRunId = this.findTestRunId(events);
        this.createTestRun(this.findEvent(events, "executionStarted"), this.findEvent(events, "importStarted"), this.findEvent(events, "importFinished"), this.findEvent(events, "executionFinished"), qualificationResult);
    }

    private String findTestRunId(List<Event> events) {
        return events.isEmpty() ? null : events.get(0).getTestRunId();
    }

    private Event findEvent(List<Event> events, String eventType) {
        for (Event ev : events) {
            if (!eventType.equals(ev.getType())) continue;
            return ev;
        }
        return null;
    }

    private void createTestRun(Event executionStartedEvent, Event importStartedEvent, Event importFinishedEvent, Event executionFinishedEvent, QualificationResult qualificationResult) {
        if (executionStartedEvent != null) {
            LOG.debug("Creating testRun with runId {} from startEvent {}", (Object)this.testRunId, (Object)executionStartedEvent);
            this.setTestSpecificationName((String)executionStartedEvent.getRequired("@testSpecification"));
            this.setStartTime(new Date(((Number)executionStartedEvent.getRequired("@createdAt")).longValue()));
            this.updateParameters(executionStartedEvent);
        } else if (importStartedEvent != null) {
            LOG.debug("Creating testRun with runId {} from importStartedEvent {}", (Object)this.testRunId, (Object)importStartedEvent);
            this.setTestSpecificationName((String)importStartedEvent.getRequired("@testSpecification"));
            this.setStartTime(new Date(((Number)importStartedEvent.getRequired("@testedAt")).longValue()));
            this.updateParameters(importStartedEvent);
        } else {
            throw new NoTestRunFoundException("Can't populate TestRun from these executionStarted or importStarted events. Both could not be found");
        }
        if (importFinishedEvent != null && importFinishedEvent.hasProperty("@createdAt")) {
            this.setFinishedTime(importFinishedEvent.getTimestampAsDate());
            this.duration = importFinishedEvent.getDuration();
            this.updateParameters(importFinishedEvent);
        } else if (executionFinishedEvent != null && executionFinishedEvent.hasProperty("@createdAt")) {
            this.setFinishedTime(executionFinishedEvent.getTimestampAsDate());
            this.updateParameters(executionFinishedEvent);
        }
        if (qualificationResult != null) {
            this.setQualificationResult(qualificationResult.getQualification());
            String failureReason = "";
            if (!Strings.isNullOrEmpty((String)qualificationResult.getLastFailureReason())) {
                failureReason = qualificationResult.getLastFailureReason();
            }
            this.setFailureReason(failureReason);
        }
    }

    private void updateParameters(Event event) {
        if (event != null) {
            for (String key : event.getProperties().keySet()) {
                if (standardProps.contains(key)) continue;
                this.parameters.put(key, event.get(key));
            }
        }
    }

    public String getId() {
        return this.testRunId;
    }

    public String getTestSpecificationName() {
        return this.testSpecificationName;
    }

    public void setTestSpecificationName(String testSpecificationName) {
        this.testSpecificationName = testSpecificationName;
    }

    public Date getStartTime() {
        return this.startTime != null ? new Date(this.startTime.getTime()) : null;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getFinishedTime() {
        return this.finishedTime != null ? new Date(this.finishedTime.getTime()) : null;
    }

    public void setFinishedTime(Date finishedTime) {
        this.finishedTime = finishedTime;
    }

    public boolean isFinished() {
        return this.finishedTime != null;
    }

    public boolean getQualificationResult() {
        return this.qualificationResult;
    }

    public void setQualificationResult(boolean qualificationResult) {
        this.qualificationResult = qualificationResult;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public int getDuration() {
        if (this.duration < 0) {
            return (int)(this.finishedTime.getTime() - this.startTime.getTime());
        }
        return this.duration;
    }

    @Deprecated
    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    @Deprecated
    public boolean hasParameter(String parameterName) {
        return this.getParameters() != null && this.getParameters().containsKey(parameterName);
    }

    @Deprecated
    public Object getParameter(String parameterName) {
        return this.getParameters().get(parameterName);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("testRunId", (Object)this.testRunId).add("testSpecificationName", (Object)this.testSpecificationName).add("startTime", (Object)this.startTime).add("finishedTime", (Object)this.finishedTime).add("qualificationResult", this.qualificationResult).add("failureReason", (Object)this.failureReason).add("parameters", this.parameters).add("@duration", this.duration).toString();
    }
}

