/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.domain;

import com.google.common.base.Strings;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalConnection;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xltest.utils.glob.FileMatcher;
import com.xebialabs.xltest.utils.glob.Globbit;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.SortedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestToolUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TestToolUtils.class);

    public static String findFolderClosestToSearchPathForTestResult(OverthereFile searchPath, OverthereFile resultsPath) {
        if (resultsPath == null) {
            return null;
        }
        if (searchPath.equals(resultsPath.getParentFile())) {
            return resultsPath.getName();
        }
        return TestToolUtils.findFolderClosestToSearchPathForTestResult(searchPath, resultsPath.getParentFile());
    }

    public static String[] getSplittedSuiteName(String name) {
        ArrayList<String> result = new ArrayList<String>();
        int lastDot = name.lastIndexOf(46);
        if (lastDot < 0) {
            result.add(name);
            return result.toArray(new String[1]);
        }
        String packageName = name.substring(0, lastDot);
        String className = name.substring(lastDot + 1);
        if (Strings.isNullOrEmpty((String)packageName) || Strings.isNullOrEmpty((String)className)) {
            result.add(name);
            return result.toArray(new String[1]);
        }
        result.add(packageName);
        result.add(className);
        return result.toArray(new String[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocalFile retrieveFiles(OverthereFile remoteFile) {
        LocalFile tempFolder = null;
        try {
            if (remoteFile instanceof LocalFile) {
                LocalFile localFile = (LocalFile)remoteFile;
                return localFile;
            }
            tempFolder = TestToolUtils.getLocalTempFolder();
            LOG.info("Will copy files from {} to {}", (Object)remoteFile, (Object)tempFolder);
            remoteFile.copyTo((OverthereFile)tempFolder);
            LOG.info("Copied FitNesseRoot to {}", (Object)tempFolder);
            LocalFile localFile = tempFolder;
            return localFile;
        }
        finally {
            if (tempFolder != null) {
                tempFolder.getConnection().close();
            }
        }
    }

    public static LocalFile getLocalTempFolder() {
        File tempFile;
        try {
            tempFile = File.createTempFile("xltesttool", "");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create temp file", e);
        }
        tempFile.delete();
        tempFile.mkdirs();
        LocalConnection localConnection = new LocalConnection("local", new ConnectionOptions());
        return new LocalFile(localConnection, tempFile);
    }

    public static SortedSet<OverthereFile> globFilesAndDirectories(OverthereFile root, FileMatcher matcher) {
        return Globbit.find(root, matcher, Globbit.GlobMode.FILES_AND_DIRECTORIES);
    }

    public static final SortedSet<OverthereFile> globFiles(OverthereFile root, FileMatcher matcher) {
        return Globbit.find(root, matcher, Globbit.GlobMode.FILES_ONLY);
    }
}

