/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.serialize.exceptionmappers;

import com.xebialabs.xltest.serialize.exceptionmappers.AbstractExceptionMapper;
import com.xebialabs.xltest.service.ConcurrentImportException;
import java.util.Map;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Provider
@Produces(value={"application/json"})
public class ConcurrentImportExceptionMapper
extends AbstractExceptionMapper
implements ExceptionMapper<ConcurrentImportException> {
    private static final Logger LOG = LoggerFactory.getLogger(ConcurrentImportExceptionMapper.class);

    public Response toResponse(ConcurrentImportException exception) {
        Map<String, Object> response = this.getBaseResponse();
        LOG.error("Error with id={}", response.get("id"), (Object)exception);
        response.put("message", exception.getMessage());
        response.put("status", 409);
        response.put("error_code", "concurrent.import");
        return Response.status((int)409).type("application/json").entity(response).build();
    }
}

