/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.service;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.xebialabs.xlt.plugin.api.resultparser.TestRunHistorian;
import com.xebialabs.xlt.plugin.api.testrun.Event;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.repository.EventRepository;
import java.util.List;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.FilteredQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRunHistorianImpl
implements TestRunHistorian {
    private static final Logger LOG = LoggerFactory.getLogger(TestRunHistorianImpl.class);
    private final BaseTestSpecification testSpecification;
    private final EventRepository eventRepository;

    public TestRunHistorianImpl(BaseTestSpecification testSpecification, EventRepository eventRepository) {
        this.eventRepository = (EventRepository)Preconditions.checkNotNull((Object)eventRepository, (Object)"Event repository is required.");
        this.testSpecification = (BaseTestSpecification)((Object)Preconditions.checkNotNull((Object)((Object)testSpecification)));
    }

    public long timeOfLatestTestRun() {
        Event event = this.eventRepository.fetchLatest(this.testSpecification.getName(), "importStarted");
        if (event == null) {
            return 0L;
        }
        LOG.debug("Testspecification id={} timeOfLatestTestRun={}", (Object)this.testSpecification.getName(), (Object)event.getTestedAt());
        return event.getTestedAt();
    }

    public boolean isKnownKey(String key) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0);
        LOG.trace("Checking existence of previous run with key {}", (Object)key);
        FilteredQueryBuilder qb = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.termFilter((String)"@type", (String)"importStarted"), FilterBuilders.termFilter((String)"@testSpecification", (String)this.testSpecification.getName()), FilterBuilders.termFilter((String)"@runKey", (String)key)}));
        List<Event> queryResult = this.eventRepository.query((QueryBuilder)qb);
        boolean isKnown = !queryResult.isEmpty();
        LOG.debug("Testspecification id={} key={} isKnown={}", new Object[]{this.testSpecification.getName(), key, isKnown});
        return isKnown;
    }
}

