/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.CollectionUtils;
import org.springframework.web.method.ControllerAdviceBean;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

class ResponseBodyAdviceChain {
    private final List<Object> advice;

    public ResponseBodyAdviceChain(List<Object> advice) {
        this.advice = advice;
    }

    public boolean hasAdvice() {
        return !CollectionUtils.isEmpty(this.advice);
    }

    public <T> T invoke(T body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (this.advice != null) {
            for (Object advice : this.advice) {
                if (advice instanceof ControllerAdviceBean) {
                    ControllerAdviceBean adviceBean = (ControllerAdviceBean)advice;
                    if (!adviceBean.isApplicableToBeanType(returnType.getContainingClass())) continue;
                    advice = adviceBean.resolveBean();
                }
                if (advice instanceof ResponseBodyAdvice) {
                    ResponseBodyAdvice typedAdvice = (ResponseBodyAdvice)advice;
                    if (!typedAdvice.supports(returnType, selectedConverterType)) continue;
                    body = typedAdvice.beforeBodyWrite(body, returnType, selectedContentType, selectedConverterType, request, response);
                    continue;
                }
                throw new IllegalStateException("Expected ResponseBodyAdvice: " + advice);
            }
        }
        return body;
    }
}

