/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    STRING_KEYED_JDBC_STORE("string-keyed-jdbc-store"),
    BINARY_KEYED_JDBC_STORE("binary-keyed-jdbc-store"),
    MIXED_KEYED_JDBC_STORE("mixed-keyed-jdbc-store"),
    CONNECTION_POOL("connection-pool"),
    DATA_SOURCE("data-source"),
    SIMPLE_CONNECTION("simple-connection"),
    BINARY_KEYED_TABLE("binary-keyed-table"),
    STRING_KEYED_TABLE("string-keyed-table"),
    DATA_COLUMN("data-column"),
    ID_COLUMN("id-column"),
    TIMESTAMP_COLUMN("timestamp-column");

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>(8);
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

