/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.util.matcher;

import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AndRequestMatcher
implements RequestMatcher {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final List<RequestMatcher> requestMatchers;

    public AndRequestMatcher(List<RequestMatcher> requestMatchers) {
        Assert.notEmpty(requestMatchers, (String)"requestMatchers must contain a value");
        if (requestMatchers.contains(null)) {
            throw new IllegalArgumentException("requestMatchers cannot contain null values");
        }
        this.requestMatchers = requestMatchers;
    }

    public AndRequestMatcher(RequestMatcher ... requestMatchers) {
        this(Arrays.asList(requestMatchers));
    }

    @Override
    public boolean matches(HttpServletRequest request) {
        for (RequestMatcher matcher : this.requestMatchers) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Trying to match using " + matcher));
            }
            if (matcher.matches(request)) continue;
            this.logger.debug((Object)"Did not match");
            return false;
        }
        this.logger.debug((Object)"All requestMatchers returned true");
        return true;
    }

    public String toString() {
        return "AndRequestMatcher [requestMatchers=" + this.requestMatchers + "]";
    }
}

