/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.modeshape.common.collection.UnmodifiableProperties;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrRepository;

public final class ModeShape {
    private static final Properties bundleProperties = ModeShape.loadBundleProperties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties loadBundleProperties() {
        UnmodifiableProperties unmodifiableProperties;
        InputStream stream = null;
        try {
            stream = JcrRepository.class.getClassLoader().getResourceAsStream("org/modeshape/jcr/repository.properties");
            assert (stream != null);
            Properties props = new Properties();
            props.load(stream);
            unmodifiableProperties = new UnmodifiableProperties(props);
            if (stream == null) return unmodifiableProperties;
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(JcrI18n.failedToReadPropertiesFromManifest.text(new Object[]{e.getLocalizedMessage()}), e);
            }
            catch (Throwable throwable) {
                if (stream == null) throw throwable;
                try {
                    try {
                        stream.close();
                        stream = null;
                        throw throwable;
                    }
                    catch (IOException e2) {
                        stream = null;
                        throw throwable;
                    }
                }
                catch (Throwable throwable2) {
                    stream = null;
                    throw throwable2;
                }
            }
        }
        try {
            stream.close();
            return unmodifiableProperties;
        }
        catch (IOException iOException) {
            return unmodifiableProperties;
        }
        finally {
            stream = null;
        }
    }

    public static final String getName() {
        return bundleProperties.getProperty("name");
    }

    public static final String getVendor() {
        return bundleProperties.getProperty("vendor");
    }

    public static final String getUrl() {
        return bundleProperties.getProperty("url");
    }

    public static final String getVersion() {
        return bundleProperties.getProperty("version");
    }

    static {
        Logger.getLogger(JcrRepository.class).info((I18nResource)JcrI18n.initializing, new Object[]{ModeShape.getName(), ModeShape.getVersion()});
    }
}

